/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.properties;

import java.util.Map;
import net.sourceforge.pmd.PropertyDescriptorFactory;
import net.sourceforge.pmd.lang.rule.properties.AbstractMultiNumericProperty;
import net.sourceforge.pmd.lang.rule.properties.factories.BasicPropertyDescriptorFactory;

public class FloatMultiProperty
extends AbstractMultiNumericProperty<Float[]> {
    public static final PropertyDescriptorFactory FACTORY = new BasicPropertyDescriptorFactory<FloatMultiProperty>(Float[].class, NUMBER_FIELD_TYPES_BY_KEY){

        public FloatMultiProperty createWith(Map<String, String> valuesById) {
            String[] minMax = 1.minMaxFrom(valuesById);
            char delimiter = 1.delimiterIn(valuesById, ',');
            Float[] defaultValues = 1.floatsIn(this.numericDefaultValueIn(valuesById), delimiter);
            return new FloatMultiProperty(this.nameIn(valuesById), this.descriptionIn(valuesById), Float.valueOf(Float.parseFloat(minMax[0])), Float.valueOf(Float.parseFloat(minMax[1])), defaultValues, 0.0f);
        }
    };

    public FloatMultiProperty(String theName, String theDescription, Float min, Float max, Float[] defaultValues, float theUIOrder) {
        super(theName, theDescription, min, max, defaultValues, theUIOrder);
    }

    @Override
    public Class<Float[]> type() {
        return Float[].class;
    }

    @Override
    protected Object createFrom(String value) {
        return Float.valueOf(value);
    }

    @Override
    protected Object[] arrayFor(int size) {
        return new Float[size];
    }
}

