/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.PMD;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.BOMInputStream;

public class SourceCode {
    private CodeLoader cl;

    public SourceCode(CodeLoader cl) {
        this.cl = cl;
    }

    public List<String> getCode() {
        return this.cl.getCode();
    }

    public StringBuilder getCodeBuffer() {
        StringBuilder sb = new StringBuilder();
        List<String> lines = this.cl.getCode();
        for (String line : lines) {
            sb.append(line).append(PMD.EOL);
        }
        return sb;
    }

    public String getSlice(int startLine, int endLine) {
        List<String> lines = this.cl.getCodeSlice(startLine - 1, endLine);
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            if (sb.length() != 0) {
                sb.append(PMD.EOL);
            }
            sb.append(line);
        }
        return sb.toString();
    }

    public String getFileName() {
        return this.cl.getFileName();
    }

    public static class ReaderCodeLoader
    extends CodeLoader {
        public static final String DEFAULT_NAME = "CODE_LOADED_FROM_READER";
        private Reader code;
        private String name;

        public ReaderCodeLoader(Reader code) {
            this(code, DEFAULT_NAME);
        }

        public ReaderCodeLoader(Reader code, String name) {
            this.code = code;
            this.name = name;
        }

        @Override
        public Reader getReader() {
            return this.code;
        }

        @Override
        public String getFileName() {
            return this.name;
        }
    }

    public static class StringCodeLoader
    extends CodeLoader {
        public static final String DEFAULT_NAME = "CODE_LOADED_FROM_STRING";
        private String code;
        private String name;

        public StringCodeLoader(String code) {
            this(code, DEFAULT_NAME);
        }

        public StringCodeLoader(String code, String name) {
            this.code = code;
            this.name = name;
        }

        @Override
        public Reader getReader() {
            return new StringReader(this.code);
        }

        @Override
        public String getFileName() {
            return this.name;
        }
    }

    public static class FileCodeLoader
    extends CodeLoader {
        private File file;
        private String encoding;

        public FileCodeLoader(File file, String encoding) {
            this.file = file;
            this.encoding = encoding;
        }

        @Override
        public Reader getReader() throws Exception {
            BOMInputStream inputStream = new BOMInputStream((InputStream)new FileInputStream(this.file), new ByteOrderMark[]{ByteOrderMark.UTF_8, ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_16LE});
            if (inputStream.hasBOM()) {
                this.encoding = inputStream.getBOMCharsetName();
            }
            return new InputStreamReader((InputStream)inputStream, this.encoding);
        }

        public String getEncoding() {
            return this.encoding;
        }

        @Override
        public String getFileName() {
            return this.file.getAbsolutePath();
        }
    }

    public static abstract class CodeLoader {
        private SoftReference<List<String>> code;

        public List<String> getCode() {
            List<String> c = null;
            if (this.code != null) {
                c = this.code.get();
            }
            if (c != null) {
                return c;
            }
            this.code = new SoftReference<List<String>>(this.load());
            return this.code.get();
        }

        public List<String> getCodeSlice(int startLine, int endLine) {
            List<String> c = null;
            if (this.code != null) {
                c = this.code.get();
            }
            if (c != null) {
                return c.subList(startLine, endLine);
            }
            return this.load(startLine, endLine);
        }

        public abstract String getFileName();

        protected abstract Reader getReader() throws Exception;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected List<String> load() {
            try (BufferedReader reader = new BufferedReader(this.getReader());){
                String currentLine;
                ArrayList<String> lines = new ArrayList<String>();
                while ((currentLine = reader.readLine()) != null) {
                    lines.add(currentLine);
                }
                ArrayList<String> arrayList = lines;
                return arrayList;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Problem while reading " + this.getFileName() + ":" + e.getMessage());
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected List<String> load(int startLine, int endLine) {
            try (BufferedReader reader = new BufferedReader(this.getReader());){
                String currentLine;
                int linesToRead = endLine - startLine;
                ArrayList<String> lines = new ArrayList<String>(linesToRead);
                for (int i = 0; i < startLine; ++i) {
                    reader.readLine();
                }
                while ((currentLine = reader.readLine()) != null) {
                    lines.add(currentLine);
                    if (lines.size() != linesToRead) continue;
                }
                ArrayList<String> arrayList = lines;
                return arrayList;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Problem while reading " + this.getFileName() + ":" + e.getMessage());
            }
        }
    }
}

