/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSetNotFoundException;
import net.sourceforge.pmd.RuleSets;
import net.sourceforge.pmd.benchmark.Benchmark;
import net.sourceforge.pmd.benchmark.Benchmarker;

public final class RulesetsFactoryUtils {
    private static final Logger LOG = Logger.getLogger(RulesetsFactoryUtils.class.getName());

    private RulesetsFactoryUtils() {
    }

    public static RuleSets getRuleSets(String rulesets, RuleSetFactory factory) {
        RuleSets ruleSets = null;
        try {
            factory.setWarnDeprecated(true);
            ruleSets = factory.createRuleSets(rulesets);
            factory.setWarnDeprecated(false);
            RulesetsFactoryUtils.printRuleNamesInDebug(ruleSets);
            if (ruleSets.ruleCount() == 0) {
                String msg = "No rules found. Maybe you mispelled a rule name? (" + rulesets + ")";
                LOG.log(Level.SEVERE, msg);
                throw new IllegalArgumentException(msg);
            }
        }
        catch (RuleSetNotFoundException rsnfe) {
            LOG.log(Level.SEVERE, "Ruleset not found", rsnfe);
            throw new IllegalArgumentException(rsnfe);
        }
        return ruleSets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RuleSets getRuleSetsWithBenchmark(String rulesets, RuleSetFactory factory) {
        long loadRuleStart = System.nanoTime();
        RuleSets ruleSets = null;
        try {
            ruleSets = RulesetsFactoryUtils.getRuleSets(rulesets, factory);
        }
        finally {
            long endLoadRules = System.nanoTime();
            Benchmarker.mark(Benchmark.LoadRules, endLoadRules - loadRuleStart, 0L);
        }
        return ruleSets;
    }

    public static RuleSetFactory getRulesetFactory(PMDConfiguration configuration) {
        RuleSetFactory ruleSetFactory = new RuleSetFactory();
        ruleSetFactory.setMinimumPriority(configuration.getMinimumPriority());
        if (!configuration.isRuleSetFactoryCompatibilityEnabled()) {
            ruleSetFactory.disableCompatibilityFilter();
        }
        return ruleSetFactory;
    }

    private static void printRuleNamesInDebug(RuleSets rulesets) {
        if (LOG.isLoggable(Level.FINER)) {
            for (Rule r : rulesets.getAllRules()) {
                LOG.finer("Loaded rule " + r.getName());
            }
        }
    }
}

