/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.junit;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.lang.java.ast.ASTArguments;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.rule.junit.AbstractJUnitRule;

public class JUnitAssertionsShouldIncludeMessageRule
extends AbstractJUnitRule {
    private List<AssertionCall> checks = new ArrayList<AssertionCall>();

    public JUnitAssertionsShouldIncludeMessageRule() {
        this.checks.add(new AssertionCall("assertArrayEquals", 2));
        this.checks.add(new AssertionCall("assertEquals", 2));
        this.checks.add(new AssertionCall("assertFalse", 1));
        this.checks.add(new AssertionCall("assertNotNull", 1));
        this.checks.add(new AssertionCall("assertNotSame", 2));
        this.checks.add(new AssertionCall("assertNull", 1));
        this.checks.add(new AssertionCall("assertSame", 2));
        this.checks.add(new AssertionCall("assertThat", 2));
        this.checks.add(new AssertionCall("assertTrue", 1));
        this.checks.add(new AssertionCall("fail", 0));
        this.checks.add(new AssertionCall("assertEquals", 3){

            @Override
            protected boolean isException(ASTArguments node) {
                ASTExpression firstArgument = (ASTExpression)node.getFirstDescendantOfType(ASTExpression.class);
                return firstArgument.getType() == null || firstArgument.getType() == String.class;
            }
        });
    }

    @Override
    public Object visit(ASTArguments node, Object data) {
        for (AssertionCall call : this.checks) {
            call.check(data, node);
        }
        return super.visit(node, data);
    }

    private class AssertionCall {
        private final int argumentsCount;
        private final String assertionName;

        public AssertionCall(String assertionName, int argumentsCount) {
            this.argumentsCount = argumentsCount;
            this.assertionName = assertionName;
        }

        public void check(Object ctx, ASTArguments node) {
            ASTName name;
            ASTPrimaryExpression primary;
            if (node.getArgumentCount() == this.argumentsCount && node.jjtGetParent().jjtGetParent() instanceof ASTPrimaryExpression && (primary = (ASTPrimaryExpression)node.jjtGetParent().jjtGetParent()).jjtGetChild(0) instanceof ASTPrimaryPrefix && primary.jjtGetChild(0).jjtGetNumChildren() > 0 && primary.jjtGetChild(0).jjtGetChild(0) instanceof ASTName && (name = (ASTName)primary.jjtGetChild(0).jjtGetChild(0)).hasImageEqualTo(this.assertionName)) {
                if (this.isException(node)) {
                    return;
                }
                JUnitAssertionsShouldIncludeMessageRule.this.addViolation(ctx, name);
            }
        }

        protected boolean isException(ASTArguments node) {
            return false;
        }
    }
}

