/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.datasource;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.sourceforge.pmd.util.datasource.DataSource;

public class FileDataSource
implements DataSource {
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private File file;

    public FileDataSource(File file) {
        this.file = file;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public String getNiceFileName(boolean shortNames, String inputFileName) {
        return this.glomName(shortNames, inputFileName, this.file);
    }

    private String glomName(boolean shortNames, String inputFileName, File file) {
        if (shortNames && inputFileName.indexOf(44) == -1) {
            if (new File(inputFileName).isDirectory()) {
                return this.trimAnyPathSep(file.getPath().substring(inputFileName.length()));
            }
            if (inputFileName.indexOf(FILE_SEPARATOR.charAt(0)) == -1) {
                return inputFileName;
            }
            return this.trimAnyPathSep(inputFileName.substring(inputFileName.lastIndexOf(FILE_SEPARATOR)));
        }
        try {
            return file.getCanonicalFile().getAbsolutePath();
        }
        catch (Exception e) {
            return file.getAbsolutePath();
        }
    }

    private String trimAnyPathSep(String name) {
        return name.startsWith(FILE_SEPARATOR) ? name.substring(1) : name;
    }
}

