/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Iterator;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.renderers.AbstractIncrementingRenderer;
import net.sourceforge.pmd.renderers.CodeClimateIssue;
import net.sourceforge.pmd.renderers.CodeClimateRule;
import org.apache.commons.lang3.StringUtils;

public class CodeClimateRenderer
extends AbstractIncrementingRenderer {
    public static final String NAME = "codeclimate";
    public static final String BODY_PLACEHOLDER = "REPLACE_THIS_WITH_MARKDOWN";
    public static final int REMEDIATION_POINTS_DEFAULT = 50000;
    public static final String[] CODECLIMATE_DEFAULT_CATEGORIES = new String[]{"Style"};
    protected static final String NULL_CHARACTER = "\u0000";
    private Rule rule;
    private final String pmdDeveloperUrl = CodeClimateRenderer.getPmdDeveloperURL();

    public CodeClimateRenderer() {
        super(NAME, "Code Climate integration.");
    }

    @Override
    public void renderFileViolations(Iterator<RuleViolation> violations) throws IOException {
        Writer writer = this.getWriter();
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        while (violations.hasNext()) {
            RuleViolation rv = violations.next();
            this.rule = rv.getRule();
            String json = gson.toJson((Object)this.asIssue(rv));
            json = json.replace(BODY_PLACEHOLDER, this.getBody());
            writer.write(json + NULL_CHARACTER + PMD.EOL);
        }
    }

    private CodeClimateIssue asIssue(RuleViolation rv) {
        CodeClimateIssue issue = new CodeClimateIssue();
        issue.check_name = this.rule.getName();
        issue.description = this.cleaned(rv.getDescription());
        issue.content = new CodeClimateIssue.Content(BODY_PLACEHOLDER);
        issue.location = this.getLocation(rv);
        issue.remediation_points = this.getRemediationPoints();
        issue.categories = this.getCategories();
        switch (this.rule.getPriority()) {
            case HIGH: {
                issue.severity = "critical";
                break;
            }
            case MEDIUM_HIGH: 
            case MEDIUM: 
            case MEDIUM_LOW: {
                issue.severity = "normal";
                break;
            }
            case LOW: {
                issue.severity = "info";
            }
        }
        return issue;
    }

    @Override
    public String defaultFileExtension() {
        return "json";
    }

    private CodeClimateIssue.Location getLocation(RuleViolation rv) {
        String pathWithoutCcRoot = StringUtils.removeStartIgnoreCase((String)rv.getFilename(), (String)"/code/");
        CodeClimateIssue.Location result = this.rule.hasDescriptor(CodeClimateRule.CODECLIMATE_REMEDIATION_MULTIPLIER) && this.rule.getProperty(CodeClimateRule.CODECLIMATE_BLOCK_HIGHLIGHTING) == false ? new CodeClimateIssue.Location(pathWithoutCcRoot, rv.getBeginLine(), rv.getBeginLine()) : new CodeClimateIssue.Location(pathWithoutCcRoot, rv.getBeginLine(), rv.getEndLine());
        return result;
    }

    private int getRemediationPoints() {
        int remediation_points = 50000;
        if (this.rule.hasDescriptor(CodeClimateRule.CODECLIMATE_REMEDIATION_MULTIPLIER)) {
            remediation_points *= this.rule.getProperty(CodeClimateRule.CODECLIMATE_REMEDIATION_MULTIPLIER).intValue();
        }
        return remediation_points;
    }

    private String[] getCategories() {
        String[] result;
        if (this.rule.hasDescriptor(CodeClimateRule.CODECLIMATE_CATEGORIES)) {
            Object[] categories = this.rule.getProperty(CodeClimateRule.CODECLIMATE_CATEGORIES);
            result = new String[categories.length];
            for (int i = 0; i < categories.length; ++i) {
                result[i] = String.valueOf(categories[i]);
            }
        } else {
            result = CODECLIMATE_DEFAULT_CATEGORIES;
        }
        return result;
    }

    private static String getPmdDeveloperURL() {
        String url = "http://pmd.github.io/pmd-" + PMD.VERSION + "/customizing/pmd-developer.html";
        if (PMD.VERSION.contains("SNAPSHOT") || "unknown".equals(PMD.VERSION)) {
            url = "http://pmd.sourceforge.net/snapshot/customizing/pmd-developer.html";
        }
        return url;
    }

    private <T> String getBody() {
        String result = "## " + this.rule.getName() + "\\n\\n" + "Since: PMD " + this.rule.getSince() + "\\n\\n" + "Priority: " + (Object)((Object)this.rule.getPriority()) + "\\n\\n" + "[Categories](https://github.com/codeclimate/spec/blob/master/SPEC.md#categories): " + Arrays.toString(this.getCategories()).replaceAll("[\\[\\]]", "") + "\\n\\n" + "[Remediation Points](https://github.com/codeclimate/spec/blob/master/SPEC.md#remediation-points): " + this.getRemediationPoints() + "\\n\\n" + this.cleaned(this.rule.getDescription());
        if (!this.rule.getExamples().isEmpty()) {
            result = result + "\\n\\n### Example:\\n\\n";
            for (String string : this.rule.getExamples()) {
                String string3 = string.replaceAll("\\n", "\\\\n");
                string3 = string3.replaceAll("\\t", "\\\\t");
                result = result + "```java\\n" + string3 + "\\n```  ";
            }
        }
        if (!this.rule.getPropertyDescriptors().isEmpty()) {
            result = result + "\\n\\n### [PMD properties](" + this.pmdDeveloperUrl + ")\\n\\n";
            result = result + "Name | Value | Description\\n";
            result = result + "--- | --- | ---\\n";
            for (PropertyDescriptor propertyDescriptor : this.rule.getPropertyDescriptors()) {
                Object value;
                PropertyDescriptor typed = propertyDescriptor;
                String propertyValue = typed.asDelimitedString(value = this.rule.getProperty(typed));
                if (propertyValue == null) {
                    propertyValue = "";
                }
                propertyValue = propertyValue.replaceAll("(\n|\r\n|\r)", "\\\\n");
                String porpertyName = propertyDescriptor.name();
                porpertyName = porpertyName.replaceAll("\\_", "\\\\_");
                result = result + porpertyName + " | " + propertyValue + " | " + propertyDescriptor.description() + "\\n";
            }
        }
        return this.cleaned(result);
    }

    private String cleaned(String original) {
        String result = original.trim();
        result = result.replaceAll("\\s+", " ");
        result = result.replaceAll("\\s*[\\r\\n]+\\s*", "");
        result = result.replaceAll("\"", "'");
        return result;
    }
}

