/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;

public class Mark
implements Comparable<Mark> {
    private TokenEntry token;
    private int lineCount;
    private SourceCode code;

    public Mark(TokenEntry token) {
        this.token = token;
    }

    public TokenEntry getToken() {
        return this.token;
    }

    public String getFilename() {
        return this.token.getTokenSrcID();
    }

    public int getBeginLine() {
        return this.token.getBeginLine();
    }

    public int getEndLine() {
        return this.getBeginLine() + this.getLineCount() - 1;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public void setLineCount(int lineCount) {
        this.lineCount = lineCount;
    }

    public String getSourceCodeSlice() {
        return this.code.getSlice(this.getBeginLine(), this.getEndLine());
    }

    public void setSourceCode(SourceCode code) {
        this.code = code;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.token == null ? 0 : this.token.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Mark other = (Mark)obj;
        return !(this.token == null ? other.token != null : !this.token.equals(other.token));
    }

    @Override
    public int compareTo(Mark other) {
        return this.getToken().compareTo(other.getToken());
    }
}

