/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.util.Iterator;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.cpd.Mark;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.Renderer;
import org.apache.commons.lang3.StringEscapeUtils;

public class CSVRenderer
implements Renderer {
    private char separator;
    private boolean lineCountPerFile;
    public static final char DEFAULT_SEPARATOR = ',';
    public static final boolean DEFAULT_LINECOUNTPERFILE = false;

    public CSVRenderer() {
        this(',', false);
    }

    public CSVRenderer(boolean lineCountPerFile) {
        this(',', lineCountPerFile);
    }

    public CSVRenderer(char separatorChar) {
        this(separatorChar, false);
    }

    public CSVRenderer(char separatorChar, boolean lineCountPerFile) {
        this.separator = separatorChar;
        this.lineCountPerFile = lineCountPerFile;
    }

    @Override
    public String render(Iterator<Match> matches) {
        StringBuilder csv = new StringBuilder(1000);
        if (!this.lineCountPerFile) {
            csv.append("lines").append(this.separator);
        }
        csv.append("tokens").append(this.separator).append("occurrences").append(PMD.EOL);
        while (matches.hasNext()) {
            Match match = matches.next();
            if (!this.lineCountPerFile) {
                csv.append(match.getLineCount()).append(this.separator);
            }
            csv.append(match.getTokenCount()).append(this.separator).append(match.getMarkCount()).append(this.separator);
            Iterator<Mark> marks = match.iterator();
            while (marks.hasNext()) {
                Mark mark = marks.next();
                csv.append(mark.getBeginLine()).append(this.separator);
                if (this.lineCountPerFile) {
                    csv.append(mark.getLineCount()).append(this.separator);
                }
                csv.append(StringEscapeUtils.escapeCsv((String)mark.getFilename()));
                if (!marks.hasNext()) continue;
                csv.append(this.separator);
            }
            csv.append(PMD.EOL);
        }
        return csv.toString();
    }
}

