/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.comments;

import java.util.Arrays;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaAccessNode;
import net.sourceforge.pmd.lang.java.rule.comments.AbstractCommentRule;
import net.sourceforge.pmd.lang.rule.properties.EnumeratedProperty;

public class CommentRequiredRule
extends AbstractCommentRule {
    public static final EnumeratedProperty<CommentRequirement> HEADER_CMT_REQUIREMENT_DESCRIPTOR = new EnumeratedProperty("headerCommentRequirement", "Header comments. Possible values: " + Arrays.toString((Object[])CommentRequirement.values()), CommentRequirement.labels(), (Object[])CommentRequirement.values(), 0, 1.0f);
    public static final EnumeratedProperty<CommentRequirement> FIELD_CMT_REQUIREMENT_DESCRIPTOR = new EnumeratedProperty("fieldCommentRequirement", "Field comments. Possible values: " + Arrays.toString((Object[])CommentRequirement.values()), CommentRequirement.labels(), (Object[])CommentRequirement.values(), 0, 2.0f);
    public static final EnumeratedProperty<CommentRequirement> PUB_METHOD_CMT_REQUIREMENT_DESCRIPTOR = new EnumeratedProperty("publicMethodCommentRequirement", "Public method and constructor comments. Possible values: " + Arrays.toString((Object[])CommentRequirement.values()), CommentRequirement.labels(), (Object[])CommentRequirement.values(), 0, 3.0f);
    public static final EnumeratedProperty<CommentRequirement> PROT_METHOD_CMT_REQUIREMENT_DESCRIPTOR = new EnumeratedProperty("protectedMethodCommentRequirement", "Protected method constructor comments. Possible values: " + Arrays.toString((Object[])CommentRequirement.values()), CommentRequirement.labels(), (Object[])CommentRequirement.values(), 0, 4.0f);
    public static final EnumeratedProperty<CommentRequirement> ENUM_CMT_REQUIREMENT_DESCRIPTOR = new EnumeratedProperty("enumCommentRequirement", "Enum comments. Possible values: " + Arrays.toString((Object[])CommentRequirement.values()), CommentRequirement.labels(), (Object[])CommentRequirement.values(), 0, 5.0f);
    public static final EnumeratedProperty<CommentRequirement> SERIAL_VERSION_UID_CMT_REQUIREMENT_DESCRIPTOR = new EnumeratedProperty("serialVersionUIDCommentRequired", "serial version UID commts. Possible values: " + Arrays.toString((Object[])CommentRequirement.values()), CommentRequirement.labels(), (Object[])CommentRequirement.values(), 1, 6.0f);

    public CommentRequiredRule() {
        this.definePropertyDescriptor((PropertyDescriptor)HEADER_CMT_REQUIREMENT_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)FIELD_CMT_REQUIREMENT_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)PUB_METHOD_CMT_REQUIREMENT_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)PROT_METHOD_CMT_REQUIREMENT_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)ENUM_CMT_REQUIREMENT_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)SERIAL_VERSION_UID_CMT_REQUIREMENT_DESCRIPTOR);
    }

    private CommentRequirement getCommentRequirement(String label) {
        if (CommentRequirement.Ignored.label.equals(label)) {
            return CommentRequirement.Ignored;
        }
        if (CommentRequirement.Required.label.equals(label)) {
            return CommentRequirement.Required;
        }
        if (CommentRequirement.Unwanted.label.equals(label)) {
            return CommentRequirement.Unwanted;
        }
        return null;
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration decl, Object data) {
        CommentRequirement headerRequirement = this.getCommentRequirement(this.getProperty((PropertyDescriptor)HEADER_CMT_REQUIREMENT_DESCRIPTOR).toString());
        if (headerRequirement != CommentRequirement.Ignored) {
            if (headerRequirement == CommentRequirement.Required) {
                if (decl.comment() == null) {
                    this.addViolationWithMessage(data, decl, HEADER_CMT_REQUIREMENT_DESCRIPTOR.name() + " " + (Object)((Object)CommentRequirement.Required), decl.getBeginLine(), decl.getEndLine());
                }
            } else if (decl.comment() != null) {
                this.addViolationWithMessage(data, decl, HEADER_CMT_REQUIREMENT_DESCRIPTOR.name() + " " + (Object)((Object)CommentRequirement.Unwanted), decl.getBeginLine(), decl.getEndLine());
            }
        }
        return super.visit(decl, data);
    }

    @Override
    public Object visit(ASTConstructorDeclaration decl, Object data) {
        this.checkComment(decl, data);
        return super.visit(decl, data);
    }

    @Override
    public Object visit(ASTMethodDeclaration decl, Object data) {
        this.checkComment(decl, data);
        return super.visit(decl, data);
    }

    private void checkComment(AbstractJavaAccessNode decl, Object data) {
        CommentRequirement pubMethodRequirement = this.getCommentRequirement(this.getProperty((PropertyDescriptor)PUB_METHOD_CMT_REQUIREMENT_DESCRIPTOR).toString());
        CommentRequirement protMethodRequirement = this.getCommentRequirement(this.getProperty((PropertyDescriptor)PROT_METHOD_CMT_REQUIREMENT_DESCRIPTOR).toString());
        if (decl.isPublic()) {
            if (pubMethodRequirement != CommentRequirement.Ignored) {
                if (pubMethodRequirement == CommentRequirement.Required) {
                    if (decl.comment() == null) {
                        this.addViolationWithMessage(data, decl, PUB_METHOD_CMT_REQUIREMENT_DESCRIPTOR.name() + " " + (Object)((Object)CommentRequirement.Required), decl.getBeginLine(), decl.getEndLine());
                    }
                } else if (decl.comment() != null) {
                    this.addViolationWithMessage(data, decl, PUB_METHOD_CMT_REQUIREMENT_DESCRIPTOR.name() + " " + (Object)((Object)CommentRequirement.Unwanted), decl.getBeginLine(), decl.getEndLine());
                }
            }
        } else if (decl.isProtected() && protMethodRequirement != CommentRequirement.Ignored) {
            if (protMethodRequirement == CommentRequirement.Required) {
                if (decl.comment() == null) {
                    this.addViolationWithMessage(data, decl, PROT_METHOD_CMT_REQUIREMENT_DESCRIPTOR.name() + " " + (Object)((Object)CommentRequirement.Required), decl.getBeginLine(), decl.getEndLine());
                }
            } else if (decl.comment() != null) {
                this.addViolationWithMessage(data, decl, PROT_METHOD_CMT_REQUIREMENT_DESCRIPTOR.name() + " " + (Object)((Object)CommentRequirement.Unwanted), decl.getBeginLine(), decl.getEndLine());
            }
        }
    }

    @Override
    public Object visit(ASTFieldDeclaration decl, Object data) {
        CommentRequirement fieldRequirement = this.getCommentRequirement(this.getProperty((PropertyDescriptor)FIELD_CMT_REQUIREMENT_DESCRIPTOR).toString());
        if (fieldRequirement != CommentRequirement.Ignored) {
            if (this.isSerialVersionUID(decl)) {
                this.checkSerialVersionUID(decl, data, fieldRequirement);
            } else if (fieldRequirement == CommentRequirement.Required) {
                if (decl.comment() == null) {
                    this.addViolationWithMessage(data, decl, FIELD_CMT_REQUIREMENT_DESCRIPTOR.name() + " " + (Object)((Object)CommentRequirement.Required), decl.getBeginLine(), decl.getEndLine());
                }
            } else if (decl.comment() != null) {
                this.addViolationWithMessage(data, decl, FIELD_CMT_REQUIREMENT_DESCRIPTOR.name() + " " + (Object)((Object)CommentRequirement.Unwanted), decl.getBeginLine(), decl.getEndLine());
            }
        }
        return super.visit(decl, data);
    }

    private void checkSerialVersionUID(ASTFieldDeclaration decl, Object data, CommentRequirement fieldRequirement) {
        CommentRequirement serialVersionUIDReq = this.getCommentRequirement(this.getProperty((PropertyDescriptor)SERIAL_VERSION_UID_CMT_REQUIREMENT_DESCRIPTOR).toString());
        if (serialVersionUIDReq != CommentRequirement.Ignored) {
            if (fieldRequirement == CommentRequirement.Required) {
                if (decl.comment() == null) {
                    this.addViolationWithMessage(data, decl, SERIAL_VERSION_UID_CMT_REQUIREMENT_DESCRIPTOR.name() + " " + (Object)((Object)CommentRequirement.Required), decl.getBeginLine(), decl.getEndLine());
                }
            } else if (decl.comment() != null) {
                this.addViolationWithMessage(data, decl, SERIAL_VERSION_UID_CMT_REQUIREMENT_DESCRIPTOR.name() + " " + (Object)((Object)CommentRequirement.Unwanted), decl.getBeginLine(), decl.getEndLine());
            }
        }
    }

    private boolean isSerialVersionUID(ASTFieldDeclaration field) {
        return "serialVersionUID".equals(field.getVariableName()) && field.isStatic() && field.isFinal() && field.getType() == Long.TYPE;
    }

    @Override
    public Object visit(ASTEnumDeclaration decl, Object data) {
        CommentRequirement enumRequirement = this.getCommentRequirement(this.getProperty((PropertyDescriptor)ENUM_CMT_REQUIREMENT_DESCRIPTOR).toString());
        if (enumRequirement != CommentRequirement.Ignored) {
            if (enumRequirement == CommentRequirement.Required) {
                if (decl.comment() == null) {
                    this.addViolationWithMessage(data, decl, ENUM_CMT_REQUIREMENT_DESCRIPTOR.name() + " " + (Object)((Object)CommentRequirement.Required), decl.getBeginLine(), decl.getEndLine());
                }
            } else if (decl.comment() != null) {
                this.addViolationWithMessage(data, decl, ENUM_CMT_REQUIREMENT_DESCRIPTOR.name() + " " + (Object)((Object)CommentRequirement.Unwanted), decl.getBeginLine(), decl.getEndLine());
            }
        }
        return super.visit(decl, data);
    }

    @Override
    public Object visit(ASTCompilationUnit cUnit, Object data) {
        this.assignCommentsToDeclarations(cUnit);
        return super.visit(cUnit, data);
    }

    public boolean allCommentsAreIgnored() {
        return this.getProperty((PropertyDescriptor)HEADER_CMT_REQUIREMENT_DESCRIPTOR) == CommentRequirement.Ignored && this.getProperty((PropertyDescriptor)FIELD_CMT_REQUIREMENT_DESCRIPTOR) == CommentRequirement.Ignored && this.getProperty((PropertyDescriptor)PUB_METHOD_CMT_REQUIREMENT_DESCRIPTOR) == CommentRequirement.Ignored && this.getProperty((PropertyDescriptor)PROT_METHOD_CMT_REQUIREMENT_DESCRIPTOR) == CommentRequirement.Ignored && this.getProperty((PropertyDescriptor)SERIAL_VERSION_UID_CMT_REQUIREMENT_DESCRIPTOR) == CommentRequirement.Ignored;
    }

    public String dysfunctionReason() {
        return this.allCommentsAreIgnored() ? "All comment types are ignored" : null;
    }

    static enum CommentRequirement {
        Required("Required"),
        Ignored("Ignored"),
        Unwanted("Unwanted");

        private final String label;

        private CommentRequirement(String theLabel) {
            this.label = theLabel;
        }

        public static String[] labels() {
            String[] labels = new String[CommentRequirement.values().length];
            int i = 0;
            for (CommentRequirement requirement : CommentRequirement.values()) {
                labels[i++] = requirement.label;
            }
            return labels;
        }
    }
}

