/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import org.javacc.utils.ConditionParser;
import org.javacc.utils.ParseException;

public class OutputFileGenerator {
    private final String templateName;
    private final Map options;
    private String currentLine;

    public OutputFileGenerator(String templateName, Map options) {
        this.templateName = templateName;
        this.options = options;
    }

    public void generate(PrintWriter out) throws IOException {
        InputStream is = this.getClass().getResourceAsStream(this.templateName);
        if (is == null) {
            throw new IOException("Invalid template name: " + this.templateName);
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        this.process(in, out, false);
    }

    private String peekLine(BufferedReader in) throws IOException {
        if (this.currentLine == null) {
            this.currentLine = in.readLine();
        }
        return this.currentLine;
    }

    private String getLine(BufferedReader in) throws IOException {
        String line = this.currentLine;
        this.currentLine = null;
        if (line == null) {
            in.readLine();
        }
        return line;
    }

    private boolean evaluate(String condition) {
        condition = condition.trim();
        try {
            return new ConditionParser(new StringReader(condition)).CompilationUnit(this.options);
        }
        catch (ParseException e) {
            return false;
        }
    }

    private String substitute(String text) throws IOException {
        int endPos;
        int startPos = text.indexOf("${");
        if (startPos == -1) {
            return text;
        }
        int braceDepth = 1;
        for (endPos = startPos + 2; endPos < text.length() && braceDepth > 0; ++endPos) {
            if (text.charAt(endPos) == '{') {
                ++braceDepth;
                continue;
            }
            if (text.charAt(endPos) != '}') continue;
            --braceDepth;
        }
        if (braceDepth != 0) {
            throw new IOException("Mismatched \"{}\" in template string: " + text);
        }
        String variableExpression = text.substring(startPos + 2, endPos - 1);
        String value = null;
        for (int i = 0; i < variableExpression.length(); ++i) {
            char ch = variableExpression.charAt(i);
            if (ch == ':' && i < variableExpression.length() - 1 && variableExpression.charAt(i + 1) == '-') {
                value = this.substituteWithDefault(variableExpression.substring(0, i), variableExpression.substring(i + 2));
                break;
            }
            if (ch == '?') {
                value = this.substituteWithConditional(variableExpression.substring(0, i), variableExpression.substring(i + 1));
                break;
            }
            if (ch == '_' || Character.isJavaIdentifierPart(ch)) continue;
            throw new IOException("Invalid variable in " + text);
        }
        if (value == null) {
            value = this.substituteWithDefault(variableExpression, "");
        }
        return text.substring(0, startPos) + value + text.substring(endPos);
    }

    private String substituteWithConditional(String variableName, String values) throws IOException {
        int pos = values.indexOf(58);
        if (pos == -1) {
            throw new IOException("No ':' separator in " + values);
        }
        if (this.evaluate(variableName)) {
            return this.substitute(values.substring(0, pos));
        }
        return this.substitute(values.substring(pos + 1));
    }

    private String substituteWithDefault(String variableName, String defaultValue) throws IOException {
        Object obj = this.options.get(variableName.trim());
        if (obj == null || obj.toString().length() == 0) {
            return this.substitute(defaultValue);
        }
        return obj.toString();
    }

    private void write(PrintWriter out, String text) throws IOException {
        while (text.indexOf("${") != -1) {
            text = this.substitute(text);
        }
        if (text.startsWith("\\#")) {
            text = text.substring(1);
        }
        out.println(text);
    }

    private void process(BufferedReader in, PrintWriter out, boolean ignoring) throws IOException {
        while (this.peekLine(in) != null) {
            if (this.peekLine(in).trim().startsWith("#if")) {
                this.processIf(in, out, ignoring);
                continue;
            }
            if (this.peekLine(in).trim().startsWith("#")) break;
            String line = this.getLine(in);
            if (ignoring) continue;
            this.write(out, line);
        }
        out.flush();
    }

    private void processIf(BufferedReader in, PrintWriter out, boolean ignoring) throws IOException {
        String line = this.getLine(in).trim();
        assert (line.trim().startsWith("#if"));
        boolean foundTrueCondition = false;
        boolean condition = this.evaluate(line.substring(3).trim());
        while (true) {
            this.process(in, out, ignoring || foundTrueCondition || !condition);
            foundTrueCondition |= condition;
            if (this.peekLine(in) == null || !this.peekLine(in).trim().startsWith("#elif")) break;
            condition = this.evaluate(this.getLine(in).trim().substring(5).trim());
        }
        if (this.peekLine(in) != null && this.peekLine(in).trim().startsWith("#else")) {
            this.getLine(in);
            this.process(in, out, ignoring || foundTrueCondition);
        }
        if ((line = this.getLine(in)) == null) {
            throw new IOException("Missing \"#fi\"");
        }
        if (!line.trim().startsWith("#fi")) {
            throw new IOException("Expected \"#fi\", got: " + line);
        }
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("falseArg", Boolean.FALSE);
        map.put("trueArg", Boolean.TRUE);
        map.put("stringValue", "someString");
        new OutputFileGenerator(args[0], map).generate(new PrintWriter(args[1]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateFromTemplate(String template, Map<String, Object> options, String outputFileName) throws IOException {
        OutputFileGenerator gen = new OutputFileGenerator(template, options);
        StringWriter sw = new StringWriter();
        gen.generate(new PrintWriter(sw));
        sw.close();
        try (PrintWriter fw = null;){
            File tmp = new File(outputFileName);
            fw = new PrintWriter(new BufferedWriter(new FileWriter(tmp), 8092));
            fw.print(sw.toString());
        }
    }
}

