/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Set;
import org.javacc.parser.Expansion;
import org.javacc.parser.JavaCCErrors;
import org.javacc.parser.JavaCCGlobals;
import org.javacc.parser.JavaCCParser;
import org.javacc.parser.JavaCCParserInternals;
import org.javacc.parser.JavaFiles;
import org.javacc.parser.LexGen;
import org.javacc.parser.LexGenCPP;
import org.javacc.parser.LookaheadWalk;
import org.javacc.parser.MatchInfo;
import org.javacc.parser.MetaParseException;
import org.javacc.parser.NfaState;
import org.javacc.parser.Options;
import org.javacc.parser.OtherFilesGen;
import org.javacc.parser.OtherFilesGenCPP;
import org.javacc.parser.ParseException;
import org.javacc.parser.ParseGen;
import org.javacc.parser.ParseGenCPP;
import org.javacc.parser.RStringLiteral;
import org.javacc.parser.Semanticize;
import org.javacc.utils.OptionInfo;
import org.javacc.utils.OptionType;

public class Main {
    public static LexGen lg;

    protected Main() {
    }

    static void help_message() {
        System.out.println("Usage:");
        System.out.println("    javacc option-settings inputfile");
        System.out.println("");
        System.out.println("\"option-settings\" is a sequence of settings separated by spaces.");
        System.out.println("Each option setting must be of one of the following forms:");
        System.out.println("");
        System.out.println("    -optionname=value (e.g., -STATIC=false)");
        System.out.println("    -optionname:value (e.g., -STATIC:false)");
        System.out.println("    -optionname       (equivalent to -optionname=true.  e.g., -STATIC)");
        System.out.println("    -NOoptionname     (equivalent to -optionname=false. e.g., -NOSTATIC)");
        System.out.println("");
        System.out.println("Option settings are not case-sensitive, so one can say \"-nOsTaTiC\" instead");
        System.out.println("of \"-NOSTATIC\".  Option values must be appropriate for the corresponding");
        System.out.println("option, and must be either an integer, a boolean, or a string value.");
        System.out.println("");
        Main.printOptions();
        System.out.println("EXAMPLE:");
        System.out.println("    javacc -STATIC=false -LOOKAHEAD:2 -debug_parser mygrammar.jj");
        System.out.println("");
    }

    private static void printOptions() {
        Set<OptionInfo> options = Options.getUserOptions();
        int maxLengthInt = 0;
        int maxLengthBool = 0;
        int maxLengthString = 0;
        for (OptionInfo i : options) {
            int length = i.getName().length();
            if (i.getType() == OptionType.INTEGER) {
                maxLengthInt = length > maxLengthInt ? length : maxLengthInt;
                continue;
            }
            if (i.getType() == OptionType.BOOLEAN) {
                maxLengthBool = length > maxLengthBool ? length : maxLengthBool;
                continue;
            }
            if (i.getType() != OptionType.STRING) continue;
            maxLengthString = length > maxLengthString ? length : maxLengthString;
        }
        if (maxLengthInt > 0) {
            System.out.println("The integer valued options are:");
            System.out.println("");
            for (OptionInfo i : options) {
                Main.printOptionInfo(OptionType.INTEGER, i, maxLengthInt);
            }
            System.out.println("");
        }
        if (maxLengthBool > 0) {
            System.out.println("The boolean valued options are:");
            System.out.println("");
            for (OptionInfo i : options) {
                Main.printOptionInfo(OptionType.BOOLEAN, i, maxLengthBool);
            }
            System.out.println("");
        }
        if (maxLengthString > 0) {
            System.out.println("The string valued options are:");
            System.out.println("");
            for (OptionInfo i : options) {
                Main.printOptionInfo(OptionType.STRING, i, maxLengthString);
            }
            System.out.println("");
        }
    }

    private static void printOptionInfo(OptionType filter, OptionInfo optionInfo, int padLength) {
        if (optionInfo.getType() == filter) {
            Object default1 = optionInfo.getDefault();
            System.out.println("    " + Main.padRight(optionInfo.getName(), padLength + 1) + (default1 == null ? "" : "(default : " + (default1.toString().length() == 0 ? "<<empty>>" : default1) + ")"));
        }
    }

    private static String padRight(String name, int maxLengthInt) {
        int nameLength = name.length();
        if (nameLength == maxLengthInt) {
            return name;
        }
        int charsToPad = maxLengthInt - nameLength;
        StringBuilder sb = new StringBuilder(charsToPad);
        sb.append(name);
        for (int i = 0; i < charsToPad; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        int errorcode = Main.mainProgram(args);
        System.exit(errorcode);
    }

    public static int mainProgram(String[] args) throws Exception {
        Main.reInitAll();
        JavaCCGlobals.bannerLine("Parser Generator", "");
        JavaCCParser parser = null;
        if (args.length == 0) {
            System.out.println("");
            Main.help_message();
            return 1;
        }
        System.out.println("(type \"javacc\" with no arguments for help)");
        if (Options.isOption(args[args.length - 1])) {
            System.out.println("Last argument \"" + args[args.length - 1] + "\" is not a filename.");
            return 1;
        }
        for (int arg = 0; arg < args.length - 1; ++arg) {
            if (!Options.isOption(args[arg])) {
                System.out.println("Argument \"" + args[arg] + "\" must be an option setting.");
                return 1;
            }
            Options.setCmdLineOption(args[arg]);
        }
        try {
            File fp = new File(args[args.length - 1]);
            if (!fp.exists()) {
                System.out.println("File " + args[args.length - 1] + " not found.");
                return 1;
            }
            if (fp.isDirectory()) {
                System.out.println(args[args.length - 1] + " is a directory. Please use a valid file name.");
                return 1;
            }
            parser = new JavaCCParser(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(args[args.length - 1]), Options.getGrammarEncoding())));
        }
        catch (SecurityException se) {
            System.out.println("Security violation while trying to open " + args[args.length - 1]);
            return 1;
        }
        catch (FileNotFoundException e) {
            System.out.println("File " + args[args.length - 1] + " not found.");
            return 1;
        }
        try {
            boolean isJavaModern;
            System.out.println("Reading from file " + args[args.length - 1] + " . . .");
            JavaCCGlobals.fileName = JavaCCGlobals.origFileName = args[args.length - 1];
            JavaCCGlobals.jjtreeGenerated = JavaCCGlobals.isGeneratedBy("JJTree", args[args.length - 1]);
            JavaCCGlobals.toolNames = JavaCCGlobals.getToolNames(args[args.length - 1]);
            parser.javacc_input();
            String outputLanguage = Options.getOutputLanguage();
            boolean isJavaOutput = Options.isOutputLanguageJava();
            boolean isCPPOutput = outputLanguage.equals("c++");
            boolean bl = isJavaModern = isJavaOutput && Options.getJavaTemplateType().equals("modern");
            if (isJavaOutput) {
                lg = new LexGen();
            } else if (isCPPOutput) {
                lg = new LexGenCPP();
            } else {
                return Main.unhandledLanguageExit(outputLanguage);
            }
            JavaCCGlobals.createOutputDir(Options.getOutputDirectory());
            if (Options.getUnicodeInput()) {
                NfaState.unicodeWarningGiven = true;
                System.out.println("Note: UNICODE_INPUT option is specified. Please make sure you create the parser/lexer using a Reader with the correct character encoding.");
            }
            Semanticize.start();
            boolean isBuildParser = Options.getBuildParser();
            if (isJavaOutput) {
                if (isBuildParser) {
                    new ParseGen().start(isJavaModern);
                }
                new LexGen().start();
                Options.setStringOption("PARSER_NAME", JavaCCGlobals.cu_name);
                OtherFilesGen.start(isJavaModern);
            } else if (isCPPOutput) {
                if (isBuildParser) {
                    new ParseGenCPP().start();
                }
                if (isBuildParser) {
                    new LexGenCPP().start();
                }
                Options.setStringOption("PARSER_NAME", JavaCCGlobals.cu_name);
                OtherFilesGenCPP.start();
            } else {
                Main.unhandledLanguageExit(outputLanguage);
            }
            if (JavaCCErrors.get_error_count() == 0 && (isBuildParser || Options.getBuildTokenManager())) {
                if (JavaCCErrors.get_warning_count() == 0) {
                    if (isBuildParser) {
                        System.out.println("Parser generated successfully.");
                    }
                } else {
                    System.out.println("Parser generated with 0 errors and " + JavaCCErrors.get_warning_count() + " warnings.");
                }
                return 0;
            }
            System.out.println("Detected " + JavaCCErrors.get_error_count() + " errors and " + JavaCCErrors.get_warning_count() + " warnings.");
            return JavaCCErrors.get_error_count() == 0 ? 0 : 1;
        }
        catch (MetaParseException e) {
            System.out.println("Detected " + JavaCCErrors.get_error_count() + " errors and " + JavaCCErrors.get_warning_count() + " warnings.");
            return 1;
        }
        catch (ParseException e) {
            System.out.println(e.toString());
            System.out.println("Detected " + (JavaCCErrors.get_error_count() + 1) + " errors and " + JavaCCErrors.get_warning_count() + " warnings.");
            return 1;
        }
    }

    private static int unhandledLanguageExit(String outputLanguage) {
        System.out.println("Invalid 'OUTPUT_LANGUAGE' specified : " + outputLanguage);
        return 1;
    }

    public static void reInitAll() {
        Expansion.reInit();
        JavaCCErrors.reInit();
        JavaCCGlobals.reInit();
        Options.init();
        JavaCCParserInternals.reInit();
        RStringLiteral.reInit();
        JavaFiles.reInit();
        NfaState.reInit();
        MatchInfo.reInit();
        LookaheadWalk.reInit();
        Semanticize.reInit();
        OtherFilesGen.reInit();
        LexGen.reInit();
    }
}

