/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.puppycrawl.tools.checkstyle.checks.imports.AbstractImportRule;
import com.puppycrawl.tools.checkstyle.checks.imports.AccessResult;

class PkgImportRule
extends AbstractImportRule {
    private final String pkgName;
    private final boolean exactMatch;

    PkgImportRule(boolean allow, boolean localOnly, String pkgName, boolean exactMatch, boolean regExp) {
        super(allow, localOnly, regExp);
        this.pkgName = pkgName;
        this.exactMatch = exactMatch;
    }

    @Override
    public AccessResult verifyImport(String forImport) {
        boolean pkgMatch;
        if (this.isRegExp()) {
            pkgMatch = forImport.matches(this.pkgName + "\\..*");
            if (pkgMatch && this.exactMatch) {
                pkgMatch = !forImport.matches(this.pkgName + "\\..*\\..*");
            }
        } else {
            pkgMatch = forImport.startsWith(this.pkgName + ".");
            if (pkgMatch && this.exactMatch) {
                pkgMatch = forImport.indexOf(46, this.pkgName.length() + 1) == -1;
            }
        }
        return this.calculateResult(pkgMatch);
    }
}

