/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.ant;

import com.google.common.io.Closeables;
import com.puppycrawl.tools.checkstyle.Checker;
import com.puppycrawl.tools.checkstyle.ConfigurationLoader;
import com.puppycrawl.tools.checkstyle.DefaultLogger;
import com.puppycrawl.tools.checkstyle.PackageObjectFactory;
import com.puppycrawl.tools.checkstyle.PropertiesExpander;
import com.puppycrawl.tools.checkstyle.PropertyResolver;
import com.puppycrawl.tools.checkstyle.XMLLogger;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.api.RootModule;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import com.puppycrawl.tools.checkstyle.api.SeverityLevelCounter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class CheckstyleAntTask
extends Task {
    private static final String E_XML = "xml";
    private static final String E_PLAIN = "plain";
    private static final String TIME_SUFFIX = " ms.";
    private final List<FileSet> fileSets = new ArrayList<FileSet>();
    private final List<Formatter> formatters = new ArrayList<Formatter>();
    private final List<Property> overrideProps = new ArrayList<Property>();
    private Path classpath;
    private String fileName;
    private String configLocation;
    private boolean failOnViolation = true;
    private String failureProperty;
    private File properties;
    private int maxErrors;
    private int maxWarnings = Integer.MAX_VALUE;
    private boolean omitIgnoredModules = true;

    public void setFailureProperty(String propertyName) {
        this.failureProperty = propertyName;
    }

    public void setFailOnViolation(boolean fail) {
        this.failOnViolation = fail;
    }

    public void setMaxErrors(int maxErrors) {
        this.maxErrors = maxErrors;
    }

    public void setMaxWarnings(int maxWarnings) {
        this.maxWarnings = maxWarnings;
    }

    public void addFileset(FileSet fileSet) {
        this.fileSets.add(fileSet);
    }

    public void addFormatter(Formatter formatter) {
        this.formatters.add(formatter);
    }

    public void addProperty(Property property) {
        this.overrideProps.add(property);
    }

    public void setClasspath(Path classpath) {
        if (this.classpath == null) {
            this.classpath = classpath;
        } else {
            this.classpath.append(classpath);
        }
    }

    public void setClasspathRef(Reference classpathRef) {
        this.createClasspath().setRefid(classpathRef);
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setFile(File file) {
        this.fileName = file.getAbsolutePath();
    }

    public void setConfig(File file) {
        this.setConfigLocation(file.getAbsolutePath());
    }

    @Deprecated
    public void setConfigURL(URL url) {
        this.setConfigUrl(url);
    }

    public void setConfigUrl(URL url) {
        this.setConfigLocation(url.toExternalForm());
    }

    private void setConfigLocation(String location) {
        if (this.configLocation != null) {
            throw new BuildException("Attributes 'config' and 'configURL' must not be set at the same time");
        }
        this.configLocation = location;
    }

    public void setOmitIgnoredModules(boolean omit) {
        this.omitIgnoredModules = omit;
    }

    public void setProperties(File props) {
        this.properties = props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        long startTime = System.currentTimeMillis();
        try {
            ResourceBundle compilationProperties = ResourceBundle.getBundle("checkstylecompilation", Locale.ROOT);
            String version = compilationProperties.getString("checkstyle.compile.version");
            String compileTimestamp = compilationProperties.getString("checkstyle.compile.timestamp");
            this.log("checkstyle version " + version, 3);
            this.log("compiled on " + compileTimestamp, 3);
            if (this.fileName == null && this.fileSets.isEmpty()) {
                throw new BuildException("Must specify at least one of 'file' or nested 'fileset'.", this.getLocation());
            }
            if (this.configLocation == null) {
                throw new BuildException("Must specify 'config'.", this.getLocation());
            }
            this.realExecute(version);
        }
        finally {
            long endTime = System.currentTimeMillis();
            this.log("Total execution took " + (endTime - startTime) + TIME_SUFFIX, 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void realExecute(String checkstyleVersion) {
        RootModule rootModule = null;
        try {
            AuditListener[] listeners;
            rootModule = this.createRootModule();
            for (AuditListener element : listeners = this.getListeners()) {
                rootModule.addListener(element);
            }
            SeverityLevelCounter warningCounter = new SeverityLevelCounter(SeverityLevel.WARNING);
            rootModule.addListener(warningCounter);
            this.processFiles(rootModule, warningCounter, checkstyleVersion);
        }
        finally {
            CheckstyleAntTask.destroyRootModule(rootModule);
        }
    }

    private static void destroyRootModule(RootModule rootModule) {
        if (rootModule != null) {
            rootModule.destroy();
        }
    }

    private void processFiles(RootModule rootModule, SeverityLevelCounter warningCounter, String checkstyleVersion) {
        boolean okStatus;
        int numErrs;
        long startTime = System.currentTimeMillis();
        List<File> files = this.scanFileSets();
        long endTime = System.currentTimeMillis();
        this.log("To locate the files took " + (endTime - startTime) + TIME_SUFFIX, 3);
        this.log("Running Checkstyle " + checkstyleVersion + " on " + files.size() + " files", 2);
        this.log("Using configuration " + this.configLocation, 3);
        try {
            long processingStartTime = System.currentTimeMillis();
            numErrs = rootModule.process(files);
            long processingEndTime = System.currentTimeMillis();
            this.log("To process the files took " + (processingEndTime - processingStartTime) + TIME_SUFFIX, 3);
        }
        catch (CheckstyleException ex) {
            throw new BuildException("Unable to process files: " + files, (Throwable)ex);
        }
        int numWarnings = warningCounter.getCount();
        boolean bl = okStatus = numErrs <= this.maxErrors && numWarnings <= this.maxWarnings;
        if (!okStatus) {
            String failureMsg = "Got " + numErrs + " errors and " + numWarnings + " warnings.";
            if (this.failureProperty != null) {
                this.getProject().setProperty(this.failureProperty, failureMsg);
            }
            if (this.failOnViolation) {
                throw new BuildException(failureMsg, this.getLocation());
            }
        }
    }

    private RootModule createRootModule() {
        RootModule rootModule;
        try {
            Properties props = this.createOverridingProperties();
            Configuration config = ConfigurationLoader.loadConfiguration(this.configLocation, (PropertyResolver)new PropertiesExpander(props), this.omitIgnoredModules);
            ClassLoader moduleClassLoader = Checker.class.getClassLoader();
            PackageObjectFactory factory = new PackageObjectFactory(Checker.class.getPackage().getName() + ".", moduleClassLoader);
            rootModule = (RootModule)factory.createModule(config.getName());
            rootModule.setModuleClassLoader(moduleClassLoader);
            if (rootModule instanceof Checker) {
                AntClassLoader loader = new AntClassLoader(this.getProject(), this.classpath);
                ((Checker)rootModule).setClassLoader((ClassLoader)loader);
            }
            rootModule.configure(config);
        }
        catch (CheckstyleException ex) {
            throw new BuildException(String.format(Locale.ROOT, "Unable to create Root Module: configLocation {%s}, classpath {%s}.", this.configLocation, this.classpath), (Throwable)ex);
        }
        return rootModule;
    }

    private Properties createOverridingProperties() {
        Properties returnValue = new Properties();
        if (this.properties != null) {
            FileInputStream inStream = null;
            try {
                inStream = new FileInputStream(this.properties);
                returnValue.load(inStream);
            }
            catch (IOException ex) {
                try {
                    throw new BuildException("Error loading Properties file '" + this.properties + "'", (Throwable)ex, this.getLocation());
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(inStream);
                    throw throwable;
                }
            }
            Closeables.closeQuietly(inStream);
        }
        Hashtable antProps = this.getProject().getProperties();
        for (Map.Entry entry : antProps.entrySet()) {
            String value = String.valueOf(entry.getValue());
            returnValue.setProperty((String)entry.getKey(), value);
        }
        for (Property p : this.overrideProps) {
            returnValue.setProperty(p.getKey(), p.getValue());
        }
        return returnValue;
    }

    private AuditListener[] getListeners() {
        int formatterCount = Math.max(1, this.formatters.size());
        AuditListener[] listeners = new AuditListener[formatterCount];
        try {
            if (this.formatters.isEmpty()) {
                LogOutputStream debug = new LogOutputStream((Task)this, 4);
                LogOutputStream err = new LogOutputStream((Task)this, 0);
                listeners[0] = new DefaultLogger((OutputStream)debug, true, (OutputStream)err, true);
            } else {
                for (int i = 0; i < formatterCount; ++i) {
                    Formatter formatter = this.formatters.get(i);
                    listeners[i] = formatter.createListener(this);
                }
            }
        }
        catch (IOException ex) {
            throw new BuildException(String.format(Locale.ROOT, "Unable to create listeners: formatters {%s}.", this.formatters), (Throwable)ex);
        }
        return listeners;
    }

    protected List<File> scanFileSets() {
        ArrayList<File> list = new ArrayList<File>();
        if (this.fileName != null) {
            this.log("Adding standalone file for audit", 3);
            list.add(new File(this.fileName));
        }
        for (int i = 0; i < this.fileSets.size(); ++i) {
            FileSet fileSet = this.fileSets.get(i);
            DirectoryScanner scanner = fileSet.getDirectoryScanner(this.getProject());
            scanner.scan();
            String[] names = scanner.getIncludedFiles();
            this.log(i + ") Adding " + names.length + " files from directory " + scanner.getBasedir(), 3);
            for (String element : names) {
                String pathname = scanner.getBasedir() + File.separator + element;
                list.add(new File(pathname));
            }
        }
        return list;
    }

    public static class Listener {
        private String className;

        public String getClassname() {
            return this.className;
        }

        public void setClassname(String name) {
            this.className = name;
        }
    }

    public static class Property {
        private String key;
        private String value;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void setFile(File file) {
            this.value = file.getAbsolutePath();
        }
    }

    public static class Formatter {
        private FormatterType type;
        private File toFile;
        private boolean useFile = true;

        public void setType(FormatterType type) {
            this.type = type;
        }

        public void setTofile(File destination) {
            this.toFile = destination;
        }

        public void setUseFile(boolean use) {
            this.useFile = use;
        }

        public AuditListener createListener(Task task) throws IOException {
            if (this.type != null && CheckstyleAntTask.E_XML.equals(this.type.getValue())) {
                return this.createXmlLogger(task);
            }
            return this.createDefaultLogger(task);
        }

        private AuditListener createDefaultLogger(Task task) throws IOException {
            if (this.toFile == null || !this.useFile) {
                return new DefaultLogger((OutputStream)new LogOutputStream(task, 4), true, (OutputStream)new LogOutputStream(task, 0), true);
            }
            FileOutputStream infoStream = new FileOutputStream(this.toFile);
            return new DefaultLogger(infoStream, true, infoStream, false);
        }

        private AuditListener createXmlLogger(Task task) throws IOException {
            if (this.toFile == null || !this.useFile) {
                return new XMLLogger((OutputStream)new LogOutputStream(task, 2), true);
            }
            return new XMLLogger(new FileOutputStream(this.toFile), true);
        }
    }

    public static class FormatterType
    extends EnumeratedAttribute {
        private static final String[] VALUES = new String[]{"xml", "plain"};

        public String[] getValues() {
            return (String[])VALUES.clone();
        }
    }
}

