/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.gui;

import com.puppycrawl.tools.checkstyle.gui.BaseCellEditor;
import com.puppycrawl.tools.checkstyle.gui.CodeSelector;
import com.puppycrawl.tools.checkstyle.gui.ListToTreeSelectionModelWrapper;
import com.puppycrawl.tools.checkstyle.gui.ParseTreeTableModel;
import com.puppycrawl.tools.checkstyle.gui.TreeTableCellRenderer;
import com.puppycrawl.tools.checkstyle.gui.TreeTableModelAdapter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.TreePath;

public class JTreeTable
extends JTable {
    private static final long serialVersionUID = -8493693409423365387L;
    private final TreeTableCellRenderer tree;
    private JTextArea editor;
    private List<Integer> linePositionMap;

    public JTreeTable(ParseTreeTableModel treeTableModel) {
        this.tree = new TreeTableCellRenderer(this, treeTableModel);
        this.setModel(new TreeTableModelAdapter(treeTableModel, this.tree));
        ListToTreeSelectionModelWrapper selectionWrapper = new ListToTreeSelectionModelWrapper(this);
        this.tree.setSelectionModel(selectionWrapper);
        this.setSelectionModel(selectionWrapper.getListSelectionModel());
        this.setDefaultRenderer(ParseTreeTableModel.class, this.tree);
        this.setDefaultEditor(ParseTreeTableModel.class, new TreeTableCellEditor());
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        if (this.tree.getRowHeight() < 1) {
            this.setRowHeight(this.getRowHeight());
        }
        this.setColumnsInitialWidth();
        AbstractAction expand = new AbstractAction(){
            private static final long serialVersionUID = -5859674518660156121L;

            @Override
            public void actionPerformed(ActionEvent event) {
                JTreeTable.this.expandSelectedNode();
            }
        };
        KeyStroke stroke = KeyStroke.getKeyStroke("ENTER");
        String command = "expand/collapse";
        this.getInputMap().put(stroke, "expand/collapse");
        this.getActionMap().put("expand/collapse", expand);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    JTreeTable.this.expandSelectedNode();
                }
            }
        });
    }

    private void expandSelectedNode() {
        TreePath selected = this.tree.getSelectionPath();
        this.makeCodeSelection();
        if (this.tree.isExpanded(selected)) {
            this.tree.collapsePath(selected);
        } else {
            this.tree.expandPath(selected);
        }
        this.tree.setSelectionPath(selected);
    }

    private void makeCodeSelection() {
        new CodeSelector(this.tree.getLastSelectedPathComponent(), this.editor, this.linePositionMap).select();
    }

    private void setColumnsInitialWidth() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int widthOfSixCharacterString = fontMetrics.stringWidth("XXXXXX");
        int padding = 10;
        int widthOfColumnContainingSixCharacterString = widthOfSixCharacterString + 10;
        this.getColumn("Line").setMaxWidth(widthOfColumnContainingSixCharacterString);
        this.getColumn("Column").setMaxWidth(widthOfColumnContainingSixCharacterString);
        int preferredTreeColumnWidth = Math.toIntExact(Math.round(this.getPreferredSize().getWidth() * 0.6));
        this.getColumn("Tree").setPreferredWidth(preferredTreeColumnWidth);
        int widthOfTwentyEightCharacterString = fontMetrics.stringWidth("XXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        int preferredTypeColumnWidth = widthOfTwentyEightCharacterString + 10;
        this.getColumn("Type").setPreferredWidth(preferredTypeColumnWidth);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.tree != null) {
            this.tree.updateUI();
        }
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
    }

    @Override
    public int getEditingRow() {
        Class<?> editingClass = this.getColumnClass(this.editingColumn);
        if (editingClass == ParseTreeTableModel.class) {
            return -1;
        }
        return this.editingRow;
    }

    @Override
    public final void setRowHeight(int newRowHeight) {
        super.setRowHeight(newRowHeight);
        if (this.tree != null && this.tree.getRowHeight() != newRowHeight) {
            this.tree.setRowHeight(this.getRowHeight());
        }
    }

    public JTree getTree() {
        return this.tree;
    }

    public void setEditor(JTextArea textArea) {
        this.editor = textArea;
    }

    public void setLinePositionMap(List<Integer> linePositionMap) {
        ArrayList<Integer> copy = new ArrayList<Integer>(linePositionMap);
        this.linePositionMap = Collections.unmodifiableList(copy);
    }

    private class TreeTableCellEditor
    extends BaseCellEditor
    implements TableCellEditor {
        private TreeTableCellEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return JTreeTable.this.tree;
        }

        @Override
        public boolean isCellEditable(EventObject event) {
            if (event instanceof MouseEvent) {
                for (int counter = JTreeTable.this.getColumnCount() - 1; counter >= 0; --counter) {
                    if (JTreeTable.this.getColumnClass(counter) != ParseTreeTableModel.class) continue;
                    MouseEvent mouseEvent = (MouseEvent)event;
                    MouseEvent newMouseEvent = new MouseEvent(JTreeTable.this.tree, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() - JTreeTable.this.getCellRect((int)0, (int)counter, (boolean)true).x, mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                    JTreeTable.this.tree.dispatchEvent(newMouseEvent);
                    break;
                }
            }
            return false;
        }
    }
}

