/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.awt.geom.Line2D;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnconnectedWays
extends Test {
    protected static int UNCONNECTED_WAYS = 1301;
    protected static final String PREFIX = "validator." + UnconnectedWays.class.getSimpleName();
    Set<MyWaySegment> ways;
    Set<Node> endnodes;
    Set<Node> endnodes_highway;
    Set<Node> middlenodes;
    Set<Node> othernodes;
    double mindist;
    double minmiddledist;

    public UnconnectedWays() {
        super(I18n.tr((String)"Unconnected ways."), I18n.tr((String)"This test checks if a way has an endpoint very near to another way."));
    }

    @Override
    public void startTest() {
        this.ways = new HashSet<MyWaySegment>();
        this.endnodes = new HashSet<Node>();
        this.endnodes_highway = new HashSet<Node>();
        this.middlenodes = new HashSet<Node>();
        this.othernodes = new HashSet<Node>();
        this.mindist = Main.pref.getDouble(PREFIX + ".node_way_distance", 10.0) / 6378135.0;
        this.minmiddledist = Main.pref.getDouble(PREFIX + ".way_way_distance", 0.0) / 6378135.0;
    }

    @Override
    public void endTest() {
        HashMap<Node, Way> map = new HashMap<Node, Way>();
        for (Node node : this.endnodes_highway) {
            for (MyWaySegment s : this.ways) {
                if (!s.highway.booleanValue() || !s.nearby(node, this.mindist)) continue;
                map.put(node, s.w);
            }
        }
        if (map.size() > 0) {
            for (Map.Entry entry : map.entrySet()) {
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"Way end node near other highway"), UNCONNECTED_WAYS, Arrays.asList((OsmPrimitive)entry.getKey(), (OsmPrimitive)entry.getValue())));
            }
        }
        map.clear();
        for (Node node : this.endnodes_highway) {
            for (MyWaySegment s : this.ways) {
                if (s.highway.booleanValue() || !s.nearby(node, this.mindist)) continue;
                map.put(node, s.w);
            }
        }
        for (Node node : this.endnodes) {
            for (MyWaySegment s : this.ways) {
                if (!s.nearby(node, this.mindist)) continue;
                map.put(node, s.w);
            }
        }
        if (map.size() > 0) {
            for (Map.Entry entry : map.entrySet()) {
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"Way end node near other way"), UNCONNECTED_WAYS, Arrays.asList((OsmPrimitive)entry.getKey(), (OsmPrimitive)entry.getValue())));
            }
        }
        if (this.minmiddledist > 0.0) {
            map.clear();
            for (Node node : this.middlenodes) {
                for (MyWaySegment s : this.ways) {
                    if (!s.nearby(node, this.minmiddledist)) continue;
                    map.put(node, s.w);
                }
            }
            if (map.size() > 0) {
                for (Map.Entry entry : map.entrySet()) {
                    this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr((String)"Way node near other way"), UNCONNECTED_WAYS, Arrays.asList((OsmPrimitive)entry.getKey(), (OsmPrimitive)entry.getValue())));
                }
            }
            map.clear();
            for (Node node : this.othernodes) {
                for (MyWaySegment s : this.ways) {
                    if (!s.nearby(node, this.minmiddledist)) continue;
                    map.put(node, s.w);
                }
            }
            if (map.size() > 0) {
                for (Map.Entry entry : map.entrySet()) {
                    this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr((String)"Connected way end node near other way"), UNCONNECTED_WAYS, Arrays.asList((OsmPrimitive)entry.getKey(), (OsmPrimitive)entry.getValue())));
                }
            }
        }
        this.ways = null;
        this.endnodes = null;
    }

    @Override
    public void visit(Way w) {
        if (w.deleted || w.incomplete) {
            return;
        }
        int size = w.nodes.size();
        if (size < 2) {
            return;
        }
        for (int i = 1; i < size; ++i) {
            if (i < size - 1) {
                this.addNode((Node)w.nodes.get(i), this.middlenodes);
            }
            this.ways.add(new MyWaySegment(w, (Node)w.nodes.get(i - 1), (Node)w.nodes.get(i)));
        }
        Set<Node> set = this.endnodes;
        if (w.get("highway") != null || w.get("railway") != null) {
            set = this.endnodes_highway;
        }
        this.addNode((Node)w.nodes.get(0), set);
        this.addNode((Node)w.nodes.get(size - 1), set);
    }

    private void addNode(Node n, Set<Node> s) {
        Boolean m = this.middlenodes.contains(n);
        Boolean e = this.endnodes.contains(n);
        Boolean eh = this.endnodes_highway.contains(n);
        Boolean o = this.othernodes.contains(n);
        if (!(m.booleanValue() || e.booleanValue() || o.booleanValue() || eh.booleanValue())) {
            s.add(n);
        } else if (!o.booleanValue()) {
            this.othernodes.add(n);
            if (e.booleanValue()) {
                this.endnodes.remove(n);
            } else if (eh.booleanValue()) {
                this.endnodes_highway.remove(n);
            } else {
                this.middlenodes.remove(n);
            }
        }
    }

    private class MyWaySegment {
        private Line2D line;
        public Way w;
        public Boolean highway;

        public MyWaySegment(Way w, Node n1, Node n2) {
            this.w = w;
            this.highway = w.get("highway") != null || w.get("railway") != null;
            this.line = new Line2D.Double(n1.eastNorth.east(), n1.eastNorth.north(), n2.eastNorth.east(), n2.eastNorth.north());
        }

        public boolean nearby(Node n, double dist) {
            return !this.w.nodes.contains(n) && this.line.ptSegDist(n.eastNorth.east(), n.eastNorth.north()) < dist;
        }
    }
}

