/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.lib.bytebuddy;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.type.TypeDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.ClassFileLocator;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.ClassReader;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.ClassVisitor;

public class ClassFileVersion
implements Comparable<ClassFileVersion> {
    protected static final int BASE_VERSION = 44;
    public static final ClassFileVersion JAVA_V1 = new ClassFileVersion(196653);
    public static final ClassFileVersion JAVA_V2 = new ClassFileVersion(46);
    public static final ClassFileVersion JAVA_V3 = new ClassFileVersion(47);
    public static final ClassFileVersion JAVA_V4 = new ClassFileVersion(48);
    public static final ClassFileVersion JAVA_V5 = new ClassFileVersion(49);
    public static final ClassFileVersion JAVA_V6 = new ClassFileVersion(50);
    public static final ClassFileVersion JAVA_V7 = new ClassFileVersion(51);
    public static final ClassFileVersion JAVA_V8 = new ClassFileVersion(52);
    public static final ClassFileVersion JAVA_V9 = new ClassFileVersion(53);
    private static final VersionLocator VERSION_LOCATOR = AccessController.doPrivileged(VersionLocator.CreationAction.INSTANCE);
    private final int versionNumber;

    protected ClassFileVersion(int versionNumber) {
        this.versionNumber = versionNumber;
    }

    public static ClassFileVersion ofMinorMajor(int versionNumber) {
        ClassFileVersion classFileVersion = new ClassFileVersion(versionNumber);
        if (classFileVersion.getMajorVersion() <= 44) {
            throw new IllegalArgumentException("Class version " + versionNumber + " is not valid");
        }
        return classFileVersion;
    }

    public static ClassFileVersion ofJavaVersion(int javaVersion) {
        switch (javaVersion) {
            case 1: {
                return JAVA_V1;
            }
            case 2: {
                return JAVA_V2;
            }
            case 3: {
                return JAVA_V3;
            }
            case 4: {
                return JAVA_V4;
            }
            case 5: {
                return JAVA_V5;
            }
            case 6: {
                return JAVA_V6;
            }
            case 7: {
                return JAVA_V7;
            }
            case 8: {
                return JAVA_V8;
            }
            case 9: {
                return JAVA_V9;
            }
        }
        throw new IllegalArgumentException("Unknown Java version: " + javaVersion);
    }

    public static ClassFileVersion ofThisVm() {
        return VERSION_LOCATOR.locate();
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should not be rethrown but trigger a fallback")
    public static ClassFileVersion ofThisVm(ClassFileVersion fallback) {
        try {
            return ClassFileVersion.ofThisVm();
        }
        catch (Exception ignored) {
            return fallback;
        }
    }

    public static ClassFileVersion of(Class<?> type) throws IOException {
        return ClassFileVersion.of(type, ClassFileLocator.ForClassLoader.of(type.getClassLoader()));
    }

    public static ClassFileVersion of(Class<?> type, ClassFileLocator classFileLocator) throws IOException {
        return ClassFileVersion.of(new TypeDescription.ForLoadedType(type), classFileLocator);
    }

    public static ClassFileVersion of(TypeDescription typeDescription, ClassFileLocator classFileLocator) throws IOException {
        ClassReader classReader = new ClassReader(classFileLocator.locate(typeDescription.getName()).resolve());
        VersionExtractor versionExtractor = new VersionExtractor();
        classReader.accept(versionExtractor, 1);
        return ClassFileVersion.ofMinorMajor(versionExtractor.getClassFileVersionNumber());
    }

    public int getMinorMajorVersion() {
        return this.versionNumber;
    }

    public int getMajorVersion() {
        return this.versionNumber & 0xFF;
    }

    public int getMinorVersion() {
        return this.versionNumber >> 16;
    }

    public int getJavaVersion() {
        return this.getMajorVersion() - 44;
    }

    public boolean isAtLeast(ClassFileVersion classFileVersion) {
        return this.compareTo(classFileVersion) > -1;
    }

    public boolean isLessThan(ClassFileVersion classFileVersion) {
        return this.compareTo(classFileVersion) < 0;
    }

    @Override
    public int compareTo(ClassFileVersion other) {
        return Integer.signum(this.getMajorVersion() == other.getMajorVersion() ? this.getMinorVersion() - other.getMinorVersion() : this.getMajorVersion() - other.getMajorVersion());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassFileVersion)) {
            return false;
        }
        ClassFileVersion other = (ClassFileVersion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.versionNumber == other.versionNumber;
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClassFileVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.versionNumber;
        return result;
    }

    protected static class VersionExtractor
    extends ClassVisitor {
        private int classFileVersionNumber;

        protected VersionExtractor() {
            super(327680);
        }

        @Override
        public void visit(int classFileVersionNumber, int modifier, String internalName, String signature, String superTypeName, String[] interfaceName) {
            this.classFileVersionNumber = classFileVersionNumber;
        }

        protected int getClassFileVersionNumber() {
            return this.classFileVersionNumber;
        }
    }

    protected static interface VersionLocator {
        public ClassFileVersion locate();

        public static enum ForLegacyVm implements VersionLocator,
        PrivilegedAction<String>
        {
            INSTANCE;

            private static final String JAVA_VERSION_PROPERTY = "java.version";

            @Override
            public ClassFileVersion locate() {
                String versionString = AccessController.doPrivileged(this);
                int[] versionIndex = new int[]{-1, 0, 0};
                for (int i = 1; i < 3; ++i) {
                    versionIndex[i] = versionString.indexOf(46, versionIndex[i - 1] + 1);
                    if (versionIndex[i] != -1) continue;
                    throw new IllegalStateException("This JVM's version string does not seem to be valid: " + versionString);
                }
                return ClassFileVersion.ofJavaVersion(Integer.parseInt(versionString.substring(versionIndex[1] + 1, versionIndex[2])));
            }

            @Override
            public String run() {
                return System.getProperty(JAVA_VERSION_PROPERTY);
            }
        }

        public static class ForJava9CapableVm
        implements VersionLocator {
            private static final Object STATIC_METHOD = null;
            private final Method current;
            private final Method major;

            protected ForJava9CapableVm(Method current, Method major) {
                this.current = current;
                this.major = major;
            }

            @Override
            public ClassFileVersion locate() {
                try {
                    return ClassFileVersion.ofJavaVersion((Integer)this.major.invoke(this.current.invoke(STATIC_METHOD, new Object[0]), new Object[0]));
                }
                catch (InvocationTargetException exception) {
                    throw new IllegalStateException("Could not look up VM version", exception.getCause());
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalStateException("Could not access VM version lookup", exception);
                }
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForJava9CapableVm)) {
                    return false;
                }
                ForJava9CapableVm other = (ForJava9CapableVm)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Method this$current = this.current;
                Method other$current = other.current;
                if (this$current == null ? other$current != null : !((Object)this$current).equals(other$current)) {
                    return false;
                }
                Method this$major = this.major;
                Method other$major = other.major;
                return !(this$major == null ? other$major != null : !((Object)this$major).equals(other$major));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForJava9CapableVm;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Method $current = this.current;
                result = result * 59 + ($current == null ? 43 : ((Object)$current).hashCode());
                Method $major = this.major;
                result = result * 59 + ($major == null ? 43 : ((Object)$major).hashCode());
                return result;
            }
        }

        public static enum CreationAction implements PrivilegedAction<VersionLocator>
        {
            INSTANCE;


            @Override
            @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should not be rethrown but trigger a fallback")
            public VersionLocator run() {
                try {
                    return new ForJava9CapableVm(Runtime.class.getMethod("version", new Class[0]), Class.forName("java.lang.Runtime$Version").getMethod("major", new Class[0]));
                }
                catch (Exception ignored) {
                    return ForLegacyVm.INSTANCE;
                }
            }
        }
    }
}

