/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class SuperclassIterable<T>
implements Iterable<Class<? super T>> {
    private final Class<T> type;
    private final boolean includeSelf;

    private SuperclassIterable(Class<T> type, boolean includeSelf) {
        this.type = type;
        this.includeSelf = includeSelf;
    }

    public static <T> SuperclassIterable<T> of(Class<T> type) {
        return new SuperclassIterable<T>(type, false);
    }

    public static <T> SuperclassIterable<T> ofIncludeSelf(Class<T> type) {
        return new SuperclassIterable<T>(type, true);
    }

    @Override
    public Iterator<Class<? super T>> iterator() {
        return this.createClassList().iterator();
    }

    private List<Class<? super T>> createClassList() {
        ArrayList<Class<T>> result = new ArrayList<Class<T>>();
        if (this.includeSelf) {
            result.add(this.type);
        }
        for (Class<T> i = this.type.getSuperclass(); i != null && !i.equals(Object.class); i = i.getSuperclass()) {
            result.add(i);
        }
        return result;
    }
}

