/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nl.jqno.equalsverifier.CachedHashCodeInitializer;
import nl.jqno.equalsverifier.Warning;
import nl.jqno.equalsverifier.internal.ClassAccessor;
import nl.jqno.equalsverifier.internal.prefabvalues.PrefabValues;
import nl.jqno.equalsverifier.internal.prefabvalues.TypeTag;

public final class Configuration<T> {
    private final Class<T> type;
    private final TypeTag typeTag;
    private final PrefabValues prefabValues;
    private final List<T> equalExamples;
    private final List<T> unequalExamples;
    private final Set<String> ignoredFields;
    private final Set<String> nonnullFields;
    private final CachedHashCodeInitializer<T> cachedHashCodeInitializer;
    private final boolean hasRedefinedSuperclass;
    private final Class<? extends T> redefinedSubclass;
    private final boolean usingGetClass;
    private final EnumSet<Warning> warningsToSuppress;

    private Configuration(Class<T> type, PrefabValues prefabValues, List<T> equalExamples, List<T> unequalExamples, Set<String> ignoredFields, Set<String> nonnullFields, CachedHashCodeInitializer<T> cachedHashCodeInitializer, boolean hasRedefinedSuperclass, Class<? extends T> redefinedSubclass, boolean usingGetClass, EnumSet<Warning> warningsToSuppress) {
        this.type = type;
        this.typeTag = new TypeTag(type, new TypeTag[0]);
        this.prefabValues = prefabValues;
        this.equalExamples = equalExamples;
        this.unequalExamples = unequalExamples;
        this.ignoredFields = ignoredFields;
        this.nonnullFields = nonnullFields;
        this.cachedHashCodeInitializer = cachedHashCodeInitializer;
        this.hasRedefinedSuperclass = hasRedefinedSuperclass;
        this.redefinedSubclass = redefinedSubclass;
        this.usingGetClass = usingGetClass;
        this.warningsToSuppress = warningsToSuppress;
    }

    public static <T> Configuration<T> of(Class<T> type) {
        return new Configuration<T>(type, new PrefabValues(), new ArrayList(), new ArrayList(), new HashSet<String>(), new HashSet<String>(), CachedHashCodeInitializer.passthrough(), false, null, false, EnumSet.noneOf(Warning.class));
    }

    public Class<T> getType() {
        return this.type;
    }

    public TypeTag getTypeTag() {
        return this.typeTag;
    }

    public PrefabValues getPrefabValues() {
        return this.prefabValues;
    }

    public Configuration<T> withEqualExamples(List<T> value) {
        return new Configuration<T>(this.type, this.prefabValues, value, this.unequalExamples, this.ignoredFields, this.nonnullFields, this.cachedHashCodeInitializer, this.hasRedefinedSuperclass, this.redefinedSubclass, this.usingGetClass, this.warningsToSuppress);
    }

    public List<T> getEqualExamples() {
        return Collections.unmodifiableList(this.equalExamples);
    }

    public Configuration<T> withUnequalExamples(List<T> value) {
        return new Configuration<T>(this.type, this.prefabValues, this.equalExamples, value, this.ignoredFields, this.nonnullFields, this.cachedHashCodeInitializer, this.hasRedefinedSuperclass, this.redefinedSubclass, this.usingGetClass, this.warningsToSuppress);
    }

    public List<T> getUnequalExamples() {
        return Collections.unmodifiableList(this.unequalExamples);
    }

    public Configuration<T> withIgnoredFields(List<String> value) {
        return new Configuration<T>(this.type, this.prefabValues, this.equalExamples, this.unequalExamples, new HashSet<String>(value), this.nonnullFields, this.cachedHashCodeInitializer, this.hasRedefinedSuperclass, this.redefinedSubclass, this.usingGetClass, this.warningsToSuppress);
    }

    public Set<String> getIgnoredFields() {
        return Collections.unmodifiableSet(this.ignoredFields);
    }

    public Configuration<T> withNonnullFields(List<String> value) {
        return new Configuration<T>(this.type, this.prefabValues, this.equalExamples, this.unequalExamples, this.ignoredFields, new HashSet<String>(value), this.cachedHashCodeInitializer, this.hasRedefinedSuperclass, this.redefinedSubclass, this.usingGetClass, this.warningsToSuppress);
    }

    public Set<String> getNonnullFields() {
        return Collections.unmodifiableSet(this.nonnullFields);
    }

    public Configuration<T> withCachedHashCodeInitializer(CachedHashCodeInitializer<T> value) {
        return new Configuration<T>(this.type, this.prefabValues, this.equalExamples, this.unequalExamples, this.ignoredFields, this.nonnullFields, value, this.hasRedefinedSuperclass, this.redefinedSubclass, this.usingGetClass, this.warningsToSuppress);
    }

    public CachedHashCodeInitializer<T> getCachedHashCodeInitializer() {
        return this.cachedHashCodeInitializer;
    }

    public Configuration<T> withRedefinedSuperclass() {
        return new Configuration<T>(this.type, this.prefabValues, this.equalExamples, this.unequalExamples, this.ignoredFields, this.nonnullFields, this.cachedHashCodeInitializer, true, this.redefinedSubclass, this.usingGetClass, this.warningsToSuppress);
    }

    public boolean hasRedefinedSuperclass() {
        return this.hasRedefinedSuperclass;
    }

    public Configuration<T> withRedefinedSubclass(Class<? extends T> value) {
        return new Configuration<T>(this.type, this.prefabValues, this.equalExamples, this.unequalExamples, this.ignoredFields, this.nonnullFields, this.cachedHashCodeInitializer, this.hasRedefinedSuperclass, value, this.usingGetClass, this.warningsToSuppress);
    }

    public Class<? extends T> getRedefinedSubclass() {
        return this.redefinedSubclass;
    }

    public Configuration<T> withUsingGetClass() {
        return new Configuration<T>(this.type, this.prefabValues, this.equalExamples, this.unequalExamples, this.ignoredFields, this.nonnullFields, this.cachedHashCodeInitializer, this.hasRedefinedSuperclass, this.redefinedSubclass, true, this.warningsToSuppress);
    }

    public boolean isUsingGetClass() {
        return this.usingGetClass;
    }

    public Configuration<T> withWarningsToSuppress(EnumSet<Warning> value) {
        return new Configuration<T>(this.type, this.prefabValues, this.equalExamples, this.unequalExamples, this.ignoredFields, this.nonnullFields, this.cachedHashCodeInitializer, this.hasRedefinedSuperclass, this.redefinedSubclass, this.usingGetClass, value);
    }

    public EnumSet<Warning> getWarningsToSuppress() {
        return EnumSet.copyOf(this.warningsToSuppress);
    }

    public ClassAccessor<T> createClassAccessor() {
        return ClassAccessor.of(this.type, this.prefabValues, this.warningsToSuppress.contains((Object)Warning.ANNOTATION));
    }
}

