/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.header;

import com.google.common.io.Closeables;
import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.ExternalResourceHolder;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.ConversionException;

public abstract class AbstractHeaderCheck
extends AbstractFileSetCheck
implements ExternalResourceHolder {
    private static final Pattern ESCAPED_LINE_FEED_PATTERN = Pattern.compile("\\\\n");
    private final List<String> readerLines = new ArrayList<String>();
    private URI headerFile;
    private String charset = System.getProperty("file.encoding", "UTF-8");

    protected abstract void postProcessHeaderLines();

    protected List<String> getHeaderLines() {
        ArrayList<String> copy = new ArrayList<String>(this.readerLines);
        return Collections.unmodifiableList(copy);
    }

    public void setCharset(String charset) throws UnsupportedEncodingException {
        if (!Charset.isSupported(charset)) {
            String message = "unsupported charset: '" + charset + "'";
            throw new UnsupportedEncodingException(message);
        }
        this.charset = charset;
    }

    public void setHeaderFile(URI uri) throws CheckstyleException {
        if (uri == null) {
            throw new CheckstyleException("property 'headerFile' is missing or invalid in module " + this.getConfiguration().getName());
        }
        this.headerFile = uri;
    }

    private void loadHeaderFile() throws CheckstyleException {
        this.checkHeaderNotInitialized();
        InputStreamReader headerReader = null;
        try {
            headerReader = new InputStreamReader((InputStream)new BufferedInputStream(this.headerFile.toURL().openStream()), this.charset);
            this.loadHeader(headerReader);
        }
        catch (IOException ex) {
            try {
                throw new CheckstyleException("unable to load header file " + this.headerFile, ex);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(headerReader);
                throw throwable;
            }
        }
        Closeables.closeQuietly(headerReader);
    }

    private void checkHeaderNotInitialized() {
        if (!this.readerLines.isEmpty()) {
            throw new ConversionException("header has already been set - set either header or headerFile, not both");
        }
    }

    public void setHeader(String header) {
        if (!CommonUtils.isBlank(header)) {
            this.checkHeaderNotInitialized();
            String headerExpandedNewLines = ESCAPED_LINE_FEED_PATTERN.matcher(header).replaceAll("\n");
            StringReader headerReader = new StringReader(headerExpandedNewLines);
            try {
                this.loadHeader(headerReader);
            }
            catch (IOException ex) {
                throw new ConversionException("unable to load header", ex);
            }
            finally {
                Closeables.closeQuietly(headerReader);
            }
        }
    }

    private void loadHeader(Reader headerReader) throws IOException {
        String line;
        this.readerLines.clear();
        LineNumberReader lnr = new LineNumberReader(headerReader);
        while ((line = lnr.readLine()) != null) {
            this.readerLines.add(line);
        }
        this.postProcessHeaderLines();
    }

    @Override
    protected final void finishLocalSetup() throws CheckstyleException {
        if (this.headerFile != null) {
            this.loadHeaderFile();
        }
        if (this.readerLines.isEmpty()) {
            this.setHeader(null);
        }
    }

    @Override
    public Set<String> getExternalResourceLocations() {
        return Collections.singleton(this.headerFile.toString());
    }
}

