/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.regex.Pattern;

public class TodoCommentCheck
extends AbstractCheck {
    public static final String MSG_KEY = "todo.match";
    private Pattern format = Pattern.compile("TODO:");

    @Override
    public boolean isCommentNodesRequired() {
        return true;
    }

    public void setFormat(Pattern pattern) {
        this.format = pattern;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{183};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public void visitToken(DetailAST ast) {
        String[] lines = ast.getText().split("\n");
        for (int i = 0; i < lines.length; ++i) {
            if (!this.format.matcher(lines[i]).find()) continue;
            this.log(ast.getLineNo() + i, MSG_KEY, this.format.pattern());
        }
    }
}

