/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.gui.jmapviewer.DefaultMapController;
import org.openstreetmap.gui.jmapviewer.JobDispatcher;
import org.openstreetmap.gui.jmapviewer.MemoryTileCache;
import org.openstreetmap.gui.jmapviewer.OsmMercator;
import org.openstreetmap.gui.jmapviewer.OsmTileLoader;
import org.openstreetmap.gui.jmapviewer.OsmTileSource;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.MapMarker;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMapViewer
extends JPanel
implements TileLoaderListener {
    private static final long serialVersionUID = 1L;
    protected static final Point[] move = new Point[]{new Point(1, 0), new Point(0, 1), new Point(-1, 0), new Point(0, -1)};
    public static final int MAX_ZOOM = 22;
    public static final int MIN_ZOOM = 0;
    protected TileLoader tileLoader;
    protected TileCache tileCache;
    protected TileSource tileSource = new OsmTileSource.Mapnik();
    protected List<MapMarker> mapMarkerList;
    protected boolean mapMarkersVisible;
    protected boolean tileGridVisible;
    protected Point center;
    protected int zoom;
    protected JSlider zoomSlider;
    protected JButton zoomInButton;
    protected JButton zoomOutButton;
    protected BufferedImage loadingImage;
    JobDispatcher jobDispatcher;

    public JMapViewer() {
        this(new MemoryTileCache(), 4);
        new DefaultMapController(this);
    }

    public JMapViewer(TileCache tileCache, int downloadThreadCount) {
        this.tileLoader = new OsmTileLoader(this);
        this.tileCache = tileCache;
        this.jobDispatcher = JobDispatcher.getInstance();
        this.mapMarkerList = new LinkedList<MapMarker>();
        this.mapMarkersVisible = true;
        this.tileGridVisible = false;
        this.setLayout(null);
        this.initializeZoomSlider();
        this.setMinimumSize(new Dimension(256, 256));
        this.setPreferredSize(new Dimension(400, 400));
        try {
            this.loadingImage = ImageIO.read(JMapViewer.class.getResourceAsStream("images/hourglass.png"));
        }
        catch (Exception e1) {
            this.loadingImage = null;
        }
        this.setDisplayPositionByLatLon(50.0, 9.0, 3);
    }

    protected void initializeZoomSlider() {
        ImageIcon icon;
        this.zoomSlider = new JSlider(0, this.tileSource.getMaxZoom());
        this.zoomSlider.setOrientation(1);
        this.zoomSlider.setBounds(10, 10, 30, 150);
        this.zoomSlider.setOpaque(false);
        this.zoomSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JMapViewer.this.setZoom(JMapViewer.this.zoomSlider.getValue());
            }
        });
        this.add(this.zoomSlider);
        int size = 18;
        try {
            icon = new ImageIcon(this.getClass().getResource("images/plus.png"));
            this.zoomInButton = new JButton(icon);
        }
        catch (Exception e) {
            this.zoomInButton = new JButton("+");
            this.zoomInButton.setFont(new Font("sansserif", 1, 9));
            this.zoomInButton.setMargin(new Insets(0, 0, 0, 0));
        }
        this.zoomInButton.setBounds(4, 155, size, size);
        this.zoomInButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JMapViewer.this.zoomIn();
            }
        });
        this.add(this.zoomInButton);
        try {
            icon = new ImageIcon(this.getClass().getResource("images/minus.png"));
            this.zoomOutButton = new JButton(icon);
        }
        catch (Exception e) {
            this.zoomOutButton = new JButton("-");
            this.zoomOutButton.setFont(new Font("sansserif", 1, 9));
            this.zoomOutButton.setMargin(new Insets(0, 0, 0, 0));
        }
        this.zoomOutButton.setBounds(8 + size, 155, size, size);
        this.zoomOutButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JMapViewer.this.zoomOut();
            }
        });
        this.add(this.zoomOutButton);
    }

    public void setDisplayPositionByLatLon(double lat, double lon, int zoom) {
        this.setDisplayPositionByLatLon(new Point(this.getWidth() / 2, this.getHeight() / 2), lat, lon, zoom);
    }

    public void setDisplayPositionByLatLon(Point mapPoint, double lat, double lon, int zoom) {
        int x = OsmMercator.LonToX(lon, zoom);
        int y = OsmMercator.LatToY(lat, zoom);
        this.setDisplayPosition(mapPoint, x, y, zoom);
    }

    public void setDisplayPosition(int x, int y, int zoom) {
        this.setDisplayPosition(new Point(this.getWidth() / 2, this.getHeight() / 2), x, y, zoom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisplayPosition(Point mapPoint, int x, int y, int zoom) {
        if (zoom > this.tileSource.getMaxZoom() || zoom < 0) {
            return;
        }
        Point p = new Point();
        p.x = x - mapPoint.x + this.getWidth() / 2;
        p.y = y - mapPoint.y + this.getHeight() / 2;
        this.center = p;
        this.setIgnoreRepaint(true);
        try {
            int oldZoom = this.zoom;
            this.zoom = zoom;
            if (oldZoom != zoom) {
                this.zoomChanged(oldZoom);
            }
            if (this.zoomSlider.getValue() != zoom) {
                this.zoomSlider.setValue(zoom);
            }
        }
        finally {
            this.setIgnoreRepaint(false);
            this.repaint();
        }
    }

    public void setDisplayToFitMapMarkers() {
        int y;
        if (this.mapMarkerList == null || this.mapMarkerList.size() == 0) {
            return;
        }
        int x_min = Integer.MAX_VALUE;
        int y_min = Integer.MAX_VALUE;
        int x_max = Integer.MIN_VALUE;
        int y_max = Integer.MIN_VALUE;
        int mapZoomMax = this.tileSource.getMaxZoom();
        for (MapMarker marker : this.mapMarkerList) {
            int x = OsmMercator.LonToX(marker.getLon(), mapZoomMax);
            int y2 = OsmMercator.LatToY(marker.getLat(), mapZoomMax);
            x_max = Math.max(x_max, x);
            y_max = Math.max(y_max, y2);
            x_min = Math.min(x_min, x);
            y_min = Math.min(y_min, y2);
        }
        int height = Math.max(0, this.getHeight());
        int width = Math.max(0, this.getWidth());
        int newZoom = mapZoomMax;
        int x = x_max - x_min;
        for (y = y_max - y_min; x > width || y > height; x >>= 1, y >>= 1) {
            --newZoom;
        }
        x = x_min + (x_max - x_min) / 2;
        y = y_min + (y_max - y_min) / 2;
        int z = 1 << mapZoomMax - newZoom;
        this.setDisplayPosition(x /= z, y /= z, newZoom);
    }

    public Point2D.Double getPosition() {
        double lon = OsmMercator.XToLon(this.center.x, this.zoom);
        double lat = OsmMercator.YToLat(this.center.y, this.zoom);
        return new Point2D.Double(lat, lon);
    }

    public Point2D.Double getPosition(Point mapPoint) {
        int x = this.center.x + mapPoint.x - this.getWidth() / 2;
        int y = this.center.y + mapPoint.y - this.getHeight() / 2;
        double lon = OsmMercator.XToLon(x, this.zoom);
        double lat = OsmMercator.YToLat(y, this.zoom);
        return new Point2D.Double(lat, lon);
    }

    public Point getMapPosition(double lat, double lon) {
        int x = OsmMercator.LonToX(lon, this.zoom);
        int y = OsmMercator.LatToY(lat, this.zoom);
        if ((x -= this.center.x - this.getWidth() / 2) < 0 || (y -= this.center.y - this.getHeight() / 2) < 0 || x > this.getWidth() || y > this.getHeight()) {
            return null;
        }
        return new Point(x, y);
    }

    @Override
    protected void paintComponent(Graphics g) {
        boolean start_top;
        super.paintComponent(g);
        int iMove = 0;
        int tilex = this.center.x / 256;
        int tiley = this.center.y / 256;
        int off_x = this.center.x % 256;
        int off_y = this.center.y % 256;
        int w2 = this.getWidth() / 2;
        int h2 = this.getHeight() / 2;
        int posx = w2 - off_x;
        int posy = h2 - off_y;
        int diff_left = off_x;
        int diff_right = 256 - off_x;
        int diff_top = off_y;
        int diff_bottom = 256 - off_y;
        boolean start_left = diff_left < diff_right;
        boolean bl = start_top = diff_top < diff_bottom;
        iMove = start_top ? (start_left ? 2 : 3) : (start_left ? 1 : 0);
        int x_min = -256;
        int y_min = -256;
        int x_max = this.getWidth();
        int y_max = this.getHeight();
        boolean painted = true;
        int x = 0;
        while (painted) {
            painted = false;
            for (int i = 0; i < 4; ++i) {
                if (i % 2 == 0) {
                    ++x;
                }
                for (int j = 0; j < x; ++j) {
                    Tile tile;
                    if (x_min <= posx && posx <= x_max && y_min <= posy && posy <= y_max && (tile = this.getTile(tilex, tiley, this.zoom)) != null) {
                        painted = true;
                        tile.paint(g, posx, posy);
                        if (this.tileGridVisible) {
                            g.drawRect(posx, posy, 256, 256);
                        }
                    }
                    Point p = move[iMove];
                    posx += p.x * 256;
                    posy += p.y * 256;
                    tilex += p.x;
                    tiley += p.y;
                }
                iMove = (iMove + 1) % move.length;
            }
        }
        int mapSize = 256 << this.zoom;
        g.drawRect(w2 - this.center.x, h2 - this.center.y, mapSize, mapSize);
        if (!this.mapMarkersVisible || this.mapMarkerList == null) {
            return;
        }
        for (MapMarker marker : this.mapMarkerList) {
            Point p = this.getMapPosition(marker.getLat(), marker.getLon());
            if (p == null) continue;
            marker.paint(g, p);
        }
    }

    public void moveMap(int x, int y) {
        this.center.x += x;
        this.center.y += y;
        this.repaint();
    }

    public int getZoom() {
        return this.zoom;
    }

    public void zoomIn() {
        this.setZoom(this.zoom + 1);
    }

    public void zoomIn(Point mapPoint) {
        this.setZoom(this.zoom + 1, mapPoint);
    }

    public void zoomOut() {
        this.setZoom(this.zoom - 1);
    }

    public void zoomOut(Point mapPoint) {
        this.setZoom(this.zoom - 1, mapPoint);
    }

    public void setZoom(int zoom, Point mapPoint) {
        if (zoom > this.tileSource.getMaxZoom() || zoom == this.zoom) {
            return;
        }
        Point2D.Double zoomPos = this.getPosition(mapPoint);
        this.jobDispatcher.cancelOutstandingJobs();
        this.setDisplayPositionByLatLon(mapPoint, zoomPos.x, zoomPos.y, zoom);
    }

    public void setZoom(int zoom) {
        this.setZoom(zoom, new Point(this.getWidth() / 2, this.getHeight() / 2));
    }

    protected Tile getTile(int tilex, int tiley, int zoom) {
        int max = 1 << zoom;
        if (tilex < 0 || tilex >= max || tiley < 0 || tiley >= max) {
            return null;
        }
        Tile tile = this.tileCache.getTile(this.tileSource, tilex, tiley, zoom);
        if (tile == null) {
            tile = new Tile(this.tileSource, tilex, tiley, zoom, this.loadingImage);
            this.tileCache.addTile(tile);
            tile.loadPlaceholderFromCache(this.tileCache);
        }
        if (!tile.isLoaded()) {
            this.jobDispatcher.addJob(this.tileLoader.createTileLoaderJob(this.tileSource, tilex, tiley, zoom));
        }
        return tile;
    }

    protected void zoomChanged(int oldZoom) {
        this.zoomSlider.setToolTipText("Zoom level " + this.zoom);
        this.zoomInButton.setToolTipText("Zoom to level " + (this.zoom + 1));
        this.zoomOutButton.setToolTipText("Zoom to level " + (this.zoom - 1));
        this.zoomOutButton.setEnabled(this.zoom > 0);
        this.zoomInButton.setEnabled(this.zoom < this.tileSource.getMaxZoom());
    }

    public boolean isTileGridVisible() {
        return this.tileGridVisible;
    }

    public void setTileGridVisible(boolean tileGridVisible) {
        this.tileGridVisible = tileGridVisible;
        this.repaint();
    }

    public boolean getMapMarkersVisible() {
        return this.mapMarkersVisible;
    }

    public void setMapMarkerVisible(boolean mapMarkersVisible) {
        this.mapMarkersVisible = mapMarkersVisible;
        this.repaint();
    }

    public void setMapMarkerList(List<MapMarker> mapMarkerList) {
        this.mapMarkerList = mapMarkerList;
        this.repaint();
    }

    public List<MapMarker> getMapMarkerList() {
        return this.mapMarkerList;
    }

    public void addMapMarker(MapMarker marker) {
        this.mapMarkerList.add(marker);
    }

    public void setZoomContolsVisible(boolean visible) {
        this.zoomSlider.setVisible(visible);
        this.zoomInButton.setVisible(visible);
        this.zoomOutButton.setVisible(visible);
    }

    public boolean getZoomContolsVisible() {
        return this.zoomSlider.isVisible();
    }

    @Override
    public TileCache getTileCache() {
        return this.tileCache;
    }

    public TileLoader getTileLoader() {
        return this.tileLoader;
    }

    public void setTileLoader(TileLoader tileLoader) {
        this.tileLoader = tileLoader;
    }

    public TileSource getTileLayerSource() {
        return this.tileSource;
    }

    public void setTileSource(TileSource tileSource) {
        if (tileSource.getMaxZoom() > 22) {
            throw new RuntimeException("Zoom level too high");
        }
        this.tileSource = tileSource;
        this.zoomSlider.setMaximum(tileSource.getMaxZoom());
        this.jobDispatcher.cancelOutstandingJobs();
        if (this.zoom > tileSource.getMaxZoom()) {
            this.setZoom(tileSource.getMaxZoom());
        }
        this.repaint();
    }

    @Override
    public void tileLoadingFinished(Tile tile) {
        this.repaint();
    }
}

