/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import org.openstreetmap.gui.jmapviewer.JobDispatcher;
import org.openstreetmap.gui.jmapviewer.OsmTileLoader;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;

public class OsmFileCacheTileLoader
extends OsmTileLoader {
    private static final String ETAG_FILE_EXT = ".etag";
    private static final Charset ETAG_CHARSET = Charset.forName("UTF-8");
    public static final long FILE_AGE_ONE_DAY = 86400000L;
    public static final long FILE_AGE_ONE_WEEK = 604800000L;
    protected String cacheDirBase;
    protected long maxCacheFileAge = 604800000L;
    protected long recheckAfter = 86400000L;

    public OsmFileCacheTileLoader(TileLoaderListener map) {
        super(map);
        String tempDir = System.getProperty("java.io.tmpdir");
        try {
            if (tempDir == null) {
                throw new IOException();
            }
            File cacheDir = new File(tempDir, "JMapViewerTiles");
            if (!cacheDir.exists() && !cacheDir.mkdirs()) {
                throw new IOException();
            }
            this.cacheDirBase = cacheDir.getAbsolutePath();
        }
        catch (Exception e) {
            this.cacheDirBase = "tiles";
        }
    }

    public Runnable createTileLoaderJob(TileSource source, int tilex, int tiley, int zoom) {
        return new FileLoadJob(source, tilex, tiley, zoom);
    }

    public long getMaxFileAge() {
        return this.maxCacheFileAge;
    }

    public void setCacheMaxFileAge(long maxFileAge) {
        this.maxCacheFileAge = maxFileAge;
    }

    public String getCacheDirBase() {
        return this.cacheDirBase;
    }

    public void setTileCacheDir(String tileCacheDir) {
        File dir = new File(tileCacheDir);
        dir.mkdirs();
        this.cacheDirBase = dir.getAbsolutePath();
    }

    protected class FileLoadJob
    implements Runnable {
        InputStream input = null;
        int tilex;
        int tiley;
        int zoom;
        Tile tile;
        TileSource source;
        File tileCacheDir;
        File tileFile = null;
        long fileAge = 0L;
        boolean fileTilePainted = false;

        public FileLoadJob(TileSource source, int tilex, int tiley, int zoom) {
            this.source = source;
            this.tilex = tilex;
            this.tiley = tiley;
            this.zoom = zoom;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            TileCache cache;
            TileCache tileCache = cache = OsmFileCacheTileLoader.this.listener.getTileCache();
            synchronized (tileCache) {
                this.tile = cache.getTile(this.source, this.tilex, this.tiley, this.zoom);
                if (this.tile == null || this.tile.isLoaded() || this.tile.loading) {
                    return;
                }
                this.tile.loading = true;
            }
            this.tileCacheDir = new File(OsmFileCacheTileLoader.this.cacheDirBase, this.source.getName());
            if (!this.tileCacheDir.exists()) {
                this.tileCacheDir.mkdirs();
            }
            if (this.loadTileFromFile()) {
                return;
            }
            if (this.fileTilePainted) {
                Runnable job = new Runnable(){

                    public void run() {
                        FileLoadJob.this.loadorUpdateTile();
                    }
                };
                JobDispatcher.getInstance().addJob(job);
            } else {
                this.loadorUpdateTile();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void loadorUpdateTile() {
            try {
                HttpURLConnection urlConn = OsmFileCacheTileLoader.this.loadTileFromOsm(this.tile);
                if (this.tileFile != null) {
                    switch (this.source.getTileUpdate()) {
                        case IfModifiedSince: {
                            urlConn.setIfModifiedSince(this.fileAge);
                            break;
                        }
                        case LastModified: {
                            if (this.isOsmTileNewer(this.fileAge)) break;
                            this.tile.setLoaded(true);
                            this.tileFile.setLastModified(System.currentTimeMillis() - OsmFileCacheTileLoader.this.maxCacheFileAge + OsmFileCacheTileLoader.this.recheckAfter);
                            return;
                        }
                    }
                }
                if (this.source.getTileUpdate() == TileSource.TileUpdate.ETag || this.source.getTileUpdate() == TileSource.TileUpdate.IfNoneMatch) {
                    String fileETag;
                    if (this.tileFile != null && (fileETag = this.loadETagfromFile()) != null) {
                        switch (this.source.getTileUpdate()) {
                            case IfNoneMatch: {
                                urlConn.addRequestProperty("If-None-Match", fileETag);
                                break;
                            }
                            case ETag: {
                                if (!this.hasOsmTileETag(fileETag)) break;
                                this.tile.setLoaded(true);
                                this.tileFile.setLastModified(System.currentTimeMillis() - OsmFileCacheTileLoader.this.maxCacheFileAge + OsmFileCacheTileLoader.this.recheckAfter);
                                return;
                            }
                        }
                    }
                    String eTag = urlConn.getHeaderField("ETag");
                    this.saveETagToFile(eTag);
                }
                if (urlConn.getResponseCode() == 304) {
                    System.out.println("Local version is up to date: " + this.tile);
                    this.tile.setLoaded(true);
                    this.tileFile.setLastModified(System.currentTimeMillis() - OsmFileCacheTileLoader.this.maxCacheFileAge + OsmFileCacheTileLoader.this.recheckAfter);
                    return;
                }
                byte[] buffer = this.loadTileInBuffer(urlConn);
                if (buffer != null) {
                    this.tile.loadImage(new ByteArrayInputStream(buffer));
                    this.tile.setLoaded(true);
                    OsmFileCacheTileLoader.this.listener.tileLoadingFinished(this.tile);
                    this.saveTileToFile(buffer);
                } else {
                    this.tile.setLoaded(true);
                }
            }
            catch (Exception e) {
                if (this.input == null) {
                    System.err.println("failed loading " + this.zoom + "/" + this.tilex + "/" + this.tiley + " " + e.getMessage());
                }
            }
            finally {
                this.tile.loading = false;
            }
        }

        protected boolean loadTileFromFile() {
            FileInputStream fin = null;
            try {
                boolean oldTile;
                this.tileFile = this.getTileFile();
                fin = new FileInputStream(this.tileFile);
                if (fin.available() == 0) {
                    throw new IOException("File empty");
                }
                this.tile.loadImage(fin);
                fin.close();
                this.fileAge = this.tileFile.lastModified();
                boolean bl = oldTile = System.currentTimeMillis() - this.fileAge > OsmFileCacheTileLoader.this.maxCacheFileAge;
                if (!oldTile) {
                    this.tile.setLoaded(true);
                    OsmFileCacheTileLoader.this.listener.tileLoadingFinished(this.tile);
                    this.fileTilePainted = true;
                    return true;
                }
                OsmFileCacheTileLoader.this.listener.tileLoadingFinished(this.tile);
                this.fileTilePainted = true;
            }
            catch (Exception e) {
                try {
                    if (fin != null) {
                        fin.close();
                        this.tileFile.delete();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.tileFile = null;
                this.fileAge = 0L;
            }
            return false;
        }

        protected byte[] loadTileInBuffer(URLConnection urlConn) throws IOException {
            this.input = urlConn.getInputStream();
            ByteArrayOutputStream bout = new ByteArrayOutputStream(this.input.available());
            byte[] buffer = new byte[2048];
            boolean finished = false;
            do {
                int read;
                if ((read = this.input.read(buffer)) >= 0) {
                    bout.write(buffer, 0, read);
                    continue;
                }
                finished = true;
            } while (!finished);
            if (bout.size() == 0) {
                return null;
            }
            return bout.toByteArray();
        }

        protected boolean isOsmTileNewer(long fileAge) throws IOException {
            URL url = new URL(this.tile.getUrl());
            HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
            urlConn.setRequestMethod("HEAD");
            urlConn.setReadTimeout(30000);
            long lastModified = urlConn.getLastModified();
            if (lastModified == 0L) {
                return true;
            }
            return lastModified > fileAge;
        }

        protected boolean hasOsmTileETag(String eTag) throws IOException {
            URL url = new URL(this.tile.getUrl());
            HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
            urlConn.setRequestMethod("HEAD");
            urlConn.setReadTimeout(30000);
            String osmETag = urlConn.getHeaderField("ETag");
            if (osmETag == null) {
                return true;
            }
            return osmETag.equals(eTag);
        }

        protected File getTileFile() throws IOException {
            return new File(this.tileCacheDir + "/" + this.tile.getZoom() + "_" + this.tile.getXtile() + "_" + this.tile.getYtile() + "." + this.source.getTileType());
        }

        protected void saveTileToFile(byte[] rawData) {
            try {
                FileOutputStream f = new FileOutputStream(this.tileCacheDir + "/" + this.tile.getZoom() + "_" + this.tile.getXtile() + "_" + this.tile.getYtile() + "." + this.source.getTileType());
                f.write(rawData);
                f.close();
            }
            catch (Exception e) {
                System.err.println("Failed to save tile content: " + e.getLocalizedMessage());
            }
        }

        protected void saveETagToFile(String eTag) {
            try {
                FileOutputStream f = new FileOutputStream(this.tileCacheDir + "/" + this.tile.getZoom() + "_" + this.tile.getXtile() + "_" + this.tile.getYtile() + OsmFileCacheTileLoader.ETAG_FILE_EXT);
                f.write(eTag.getBytes(ETAG_CHARSET.name()));
                f.close();
            }
            catch (Exception e) {
                System.err.println("Failed to save ETag: " + e.getLocalizedMessage());
            }
        }

        protected String loadETagfromFile() {
            try {
                FileInputStream f = new FileInputStream(this.tileCacheDir + "/" + this.tile.getZoom() + "_" + this.tile.getXtile() + "_" + this.tile.getYtile() + OsmFileCacheTileLoader.ETAG_FILE_EXT);
                byte[] buf = new byte[f.available()];
                f.read(buf);
                f.close();
                return new String(buf, ETAG_CHARSET.name());
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

