/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osb;

import java.awt.geom.Point2D;
import java.util.concurrent.TimeUnit;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.plugins.osb.OsbPlugin;

public class OsbDownloadLoop
extends Thread {
    private static OsbDownloadLoop instance;
    private long countdown = TimeUnit.SECONDS.toMillis(1L);
    private boolean downloadDone = false;
    private final int INTERVAL = 100;
    private OsbPlugin plugin;
    private Point2D lastCenter;

    public OsbDownloadLoop() {
        this.start();
    }

    public static synchronized OsbDownloadLoop getInstance() {
        if (instance == null) {
            instance = new OsbDownloadLoop();
        }
        return instance;
    }

    public void run() {
        try {
            while (true) {
                EastNorth currentCenter;
                this.countdown -= 100L;
                if (Main.map != null && Main.map.mapView != null && (currentCenter = Main.map.mapView.getCenter()) != null && !currentCenter.equals(this.lastCenter)) {
                    this.resetCountdown();
                    this.lastCenter = currentCenter;
                }
                if (Main.pref.getBoolean("osb.auto_download") && OsbPlugin.active && this.countdown < 0L) {
                    if (!this.downloadDone) {
                        if (this.plugin != null) {
                            this.plugin.updateData();
                            this.downloadDone = true;
                        }
                    } else {
                        this.countdown = -1L;
                    }
                }
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return;
        }
    }

    public void resetCountdown() {
        this.downloadDone = false;
        this.countdown = TimeUnit.SECONDS.toMillis(1L);
    }

    public void setPlugin(OsbPlugin plugin) {
        this.plugin = plugin;
    }
}

