/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osb.gui.action;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.plugins.osb.gui.action.OsbActionObserver;

public abstract class OsbAction
extends AbstractAction {
    private static List<OsbActionObserver> observers = new ArrayList<OsbActionObserver>();
    private static Node selectedNode;

    public OsbAction(String name) {
        super(name);
    }

    public static Node getSelectedNode() {
        return selectedNode;
    }

    public static void setSelectedNode(Node selectedNode) {
        OsbAction.selectedNode = selectedNode;
    }

    public void actionPerformed(ActionEvent e) {
        try {
            this.doActionPerformed(e);
            for (OsbActionObserver obs : observers) {
                obs.actionPerformed(this);
            }
        }
        catch (Exception e1) {
            System.err.println("Couldn't execute action " + this.getClass().getSimpleName());
            e1.printStackTrace();
        }
    }

    protected abstract void doActionPerformed(ActionEvent var1) throws Exception;

    public static void addActionObserver(OsbActionObserver obs) {
        observers.add(obs);
    }

    public static void removeActionObserver(OsbActionObserver obs) {
        observers.remove(obs);
    }
}

