/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.lib.bytebuddy.matcher;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.MethodDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.MethodList;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.type.TypeDefinition;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.type.TypeDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.matcher.ElementMatcher;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.matcher.ElementMatchers;

public class MethodOverrideMatcher<T extends MethodDescription>
extends ElementMatcher.Junction.AbstractBase<T> {
    private final ElementMatcher<? super TypeDescription.Generic> matcher;

    public MethodOverrideMatcher(ElementMatcher<? super TypeDescription.Generic> matcher) {
        this.matcher = matcher;
    }

    @Override
    public boolean matches(T target) {
        HashSet<TypeDescription> duplicates = new HashSet<TypeDescription>();
        for (TypeDefinition typeDefinition : target.getDeclaringType()) {
            if (!this.matches((MethodDescription)target, typeDefinition) && !this.matches((MethodDescription)target, typeDefinition.getInterfaces(), (Set<TypeDescription>)duplicates)) continue;
            return true;
        }
        return false;
    }

    private boolean matches(MethodDescription target, List<? extends TypeDefinition> typeDefinitions, Set<TypeDescription> duplicates) {
        for (TypeDefinition typeDefinition : typeDefinitions) {
            if (!duplicates.add(typeDefinition.asErasure()) || !this.matches(target, typeDefinition) && !this.matches(target, typeDefinition.getInterfaces(), duplicates)) continue;
            return true;
        }
        return false;
    }

    private boolean matches(MethodDescription target, TypeDefinition typeDefinition) {
        for (MethodDescription methodDescription : (MethodList)typeDefinition.getDeclaredMethods().filter(ElementMatchers.isVirtual())) {
            if (!methodDescription.asSignatureToken().equals(target.asSignatureToken())) continue;
            if (!this.matcher.matches(typeDefinition.asGenericType())) break;
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MethodOverrideMatcher that = (MethodOverrideMatcher)object;
        return this.matcher.equals(that.matcher);
    }

    public int hashCode() {
        return this.matcher.hashCode();
    }

    public String toString() {
        return "isOverriddenFrom(" + this.matcher + ")";
    }
}

