/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.auxiliary;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.ClassFileVersion;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.field.FieldDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.MethodDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.modifier.ModifierContributor;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.modifier.SyntheticState;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.type.TypeDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.DynamicType;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.Implementation;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.utility.RandomString;

public interface AuxiliaryType {
    @SuppressFBWarnings(value={"MS_MUTABLE_ARRAY", "MS_OOI_PKGPROTECT"}, justification="The array is not to be modified by contract")
    public static final ModifierContributor.ForType[] DEFAULT_TYPE_MODIFIER = new ModifierContributor.ForType[]{SyntheticState.SYNTHETIC};

    public DynamicType make(String var1, ClassFileVersion var2, MethodAccessorFactory var3);

    @Retention(value=RetentionPolicy.CLASS)
    @Target(value={ElementType.TYPE})
    public static @interface SignatureRelevant {
    }

    public static interface NamingStrategy {
        public String name(TypeDescription var1);

        public static class SuffixingRandom
        implements NamingStrategy {
            private final String suffix;
            private final RandomString randomString;

            public SuffixingRandom(String suffix) {
                this.suffix = suffix;
                this.randomString = new RandomString();
            }

            @Override
            public String name(TypeDescription instrumentedType) {
                return String.format("%s$%s$%s", instrumentedType.getName(), this.suffix, this.randomString.nextString());
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.suffix.equals(((SuffixingRandom)other).suffix);
            }

            public int hashCode() {
                return this.suffix.hashCode();
            }

            public String toString() {
                return "Instrumentation.Context.Default.AuxiliaryTypeNamingStrategySuffixingRandom{suffix='" + this.suffix + '\'' + '}';
            }
        }
    }

    public static interface MethodAccessorFactory {
        public MethodDescription.InDefinedShape registerAccessorFor(Implementation.SpecialMethodInvocation var1);

        public MethodDescription.InDefinedShape registerGetterFor(FieldDescription var1);

        public MethodDescription.InDefinedShape registerSetterFor(FieldDescription var1);

        public static enum Illegal implements MethodAccessorFactory
        {
            INSTANCE;


            @Override
            public MethodDescription.InDefinedShape registerAccessorFor(Implementation.SpecialMethodInvocation specialMethodInvocation) {
                throw new IllegalStateException("It is illegal to register an accessor for this type");
            }

            @Override
            public MethodDescription.InDefinedShape registerGetterFor(FieldDescription fieldDescription) {
                throw new IllegalStateException("It is illegal to register a field getter for this type");
            }

            @Override
            public MethodDescription.InDefinedShape registerSetterFor(FieldDescription fieldDescription) {
                throw new IllegalStateException("It is illegal to register a field setter for this type");
            }

            public String toString() {
                return "AuxiliaryType.MethodAccessorFactory.Illegal." + this.name();
            }
        }
    }
}

