/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.scaffold;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.ClassFileVersion;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.asm.AsmVisitorWrapper;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.annotation.AnnotationList;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.annotation.AnnotationValue;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.field.FieldDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.field.FieldList;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.MethodDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.MethodList;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.ParameterDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.ParameterList;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.type.TypeDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.type.TypeList;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.ClassFileLocator;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.DynamicType;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.TypeResolutionStrategy;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.scaffold.MethodRegistry;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.scaffold.TypeInitializer;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.scaffold.TypeValidation;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.scaffold.inline.MethodRebaseResolver;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.scaffold.inline.RebaseImplementationTarget;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.scaffold.subclass.SubclassImplementationTarget;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.Implementation;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.LoadedTypeInitializer;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.attribute.AnnotationAppender;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.attribute.AnnotationRetention;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.attribute.AnnotationValueFilter;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.attribute.FieldAttributeAppender;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.attribute.MethodAttributeAppender;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.attribute.TypeAttributeAppender;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.auxiliary.AuxiliaryType;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.ByteCodeAppender;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.StackManipulation;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.assign.TypeCasting;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.member.MethodInvocation;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.member.MethodReturn;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.AnnotationVisitor;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.ClassReader;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.ClassVisitor;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.ClassWriter;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.FieldVisitor;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.Handle;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.Label;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.MethodVisitor;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.Type;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.TypePath;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.commons.ClassRemapper;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.commons.SimpleRemapper;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.matcher.ElementMatchers;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.pool.TypePool;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.utility.CompoundList;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.utility.RandomString;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.utility.privilege.GetSystemPropertyAction;

public interface TypeWriter<T> {
    public static final String DUMP_PROPERTY = "nl.jqno.equalsverifier.internal.lib.bytebuddy.dump";

    public DynamicType.Unloaded<T> make(TypeResolutionStrategy.Resolved var1);

    public static abstract class Default<S>
    implements TypeWriter<S> {
        private static final String DUMP_FOLDER;
        protected final TypeDescription instrumentedType;
        protected final ClassFileVersion classFileVersion;
        protected final FieldPool fieldPool;
        protected final List<? extends DynamicType> auxiliaryTypes;
        protected final MethodList<?> instrumentedMethods;
        protected final LoadedTypeInitializer loadedTypeInitializer;
        protected final TypeInitializer typeInitializer;
        protected final TypeAttributeAppender typeAttributeAppender;
        protected final AsmVisitorWrapper asmVisitorWrapper;
        protected final AnnotationValueFilter.Factory annotationValueFilterFactory;
        protected final AnnotationRetention annotationRetention;
        protected final AuxiliaryType.NamingStrategy auxiliaryTypeNamingStrategy;
        protected final Implementation.Context.Factory implementationContextFactory;
        protected final TypeValidation typeValidation;
        protected final TypePool typePool;

        protected Default(TypeDescription instrumentedType, ClassFileVersion classFileVersion, FieldPool fieldPool, List<? extends DynamicType> auxiliaryTypes, MethodList<?> instrumentedMethods, LoadedTypeInitializer loadedTypeInitializer, TypeInitializer typeInitializer, TypeAttributeAppender typeAttributeAppender, AsmVisitorWrapper asmVisitorWrapper, AnnotationValueFilter.Factory annotationValueFilterFactory, AnnotationRetention annotationRetention, AuxiliaryType.NamingStrategy auxiliaryTypeNamingStrategy, Implementation.Context.Factory implementationContextFactory, TypeValidation typeValidation, TypePool typePool) {
            this.instrumentedType = instrumentedType;
            this.classFileVersion = classFileVersion;
            this.fieldPool = fieldPool;
            this.auxiliaryTypes = auxiliaryTypes;
            this.instrumentedMethods = instrumentedMethods;
            this.loadedTypeInitializer = loadedTypeInitializer;
            this.typeInitializer = typeInitializer;
            this.typeAttributeAppender = typeAttributeAppender;
            this.asmVisitorWrapper = asmVisitorWrapper;
            this.auxiliaryTypeNamingStrategy = auxiliaryTypeNamingStrategy;
            this.annotationValueFilterFactory = annotationValueFilterFactory;
            this.annotationRetention = annotationRetention;
            this.implementationContextFactory = implementationContextFactory;
            this.typeValidation = typeValidation;
            this.typePool = typePool;
        }

        public static <U> TypeWriter<U> forCreation(MethodRegistry.Compiled methodRegistry, FieldPool fieldPool, TypeAttributeAppender typeAttributeAppender, AsmVisitorWrapper asmVisitorWrapper, ClassFileVersion classFileVersion, AnnotationValueFilter.Factory annotationValueFilterFactory, AnnotationRetention annotationRetention, AuxiliaryType.NamingStrategy auxiliaryTypeNamingStrategy, Implementation.Context.Factory implementationContextFactory, TypeValidation typeValidation, TypePool typePool) {
            return new ForCreation(methodRegistry.getInstrumentedType(), classFileVersion, fieldPool, methodRegistry, Collections.emptyList(), methodRegistry.getInstrumentedMethods(), methodRegistry.getLoadedTypeInitializer(), methodRegistry.getTypeInitializer(), typeAttributeAppender, asmVisitorWrapper, annotationValueFilterFactory, annotationRetention, auxiliaryTypeNamingStrategy, implementationContextFactory, typeValidation, typePool);
        }

        public static <U> TypeWriter<U> forRedefinition(MethodRegistry.Prepared methodRegistry, FieldPool fieldPool, TypeAttributeAppender typeAttributeAppender, AsmVisitorWrapper asmVisitorWrapper, ClassFileVersion classFileVersion, AnnotationValueFilter.Factory annotationValueFilterFactory, AnnotationRetention annotationRetention, AuxiliaryType.NamingStrategy auxiliaryTypeNamingStrategy, Implementation.Context.Factory implementationContextFactory, TypeValidation typeValidation, TypePool typePool, TypeDescription originalType, ClassFileLocator classFileLocator) {
            return new ForInlining(methodRegistry.getInstrumentedType(), classFileVersion, fieldPool, methodRegistry, SubclassImplementationTarget.Factory.LEVEL_TYPE, Collections.<DynamicType>emptyList(), methodRegistry.getInstrumentedMethods(), methodRegistry.getLoadedTypeInitializer(), methodRegistry.getTypeInitializer(), typeAttributeAppender, asmVisitorWrapper, annotationValueFilterFactory, annotationRetention, auxiliaryTypeNamingStrategy, implementationContextFactory, typeValidation, typePool, originalType, classFileLocator, MethodRebaseResolver.Disabled.INSTANCE);
        }

        public static <U> TypeWriter<U> forRebasing(MethodRegistry.Prepared methodRegistry, FieldPool fieldPool, TypeAttributeAppender typeAttributeAppender, AsmVisitorWrapper asmVisitorWrapper, ClassFileVersion classFileVersion, AnnotationValueFilter.Factory annotationValueFilterFactory, AnnotationRetention annotationRetention, AuxiliaryType.NamingStrategy auxiliaryTypeNamingStrategy, Implementation.Context.Factory implementationContextFactory, TypeValidation typeValidation, TypePool typePool, TypeDescription originalType, ClassFileLocator classFileLocator, MethodRebaseResolver methodRebaseResolver) {
            return new ForInlining(methodRegistry.getInstrumentedType(), classFileVersion, fieldPool, methodRegistry, new RebaseImplementationTarget.Factory(methodRebaseResolver), methodRebaseResolver.getAuxiliaryTypes(), methodRegistry.getInstrumentedMethods(), methodRegistry.getLoadedTypeInitializer(), methodRegistry.getTypeInitializer(), typeAttributeAppender, asmVisitorWrapper, annotationValueFilterFactory, annotationRetention, auxiliaryTypeNamingStrategy, implementationContextFactory, typeValidation, typePool, originalType, classFileLocator, methodRebaseResolver);
        }

        @Override
        @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Setting a debugging property should never change the program outcome")
        public DynamicType.Unloaded<S> make(TypeResolutionStrategy.Resolved typeResolutionStrategy) {
            UnresolvedType unresolvedType = this.create(typeResolutionStrategy.injectedInto(this.typeInitializer));
            if (DUMP_FOLDER != null) {
                try {
                    AccessController.doPrivileged(new ClassDumpAction(DUMP_FOLDER, this.instrumentedType, unresolvedType.getBinaryRepresentation()));
                }
                catch (Exception exception) {
                    Logger.getLogger("nl.jqno.equalsverifier.internal.lib.bytebuddy").log(Level.WARNING, "Could not dump class file for " + this.instrumentedType, exception.getCause());
                }
            }
            return unresolvedType.toDynamicType(typeResolutionStrategy);
        }

        protected abstract UnresolvedType create(TypeInitializer var1);

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Default aDefault = (Default)object;
            return this.instrumentedType.equals(aDefault.instrumentedType) && this.classFileVersion.equals(aDefault.classFileVersion) && this.fieldPool.equals(aDefault.fieldPool) && this.auxiliaryTypes.equals(aDefault.auxiliaryTypes) && this.instrumentedMethods.equals(aDefault.instrumentedMethods) && this.loadedTypeInitializer.equals(aDefault.loadedTypeInitializer) && this.typeInitializer.equals(aDefault.typeInitializer) && this.typeAttributeAppender.equals(aDefault.typeAttributeAppender) && this.asmVisitorWrapper.equals(aDefault.asmVisitorWrapper) && this.annotationValueFilterFactory.equals(aDefault.annotationValueFilterFactory) && this.annotationRetention == aDefault.annotationRetention && this.auxiliaryTypeNamingStrategy.equals(aDefault.auxiliaryTypeNamingStrategy) && this.implementationContextFactory.equals(aDefault.implementationContextFactory) && this.typeValidation == aDefault.typeValidation && this.typePool.equals(aDefault.typePool);
        }

        public int hashCode() {
            int result = this.instrumentedType.hashCode();
            result = 31 * result + this.classFileVersion.hashCode();
            result = 31 * result + this.fieldPool.hashCode();
            result = 31 * result + this.auxiliaryTypes.hashCode();
            result = 31 * result + this.instrumentedMethods.hashCode();
            result = 31 * result + this.loadedTypeInitializer.hashCode();
            result = 31 * result + this.typeInitializer.hashCode();
            result = 31 * result + this.typeAttributeAppender.hashCode();
            result = 31 * result + this.asmVisitorWrapper.hashCode();
            result = 31 * result + this.annotationValueFilterFactory.hashCode();
            result = 31 * result + this.annotationRetention.hashCode();
            result = 31 * result + this.auxiliaryTypeNamingStrategy.hashCode();
            result = 31 * result + this.implementationContextFactory.hashCode();
            result = 31 * result + this.typeValidation.hashCode();
            result = 31 * result + this.typePool.hashCode();
            return result;
        }

        static {
            String dumpFolder;
            try {
                dumpFolder = AccessController.doPrivileged(new GetSystemPropertyAction(TypeWriter.DUMP_PROPERTY));
            }
            catch (RuntimeException exception) {
                dumpFolder = null;
                Logger.getLogger("nl.jqno.equalsverifier.internal.lib.bytebuddy").log(Level.WARNING, "Could not enable dumping of class files", exception);
            }
            DUMP_FOLDER = dumpFolder;
        }

        protected static class ClassDumpAction
        implements PrivilegedExceptionAction<Void> {
            private static final Void NOTHING = null;
            private final String target;
            private final TypeDescription instrumentedType;
            private final byte[] binaryRepresentation;

            protected ClassDumpAction(String target, TypeDescription instrumentedType, byte[] binaryRepresentation) {
                this.target = target;
                this.instrumentedType = instrumentedType;
                this.binaryRepresentation = binaryRepresentation;
            }

            @Override
            public Void run() throws Exception {
                FileOutputStream outputStream = new FileOutputStream(new File(this.target, this.instrumentedType.getName() + "." + System.currentTimeMillis()));
                try {
                    ((OutputStream)outputStream).write(this.binaryRepresentation);
                    Void void_ = NOTHING;
                    return void_;
                }
                finally {
                    ((OutputStream)outputStream).close();
                }
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                ClassDumpAction that = (ClassDumpAction)object;
                return this.instrumentedType.equals(that.instrumentedType) && this.target.equals(that.target) && Arrays.equals(this.binaryRepresentation, that.binaryRepresentation);
            }

            public int hashCode() {
                int result = this.instrumentedType.hashCode();
                result = 31 * result + this.target.hashCode();
                result = 31 * result + Arrays.hashCode(this.binaryRepresentation);
                return result;
            }

            public String toString() {
                return "TypeWriter.Default.ClassDumpAction{target=" + this.target + ", instrumentedType=" + this.instrumentedType + ", binaryRepresentation=<" + this.binaryRepresentation.length + " bytes>" + '}';
            }
        }

        public static class ForCreation<U>
        extends Default<U> {
            private final MethodPool methodPool;

            protected ForCreation(TypeDescription instrumentedType, ClassFileVersion classFileVersion, FieldPool fieldPool, MethodPool methodPool, List<? extends DynamicType> auxiliaryTypes, MethodList<?> instrumentedMethods, LoadedTypeInitializer loadedTypeInitializer, TypeInitializer typeInitializer, TypeAttributeAppender typeAttributeAppender, AsmVisitorWrapper asmVisitorWrapper, AnnotationValueFilter.Factory annotationValueFilterFactory, AnnotationRetention annotationRetention, AuxiliaryType.NamingStrategy auxiliaryTypeNamingStrategy, Implementation.Context.Factory implementationContextFactory, TypeValidation typeValidation, TypePool typePool) {
                super(instrumentedType, classFileVersion, fieldPool, auxiliaryTypes, instrumentedMethods, loadedTypeInitializer, typeInitializer, typeAttributeAppender, asmVisitorWrapper, annotationValueFilterFactory, annotationRetention, auxiliaryTypeNamingStrategy, implementationContextFactory, typeValidation, typePool);
                this.methodPool = methodPool;
            }

            @Override
            protected UnresolvedType create(TypeInitializer typeInitializer) {
                int writerFlags = this.asmVisitorWrapper.mergeWriter(0);
                FrameComputingClassWriter classWriter = new FrameComputingClassWriter(writerFlags, this.typePool);
                ClassVisitor classVisitor = this.asmVisitorWrapper.wrap(this.instrumentedType, ValidatingClassVisitor.of(classWriter, this.typeValidation), writerFlags, this.asmVisitorWrapper.mergeReader(0));
                classVisitor.visit(this.classFileVersion.getMinorMajorVersion(), this.instrumentedType.getActualModifiers(!this.instrumentedType.isInterface()), this.instrumentedType.getInternalName(), this.instrumentedType.getGenericSignature(), (this.instrumentedType.getSuperClass() == null ? TypeDescription.OBJECT : this.instrumentedType.getSuperClass().asErasure()).getInternalName(), this.instrumentedType.getInterfaces().asErasures().toInternalNames());
                Implementation.Context.ExtractableView implementationContext = this.implementationContextFactory.make(this.instrumentedType, this.auxiliaryTypeNamingStrategy, typeInitializer, this.classFileVersion, this.classFileVersion);
                this.typeAttributeAppender.apply(classVisitor, this.instrumentedType, this.annotationValueFilterFactory.on(this.instrumentedType));
                for (FieldDescription fieldDescription : this.instrumentedType.getDeclaredFields()) {
                    this.fieldPool.target(fieldDescription).apply(classVisitor, this.annotationValueFilterFactory);
                }
                for (MethodDescription methodDescription : this.instrumentedMethods) {
                    this.methodPool.target(methodDescription).apply(classVisitor, implementationContext, this.annotationValueFilterFactory);
                }
                implementationContext.drain(classVisitor, this.methodPool, Implementation.Context.ExtractableView.InjectedCode.None.INSTANCE, this.annotationValueFilterFactory);
                classVisitor.visitEnd();
                return new UnresolvedType(classWriter.toByteArray(), implementationContext.getAuxiliaryTypes());
            }

            @Override
            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                if (!super.equals(object)) {
                    return false;
                }
                ForCreation that = (ForCreation)object;
                return this.methodPool.equals(that.methodPool);
            }

            @Override
            public int hashCode() {
                int result = super.hashCode();
                result = 31 * result + this.methodPool.hashCode();
                return result;
            }

            public String toString() {
                return "TypeWriter.Default.ForCreation{instrumentedType=" + this.instrumentedType + ", fieldPool=" + this.fieldPool + ", methodPool=" + this.methodPool + ", auxiliaryTypes=" + this.auxiliaryTypes + ", instrumentedMethods=" + this.instrumentedMethods + ", loadedTypeInitializer=" + this.loadedTypeInitializer + ", typeInitializer=" + this.typeInitializer + ", typeAttributeAppender=" + this.typeAttributeAppender + ", asmVisitorWrapper=" + this.asmVisitorWrapper + ", classFileVersion=" + this.classFileVersion + ", annotationValueFilterFactory=" + this.annotationValueFilterFactory + ", annotationRetention=" + (Object)((Object)this.annotationRetention) + ", auxiliaryTypeNamingStrategy=" + this.auxiliaryTypeNamingStrategy + ", implementationContextFactory=" + this.implementationContextFactory + ", typeValidation=" + (Object)((Object)this.typeValidation) + ", typePool=" + this.typePool + '}';
            }
        }

        public static class ForInlining<U>
        extends Default<U> {
            private static final String NO_SUPER_TYPE = null;
            private static final MethodVisitor IGNORE_METHOD = null;
            private static final AnnotationVisitor IGNORE_ANNOTATION = null;
            private final MethodRegistry.Prepared methodRegistry;
            private final Implementation.Target.Factory implementationTargetFactory;
            private final TypeDescription originalType;
            private final ClassFileLocator classFileLocator;
            private final MethodRebaseResolver methodRebaseResolver;

            protected ForInlining(TypeDescription instrumentedType, ClassFileVersion classFileVersion, FieldPool fieldPool, MethodRegistry.Prepared methodRegistry, Implementation.Target.Factory implementationTargetFactory, List<DynamicType> explicitAuxiliaryTypes, MethodList<?> instrumentedMethods, LoadedTypeInitializer loadedTypeInitializer, TypeInitializer typeInitializer, TypeAttributeAppender typeAttributeAppender, AsmVisitorWrapper asmVisitorWrapper, AnnotationValueFilter.Factory annotationValueFilterFactory, AnnotationRetention annotationRetention, AuxiliaryType.NamingStrategy auxiliaryTypeNamingStrategy, Implementation.Context.Factory implementationContextFactory, TypeValidation typeValidation, TypePool typePool, TypeDescription originalType, ClassFileLocator classFileLocator, MethodRebaseResolver methodRebaseResolver) {
                super(instrumentedType, classFileVersion, fieldPool, explicitAuxiliaryTypes, instrumentedMethods, loadedTypeInitializer, typeInitializer, typeAttributeAppender, asmVisitorWrapper, annotationValueFilterFactory, annotationRetention, auxiliaryTypeNamingStrategy, implementationContextFactory, typeValidation, typePool);
                this.methodRegistry = methodRegistry;
                this.implementationTargetFactory = implementationTargetFactory;
                this.originalType = originalType;
                this.classFileLocator = classFileLocator;
                this.methodRebaseResolver = methodRebaseResolver;
            }

            @Override
            protected UnresolvedType create(TypeInitializer typeInitializer) {
                try {
                    int writerFlags = this.asmVisitorWrapper.mergeWriter(0);
                    int readerFlags = this.asmVisitorWrapper.mergeReader(0);
                    ClassReader classReader = new ClassReader(this.classFileLocator.locate(this.originalType.getName()).resolve());
                    FrameComputingClassWriter classWriter = new FrameComputingClassWriter(classReader, writerFlags, this.typePool);
                    ContextRegistry contextRegistry = new ContextRegistry();
                    classReader.accept(this.writeTo(this.asmVisitorWrapper.wrap(this.instrumentedType, ValidatingClassVisitor.of(classWriter, this.typeValidation), writerFlags, readerFlags), typeInitializer, contextRegistry), readerFlags);
                    return new UnresolvedType(classWriter.toByteArray(), contextRegistry.getAuxiliaryTypes());
                }
                catch (IOException exception) {
                    throw new RuntimeException("The class file could not be written", exception);
                }
            }

            private ClassVisitor writeTo(ClassVisitor classVisitor, TypeInitializer typeInitializer, ContextRegistry contextRegistry) {
                return this.originalType.getName().equals(this.instrumentedType.getName()) ? new RedefinitionClassVisitor(classVisitor, typeInitializer, contextRegistry) : new ClassRemapper(new RedefinitionClassVisitor(classVisitor, typeInitializer, contextRegistry), new SimpleRemapper(this.originalType.getInternalName(), this.instrumentedType.getInternalName()));
            }

            @Override
            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                if (!super.equals(object)) {
                    return false;
                }
                ForInlining that = (ForInlining)object;
                return this.methodRegistry.equals(that.methodRegistry) && this.implementationTargetFactory.equals(that.implementationTargetFactory) && this.originalType.equals(that.originalType) && this.classFileLocator.equals(that.classFileLocator) && this.methodRebaseResolver.equals(that.methodRebaseResolver);
            }

            @Override
            public int hashCode() {
                int result = super.hashCode();
                result = 31 * result + this.methodRegistry.hashCode();
                result = 31 * result + this.implementationTargetFactory.hashCode();
                result = 31 * result + this.originalType.hashCode();
                result = 31 * result + this.classFileLocator.hashCode();
                result = 31 * result + this.methodRebaseResolver.hashCode();
                return result;
            }

            public String toString() {
                return "TypeWriter.Default.ForInlining{instrumentedType=" + this.instrumentedType + ", fieldPool=" + this.fieldPool + ", methodRegistry=" + this.methodRegistry + ", auxiliaryTypes=" + this.auxiliaryTypes + ", instrumentedMethods=" + this.instrumentedMethods + ", loadedTypeInitializer=" + this.loadedTypeInitializer + ", typeInitializer=" + this.typeInitializer + ", typeAttributeAppender=" + this.typeAttributeAppender + ", asmVisitorWrapper=" + this.asmVisitorWrapper + ", annotationValueFilterFactory=" + this.annotationValueFilterFactory + ", annotationRetention=" + (Object)((Object)this.annotationRetention) + ", auxiliaryTypeNamingStrategy=" + this.auxiliaryTypeNamingStrategy + ", implementationContextFactory=" + this.implementationContextFactory + ", implementationTargetFactory=" + this.implementationTargetFactory + ", typeValidation=" + (Object)((Object)this.typeValidation) + ", originalType=" + this.originalType + ", classFileLocator=" + this.classFileLocator + ", methodRebaseResolver=" + this.methodRebaseResolver + '}';
            }

            @SuppressFBWarnings(value={"UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"}, justification="Field access order is implied by ASM")
            protected class RedefinitionClassVisitor
            extends ClassVisitor {
                private final TypeInitializer typeInitializer;
                private final ContextRegistry contextRegistry;
                private final Map<String, FieldDescription> declaredFields;
                private final Map<String, MethodDescription> declarableMethods;
                private Implementation.Context.ExtractableView implementationContext;
                private Implementation.Context.ExtractableView.InjectedCode injectedCode;
                private MethodPool methodPool;

                protected RedefinitionClassVisitor(ClassVisitor classVisitor, TypeInitializer typeInitializer, ContextRegistry contextRegistry) {
                    super(327680, classVisitor);
                    this.typeInitializer = typeInitializer;
                    this.contextRegistry = contextRegistry;
                    FieldList<FieldDescription.InDefinedShape> fieldDescriptions = ForInlining.this.instrumentedType.getDeclaredFields();
                    this.declaredFields = new HashMap<String, FieldDescription>();
                    for (FieldDescription fieldDescription : fieldDescriptions) {
                        this.declaredFields.put(fieldDescription.getName(), fieldDescription);
                    }
                    this.declarableMethods = new HashMap<String, MethodDescription>();
                    for (MethodDescription methodDescription : ForInlining.this.instrumentedMethods) {
                        this.declarableMethods.put(methodDescription.getInternalName() + methodDescription.getDescriptor(), methodDescription);
                    }
                    this.injectedCode = Implementation.Context.ExtractableView.InjectedCode.None.INSTANCE;
                }

                @Override
                public void visit(int classFileVersionNumber, int modifiers, String internalName, String genericSignature, String superClassInternalName, String[] interfaceTypeInternalName) {
                    ClassFileVersion classFileVersion = ClassFileVersion.ofMinorMajor(classFileVersionNumber);
                    this.methodPool = ForInlining.this.methodRegistry.compile(ForInlining.this.implementationTargetFactory, classFileVersion);
                    this.implementationContext = ForInlining.this.implementationContextFactory.make(ForInlining.this.instrumentedType, ForInlining.this.auxiliaryTypeNamingStrategy, this.typeInitializer, classFileVersion, ForInlining.this.classFileVersion);
                    this.contextRegistry.setImplementationContext(this.implementationContext);
                    if (!classFileVersion.isAtLeast(ClassFileVersion.JAVA_V8) && ForInlining.this.instrumentedType.isInterface()) {
                        this.implementationContext.prohibitTypeInitializer();
                    }
                    super.visit(classFileVersionNumber, ForInlining.this.instrumentedType.getActualModifiers((modifiers & 0x20) != 0 && !ForInlining.this.instrumentedType.isInterface()) | ((modifiers & 0x10) != 0 && ForInlining.this.instrumentedType.isAnonymousClass() ? 16 : 0), ForInlining.this.instrumentedType.getInternalName(), ForInlining.this.instrumentedType.getGenericSignature(), ForInlining.this.instrumentedType.getSuperClass() == null ? (ForInlining.this.instrumentedType.isInterface() ? TypeDescription.OBJECT.getInternalName() : NO_SUPER_TYPE) : ForInlining.this.instrumentedType.getSuperClass().asErasure().getInternalName(), ForInlining.this.instrumentedType.getInterfaces().asErasures().toInternalNames());
                    ForInlining.this.typeAttributeAppender.apply(this.cv, ForInlining.this.instrumentedType, ForInlining.this.annotationValueFilterFactory.on(ForInlining.this.instrumentedType));
                }

                @Override
                public void visitInnerClass(String internalName, String outerName, String innerName, int modifiers) {
                    if (internalName.equals(ForInlining.this.instrumentedType.getInternalName())) {
                        modifiers = ForInlining.this.instrumentedType.getModifiers();
                    }
                    super.visitInnerClass(internalName, outerName, innerName, modifiers);
                }

                @Override
                public AnnotationVisitor visitTypeAnnotation(int typeReference, TypePath typePath, String descriptor, boolean visible) {
                    return ForInlining.this.annotationRetention.isEnabled() ? super.visitTypeAnnotation(typeReference, typePath, descriptor, visible) : IGNORE_ANNOTATION;
                }

                @Override
                public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                    return ForInlining.this.annotationRetention.isEnabled() ? super.visitAnnotation(descriptor, visible) : IGNORE_ANNOTATION;
                }

                @Override
                public FieldVisitor visitField(int modifiers, String internalName, String descriptor, String genericSignature, Object defaultValue) {
                    FieldPool.Record record;
                    FieldDescription fieldDescription = this.declaredFields.remove(internalName);
                    if (fieldDescription != null && !(record = ForInlining.this.fieldPool.target(fieldDescription)).isImplicit()) {
                        return this.redefine(record, defaultValue);
                    }
                    return super.visitField(modifiers, internalName, descriptor, genericSignature, defaultValue);
                }

                protected FieldVisitor redefine(FieldPool.Record record, Object defaultValue) {
                    FieldDescription instrumentedField = record.getField();
                    return new AttributeObtainingFieldVisitor(super.visitField(instrumentedField.getActualModifiers(), instrumentedField.getInternalName(), instrumentedField.getDescriptor(), instrumentedField.getGenericSignature(), record.resolveDefault(defaultValue)), record);
                }

                @Override
                public MethodVisitor visitMethod(int modifiers, String internalName, String descriptor, String genericSignature, String[] exceptionTypeInternalName) {
                    if (internalName.equals("<clinit>")) {
                        if (this.implementationContext.isRetainTypeInitializer()) {
                            return super.visitMethod(modifiers, internalName, descriptor, genericSignature, exceptionTypeInternalName);
                        }
                        TypeInitializerInjection injectedCode = new TypeInitializerInjection(new TypeInitializerDelegate(ForInlining.this.instrumentedType, RandomString.make()));
                        this.injectedCode = injectedCode;
                        return super.visitMethod(injectedCode.getInjectorProxyMethod().getActualModifiers(), injectedCode.getInjectorProxyMethod().getInternalName(), injectedCode.getInjectorProxyMethod().getDescriptor(), injectedCode.getInjectorProxyMethod().getGenericSignature(), injectedCode.getInjectorProxyMethod().getExceptionTypes().asErasures().toInternalNames());
                    }
                    MethodDescription methodDescription = this.declarableMethods.remove(internalName + descriptor);
                    return methodDescription == null ? super.visitMethod(modifiers, internalName, descriptor, genericSignature, exceptionTypeInternalName) : this.redefine(methodDescription, (modifiers & 0x400) != 0);
                }

                protected MethodVisitor redefine(MethodDescription methodDescription, boolean abstractOrigin) {
                    MethodPool.Record record = this.methodPool.target(methodDescription);
                    if (!record.getSort().isDefined()) {
                        return super.visitMethod(methodDescription.getActualModifiers(), methodDescription.getInternalName(), methodDescription.getDescriptor(), methodDescription.getGenericSignature(), methodDescription.getExceptionTypes().asErasures().toInternalNames());
                    }
                    MethodDescription implementedMethod = record.getMethod();
                    MethodVisitor methodVisitor = super.visitMethod(implementedMethod.getActualModifiers(record.getSort().isImplemented()), implementedMethod.getInternalName(), implementedMethod.getDescriptor(), implementedMethod.getGenericSignature(), implementedMethod.getExceptionTypes().asErasures().toInternalNames());
                    return abstractOrigin ? new AttributeObtainingMethodVisitor(methodVisitor, record) : new CodePreservingMethodVisitor(methodVisitor, record, ForInlining.this.methodRebaseResolver.resolve((MethodDescription.InDefinedShape)implementedMethod.asDefined()));
                }

                @Override
                public void visitEnd() {
                    for (FieldDescription fieldDescription : this.declaredFields.values()) {
                        ForInlining.this.fieldPool.target(fieldDescription).apply(this.cv, ForInlining.this.annotationValueFilterFactory);
                    }
                    for (MethodDescription methodDescription : this.declarableMethods.values()) {
                        this.methodPool.target(methodDescription).apply(this.cv, this.implementationContext, ForInlining.this.annotationValueFilterFactory);
                    }
                    this.implementationContext.drain(this.cv, this.methodPool, this.injectedCode, ForInlining.this.annotationValueFilterFactory);
                    super.visitEnd();
                }

                public String toString() {
                    return "TypeWriter.Default.ForInlining.RedefinitionClassVisitor{typeWriter=" + ForInlining.this + ", typeInitializer=" + this.typeInitializer + ", contextRegistry=" + this.contextRegistry + ", implementationContext=" + this.implementationContext + ", declaredFields=" + this.declaredFields + ", declarableMethods=" + this.declarableMethods + ", injectedCode=" + this.injectedCode + ", methodPool=" + this.methodPool + '}';
                }

                protected class TypeInitializerInjection
                implements Implementation.Context.ExtractableView.InjectedCode {
                    private final MethodDescription injectorProxyMethod;

                    protected TypeInitializerInjection(MethodDescription injectorProxyMethod) {
                        this.injectorProxyMethod = injectorProxyMethod;
                    }

                    @Override
                    public ByteCodeAppender getByteCodeAppender() {
                        return new ByteCodeAppender.Simple(MethodInvocation.invoke(this.injectorProxyMethod));
                    }

                    @Override
                    public boolean isDefined() {
                        return true;
                    }

                    public MethodDescription getInjectorProxyMethod() {
                        return this.injectorProxyMethod;
                    }

                    public String toString() {
                        return "TypeWriter.Default.ForInlining.RedefinitionClassVisitor.TypeInitializerInjection{classVisitor=" + RedefinitionClassVisitor.this + ", injectorProxyMethod=" + this.injectorProxyMethod + '}';
                    }
                }

                protected class AttributeObtainingMethodVisitor
                extends MethodVisitor {
                    private final MethodVisitor actualMethodVisitor;
                    private final MethodPool.Record record;

                    protected AttributeObtainingMethodVisitor(MethodVisitor actualMethodVisitor, MethodPool.Record record) {
                        super(327680, actualMethodVisitor);
                        this.actualMethodVisitor = actualMethodVisitor;
                        this.record = record;
                        record.applyHead(actualMethodVisitor);
                    }

                    @Override
                    public AnnotationVisitor visitAnnotationDefault() {
                        return IGNORE_ANNOTATION;
                    }

                    @Override
                    public AnnotationVisitor visitTypeAnnotation(int typeReference, TypePath typePath, String descriptor, boolean visible) {
                        return ForInlining.this.annotationRetention.isEnabled() ? super.visitTypeAnnotation(typeReference, typePath, descriptor, visible) : IGNORE_ANNOTATION;
                    }

                    @Override
                    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                        return ForInlining.this.annotationRetention.isEnabled() ? super.visitAnnotation(descriptor, visible) : IGNORE_ANNOTATION;
                    }

                    @Override
                    public AnnotationVisitor visitParameterAnnotation(int index, String descriptor, boolean visible) {
                        return ForInlining.this.annotationRetention.isEnabled() ? super.visitParameterAnnotation(index, descriptor, visible) : IGNORE_ANNOTATION;
                    }

                    @Override
                    public void visitCode() {
                        this.mv = IGNORE_METHOD;
                    }

                    @Override
                    public void visitEnd() {
                        this.record.applyBody(this.actualMethodVisitor, RedefinitionClassVisitor.this.implementationContext, ForInlining.this.annotationValueFilterFactory);
                        this.actualMethodVisitor.visitEnd();
                    }

                    public String toString() {
                        return "TypeWriter.Default.ForInlining.RedefinitionClassVisitor.AttributeObtainingMethodVisitor{classVisitor=" + RedefinitionClassVisitor.this + ", actualMethodVisitor=" + this.actualMethodVisitor + ", record=" + this.record + '}';
                    }
                }

                protected class CodePreservingMethodVisitor
                extends MethodVisitor {
                    private final MethodVisitor actualMethodVisitor;
                    private final MethodPool.Record record;
                    private final MethodRebaseResolver.Resolution resolution;

                    protected CodePreservingMethodVisitor(MethodVisitor actualMethodVisitor, MethodPool.Record record, MethodRebaseResolver.Resolution resolution) {
                        super(327680, actualMethodVisitor);
                        this.actualMethodVisitor = actualMethodVisitor;
                        this.record = record;
                        this.resolution = resolution;
                        record.applyHead(actualMethodVisitor);
                    }

                    @Override
                    public AnnotationVisitor visitAnnotationDefault() {
                        return IGNORE_ANNOTATION;
                    }

                    @Override
                    public AnnotationVisitor visitTypeAnnotation(int typeReference, TypePath typePath, String descriptor, boolean visible) {
                        return ForInlining.this.annotationRetention.isEnabled() ? super.visitTypeAnnotation(typeReference, typePath, descriptor, visible) : IGNORE_ANNOTATION;
                    }

                    @Override
                    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                        return ForInlining.this.annotationRetention.isEnabled() ? super.visitAnnotation(descriptor, visible) : IGNORE_ANNOTATION;
                    }

                    @Override
                    public AnnotationVisitor visitParameterAnnotation(int index, String descriptor, boolean visible) {
                        return ForInlining.this.annotationRetention.isEnabled() ? super.visitParameterAnnotation(index, descriptor, visible) : IGNORE_ANNOTATION;
                    }

                    @Override
                    public void visitCode() {
                        this.record.applyBody(this.actualMethodVisitor, RedefinitionClassVisitor.this.implementationContext, ForInlining.this.annotationValueFilterFactory);
                        this.actualMethodVisitor.visitEnd();
                        this.mv = this.resolution.isRebased() ? RedefinitionClassVisitor.this.cv.visitMethod(this.resolution.getResolvedMethod().getActualModifiers(), this.resolution.getResolvedMethod().getInternalName(), this.resolution.getResolvedMethod().getDescriptor(), this.resolution.getResolvedMethod().getGenericSignature(), this.resolution.getResolvedMethod().getExceptionTypes().asErasures().toInternalNames()) : IGNORE_METHOD;
                        super.visitCode();
                    }

                    @Override
                    public void visitMaxs(int stackSize, int localVariableLength) {
                        super.visitMaxs(stackSize, Math.max(localVariableLength, this.resolution.getResolvedMethod().getStackSize()));
                    }

                    public String toString() {
                        return "TypeWriter.Default.ForInlining.RedefinitionClassVisitor.CodePreservingMethodVisitor{classVisitor=" + RedefinitionClassVisitor.this + ", actualMethodVisitor=" + this.actualMethodVisitor + ", record=" + this.record + ", resolution=" + this.resolution + '}';
                    }
                }

                protected class AttributeObtainingFieldVisitor
                extends FieldVisitor {
                    private final FieldPool.Record record;

                    protected AttributeObtainingFieldVisitor(FieldVisitor fieldVisitor, FieldPool.Record record) {
                        super(327680, fieldVisitor);
                        this.record = record;
                    }

                    @Override
                    public AnnotationVisitor visitTypeAnnotation(int typeReference, TypePath typePath, String descriptor, boolean visible) {
                        return ForInlining.this.annotationRetention.isEnabled() ? super.visitTypeAnnotation(typeReference, typePath, descriptor, visible) : IGNORE_ANNOTATION;
                    }

                    @Override
                    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                        return ForInlining.this.annotationRetention.isEnabled() ? super.visitAnnotation(descriptor, visible) : IGNORE_ANNOTATION;
                    }

                    @Override
                    public void visitEnd() {
                        this.record.apply(this.fv, ForInlining.this.annotationValueFilterFactory);
                        super.visitEnd();
                    }

                    public String toString() {
                        return "TypeWriter.Default.ForInlining.RedefinitionClassVisitor.AttributeObtainingFieldVisitor{classVisitor=" + RedefinitionClassVisitor.this + ", record=" + this.record + '}';
                    }
                }
            }

            protected static class TypeInitializerDelegate
            extends MethodDescription.InDefinedShape.AbstractBase {
                private static final String TYPE_INITIALIZER_PROXY_PREFIX = "classInitializer";
                private final TypeDescription instrumentedType;
                private final String suffix;

                protected TypeInitializerDelegate(TypeDescription instrumentedType, String suffix) {
                    this.instrumentedType = instrumentedType;
                    this.suffix = suffix;
                }

                @Override
                public TypeDescription getDeclaringType() {
                    return this.instrumentedType;
                }

                @Override
                public ParameterList<ParameterDescription.InDefinedShape> getParameters() {
                    return new ParameterList.Empty<ParameterDescription.InDefinedShape>();
                }

                @Override
                public TypeDescription.Generic getReturnType() {
                    return TypeDescription.Generic.VOID;
                }

                @Override
                public TypeList.Generic getExceptionTypes() {
                    return new TypeList.Generic.Empty();
                }

                @Override
                public AnnotationValue<?, ?> getDefaultValue() {
                    return AnnotationValue.UNDEFINED;
                }

                @Override
                public TypeList.Generic getTypeVariables() {
                    return new TypeList.Generic.Empty();
                }

                @Override
                public AnnotationList getDeclaredAnnotations() {
                    return new AnnotationList.Empty();
                }

                @Override
                public int getModifiers() {
                    return 0x1008 | (this.instrumentedType.isInterface() ? 1 : 2);
                }

                @Override
                public String getInternalName() {
                    return String.format("%s$%s", TYPE_INITIALIZER_PROXY_PREFIX, this.suffix);
                }
            }

            protected static class ContextRegistry {
                private Implementation.Context.ExtractableView implementationContext;

                protected ContextRegistry() {
                }

                public void setImplementationContext(Implementation.Context.ExtractableView implementationContext) {
                    this.implementationContext = implementationContext;
                }

                @SuppressFBWarnings(value={"UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"}, justification="Lazy value definition is intended")
                public List<DynamicType> getAuxiliaryTypes() {
                    return this.implementationContext.getAuxiliaryTypes();
                }

                public String toString() {
                    return "TypeWriter.Default.ForInlining.ContextRegistry{implementationContext=" + this.implementationContext + '}';
                }
            }
        }

        protected static class FrameComputingClassWriter
        extends ClassWriter {
            private final TypePool typePool;

            protected FrameComputingClassWriter(int flags, TypePool typePool) {
                super(flags);
                this.typePool = typePool;
            }

            protected FrameComputingClassWriter(ClassReader classReader, int flags, TypePool typePool) {
                super(classReader, flags);
                this.typePool = typePool;
            }

            @Override
            protected String getCommonSuperClass(String leftTypeName, String rightTypeName) {
                TypeDescription rightType;
                TypeDescription leftType = this.typePool.describe(leftTypeName.replace('/', '.')).resolve();
                if (leftType.isAssignableFrom(rightType = this.typePool.describe(rightTypeName.replace('/', '.')).resolve())) {
                    return leftType.getInternalName();
                }
                if (leftType.isAssignableTo(rightType)) {
                    return rightType.getInternalName();
                }
                if (leftType.isInterface() || rightType.isInterface()) {
                    return TypeDescription.OBJECT.getInternalName();
                }
                while (!(leftType = leftType.getSuperClass().asErasure()).isAssignableFrom(rightType)) {
                }
                return leftType.getInternalName();
            }

            public String toString() {
                return "TypeWriter.Default.FrameComputingClassWriter{typePool=" + this.typePool + '}';
            }
        }

        protected static class ValidatingClassVisitor
        extends ClassVisitor {
            private static final String NO_PARAMETERS = "()";
            private static final String RETURNS_VOID = "V";
            private static final String STRING_DESCRIPTOR = "Ljava/lang/String;";
            private Constraint constraint;

            protected ValidatingClassVisitor(ClassVisitor classVisitor) {
                super(327680, classVisitor);
            }

            protected static ClassVisitor of(ClassVisitor classVisitor, TypeValidation typeValidation) {
                return typeValidation.isEnabled() ? new ValidatingClassVisitor(classVisitor) : classVisitor;
            }

            @Override
            public void visit(int version, int modifiers, String name, String signature, String superName, String[] interfaces) {
                ClassFileVersion classFileVersion = ClassFileVersion.ofMinorMajor(version);
                ArrayList<Constraint> constraints = new ArrayList<Constraint>();
                constraints.add(new Constraint.ForClassFileVersion(classFileVersion));
                if (name.endsWith("/package-info")) {
                    constraints.add(Constraint.ForPackageType.INSTANCE);
                } else if ((modifiers & 0x2000) != 0) {
                    if (!classFileVersion.isAtLeast(ClassFileVersion.JAVA_V5)) {
                        throw new IllegalStateException("Cannot define an annotation type for class file version " + classFileVersion);
                    }
                    constraints.add(classFileVersion.isAtLeast(ClassFileVersion.JAVA_V8) ? Constraint.ForAnnotation.JAVA_8 : Constraint.ForAnnotation.CLASSIC);
                } else if ((modifiers & 0x200) != 0) {
                    constraints.add(classFileVersion.isAtLeast(ClassFileVersion.JAVA_V8) ? Constraint.ForInterface.JAVA_8 : Constraint.ForInterface.CLASSIC);
                } else if ((modifiers & 0x400) != 0) {
                    constraints.add(Constraint.ForClass.ABSTRACT);
                } else {
                    constraints.add(Constraint.ForClass.MANIFEST);
                }
                this.constraint = new Constraint.Compound(constraints);
                this.constraint.assertType(modifiers, interfaces != null, signature != null);
                super.visit(version, modifiers, name, signature, superName, interfaces);
            }

            @Override
            public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                this.constraint.assertAnnotation();
                return super.visitAnnotation(descriptor, visible);
            }

            @Override
            public AnnotationVisitor visitTypeAnnotation(int typeReference, TypePath typePath, String descriptor, boolean visible) {
                this.constraint.assertTypeAnnotation();
                return super.visitTypeAnnotation(typeReference, typePath, descriptor, visible);
            }

            @Override
            public FieldVisitor visitField(int modifiers, String name, String descriptor, String signature, Object defaultValue) {
                if (defaultValue != null) {
                    Class type;
                    switch (descriptor.charAt(0)) {
                        case 'B': 
                        case 'C': 
                        case 'I': 
                        case 'S': 
                        case 'Z': {
                            type = Integer.class;
                            break;
                        }
                        case 'J': {
                            type = Long.class;
                            break;
                        }
                        case 'F': {
                            type = Float.class;
                            break;
                        }
                        case 'D': {
                            type = Double.class;
                            break;
                        }
                        default: {
                            if (!descriptor.equals(STRING_DESCRIPTOR)) {
                                throw new IllegalStateException("Cannot define a default value for type of field " + name);
                            }
                            type = String.class;
                        }
                    }
                    if (!type.isInstance(defaultValue)) {
                        throw new IllegalStateException("Field " + name + " defines an incompatible default value " + defaultValue);
                    }
                    if (type == Integer.class) {
                        int maximum;
                        int minimum;
                        switch (descriptor.charAt(0)) {
                            case 'Z': {
                                minimum = 0;
                                maximum = 1;
                                break;
                            }
                            case 'B': {
                                minimum = -128;
                                maximum = 127;
                                break;
                            }
                            case 'C': {
                                minimum = 0;
                                maximum = 65535;
                                break;
                            }
                            case 'S': {
                                minimum = Short.MIN_VALUE;
                                maximum = Short.MAX_VALUE;
                                break;
                            }
                            default: {
                                minimum = Integer.MIN_VALUE;
                                maximum = Integer.MAX_VALUE;
                            }
                        }
                        int value = (Integer)defaultValue;
                        if (value < minimum || value > maximum) {
                            throw new IllegalStateException("Field " + name + " defines an incompatible default value " + defaultValue);
                        }
                    }
                }
                this.constraint.assertField(name, (modifiers & 1) != 0, (modifiers & 8) != 0, signature != null);
                return new ValidatingFieldVisitor(super.visitField(modifiers, name, descriptor, signature, defaultValue));
            }

            @Override
            public MethodVisitor visitMethod(int modifiers, String name, String descriptor, String signature, String[] exceptions) {
                this.constraint.assertMethod(name, (modifiers & 0x400) != 0, (modifiers & 1) != 0, (modifiers & 2) != 0, (modifiers & 8) != 0, !name.equals("<init>") && !name.equals("<clinit>") && (modifiers & 0xA) == 0, name.equals("<init>"), !descriptor.startsWith(NO_PARAMETERS) || descriptor.endsWith(RETURNS_VOID), signature != null);
                return new ValidatingMethodVisitor(super.visitMethod(modifiers, name, descriptor, signature, exceptions), name);
            }

            public String toString() {
                return "TypeWriter.Default.ValidatingClassVisitor{constraint=" + this.constraint + "}";
            }

            protected class ValidatingMethodVisitor
            extends MethodVisitor {
                private final String name;

                protected ValidatingMethodVisitor(MethodVisitor methodVisitor, String name) {
                    super(327680, methodVisitor);
                    this.name = name;
                }

                @Override
                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    ValidatingClassVisitor.this.constraint.assertAnnotation();
                    return super.visitAnnotation(desc, visible);
                }

                @Override
                public AnnotationVisitor visitAnnotationDefault() {
                    ValidatingClassVisitor.this.constraint.assertDefaultValue(this.name);
                    return super.visitAnnotationDefault();
                }

                @Override
                @SuppressFBWarnings(value={"SF_SWITCH_NO_DEFAULT"}, justification="Fall through to default case is intentional")
                public void visitLdcInsn(Object constant) {
                    if (constant instanceof Type) {
                        Type type = (Type)constant;
                        switch (type.getSort()) {
                            case 9: 
                            case 10: {
                                ValidatingClassVisitor.this.constraint.assertTypeInConstantPool();
                                break;
                            }
                            case 11: {
                                ValidatingClassVisitor.this.constraint.assertMethodTypeInConstantPool();
                            }
                        }
                    } else if (constant instanceof Handle) {
                        ValidatingClassVisitor.this.constraint.assertHandleInConstantPool();
                    }
                    super.visitLdcInsn(constant);
                }

                @Override
                public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
                    if (isInterface && opcode == 183) {
                        ValidatingClassVisitor.this.constraint.assertDefaultMethodCall();
                    }
                    super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
                }

                @Override
                public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethod, Object ... bootstrapArgument) {
                    ValidatingClassVisitor.this.constraint.assertInvokeDynamic();
                    super.visitInvokeDynamicInsn(name, descriptor, bootstrapMethod, bootstrapArgument);
                }

                @Override
                public void visitJumpInsn(int opcode, Label label) {
                    if (opcode == 168) {
                        ValidatingClassVisitor.this.constraint.assertSubRoutine();
                    }
                    super.visitJumpInsn(opcode, label);
                }

                public String toString() {
                    return "TypeWriter.Default.ValidatingClassVisitor.ValidatingMethodVisitor{classVisitor=" + ValidatingClassVisitor.this + ", name='" + this.name + '\'' + '}';
                }
            }

            protected class ValidatingFieldVisitor
            extends FieldVisitor {
                protected ValidatingFieldVisitor(FieldVisitor fieldVisitor) {
                    super(327680, fieldVisitor);
                }

                @Override
                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    ValidatingClassVisitor.this.constraint.assertAnnotation();
                    return super.visitAnnotation(desc, visible);
                }

                public String toString() {
                    return "TypeWriter.Default.ValidatingClassVisitor.ValidatingFieldVisitor{classVisitor=" + ValidatingClassVisitor.this + '}';
                }
            }

            protected static interface Constraint {
                public void assertType(int var1, boolean var2, boolean var3);

                public void assertField(String var1, boolean var2, boolean var3, boolean var4);

                public void assertMethod(String var1, boolean var2, boolean var3, boolean var4, boolean var5, boolean var6, boolean var7, boolean var8, boolean var9);

                public void assertAnnotation();

                public void assertTypeAnnotation();

                public void assertDefaultValue(String var1);

                public void assertDefaultMethodCall();

                public void assertTypeInConstantPool();

                public void assertMethodTypeInConstantPool();

                public void assertHandleInConstantPool();

                public void assertInvokeDynamic();

                public void assertSubRoutine();

                public static class Compound
                implements Constraint {
                    private final List<? extends Constraint> constraints;

                    public Compound(List<? extends Constraint> constraints) {
                        this.constraints = constraints;
                    }

                    @Override
                    public void assertType(int modifier, boolean definesInterfaces, boolean isGeneric) {
                        for (Constraint constraint : this.constraints) {
                            constraint.assertType(modifier, definesInterfaces, isGeneric);
                        }
                    }

                    @Override
                    public void assertField(String name, boolean isPublic, boolean isStatic, boolean isGeneric) {
                        for (Constraint constraint : this.constraints) {
                            constraint.assertField(name, isPublic, isStatic, isGeneric);
                        }
                    }

                    @Override
                    public void assertMethod(String name, boolean isAbstract, boolean isPublic, boolean isPrivate, boolean isStatic, boolean isVirtual, boolean isConstructor, boolean isDefaultValueIncompatible, boolean isGeneric) {
                        for (Constraint constraint : this.constraints) {
                            constraint.assertMethod(name, isAbstract, isPublic, isPrivate, isStatic, isVirtual, isConstructor, isDefaultValueIncompatible, isGeneric);
                        }
                    }

                    @Override
                    public void assertDefaultValue(String name) {
                        for (Constraint constraint : this.constraints) {
                            constraint.assertDefaultValue(name);
                        }
                    }

                    @Override
                    public void assertDefaultMethodCall() {
                        for (Constraint constraint : this.constraints) {
                            constraint.assertDefaultMethodCall();
                        }
                    }

                    @Override
                    public void assertAnnotation() {
                        for (Constraint constraint : this.constraints) {
                            constraint.assertAnnotation();
                        }
                    }

                    @Override
                    public void assertTypeAnnotation() {
                        for (Constraint constraint : this.constraints) {
                            constraint.assertTypeAnnotation();
                        }
                    }

                    @Override
                    public void assertTypeInConstantPool() {
                        for (Constraint constraint : this.constraints) {
                            constraint.assertTypeInConstantPool();
                        }
                    }

                    @Override
                    public void assertMethodTypeInConstantPool() {
                        for (Constraint constraint : this.constraints) {
                            constraint.assertMethodTypeInConstantPool();
                        }
                    }

                    @Override
                    public void assertHandleInConstantPool() {
                        for (Constraint constraint : this.constraints) {
                            constraint.assertHandleInConstantPool();
                        }
                    }

                    @Override
                    public void assertInvokeDynamic() {
                        for (Constraint constraint : this.constraints) {
                            constraint.assertInvokeDynamic();
                        }
                    }

                    @Override
                    public void assertSubRoutine() {
                        for (Constraint constraint : this.constraints) {
                            constraint.assertSubRoutine();
                        }
                    }

                    public boolean equals(Object other) {
                        return this == other || other != null && this.getClass() == other.getClass() && this.constraints.equals(((Compound)other).constraints);
                    }

                    public int hashCode() {
                        return this.constraints.hashCode();
                    }

                    public String toString() {
                        return "TypeWriter.Default.ValidatingClassVisitor.Constraint.Compound{constraints=" + this.constraints + '}';
                    }
                }

                public static class ForClassFileVersion
                implements Constraint {
                    private final ClassFileVersion classFileVersion;

                    public ForClassFileVersion(ClassFileVersion classFileVersion) {
                        this.classFileVersion = classFileVersion;
                    }

                    @Override
                    public void assertType(int modifiers, boolean definesInterfaces, boolean isGeneric) {
                        if ((modifiers & 0x2000) != 0 && !this.classFileVersion.isAtLeast(ClassFileVersion.JAVA_V5)) {
                            throw new IllegalStateException("Cannot define annotation type for class file version " + this.classFileVersion);
                        }
                        if (isGeneric && !this.classFileVersion.isAtLeast(ClassFileVersion.JAVA_V5)) {
                            throw new IllegalStateException("Cannot define a generic type for class file version " + this.classFileVersion);
                        }
                    }

                    @Override
                    public void assertField(String name, boolean isPublic, boolean isStatic, boolean isGeneric) {
                        if (isGeneric && !this.classFileVersion.isAtLeast(ClassFileVersion.JAVA_V5)) {
                            throw new IllegalStateException("Cannot define generic field '" + name + "' for class file version " + this.classFileVersion);
                        }
                    }

                    @Override
                    public void assertMethod(String name, boolean isAbstract, boolean isPublic, boolean isPrivate, boolean isStatic, boolean isVirtual, boolean isConstructor, boolean isDefaultValueIncompatible, boolean isGeneric) {
                        if (isGeneric && !this.classFileVersion.isAtLeast(ClassFileVersion.JAVA_V5)) {
                            throw new IllegalStateException("Cannot define generic method '" + name + "' for class file version " + this.classFileVersion);
                        }
                        if (!isVirtual && isAbstract) {
                            throw new IllegalStateException("Cannot define static or non-virtual method '" + name + "' to be abstract");
                        }
                    }

                    @Override
                    public void assertAnnotation() {
                        if (!this.classFileVersion.isAtLeast(ClassFileVersion.JAVA_V5)) {
                            throw new IllegalStateException("Cannot write annotations for class file version " + this.classFileVersion);
                        }
                    }

                    @Override
                    public void assertTypeAnnotation() {
                        if (!this.classFileVersion.isAtLeast(ClassFileVersion.JAVA_V5)) {
                            throw new IllegalStateException("Cannot write type annotations for class file version " + this.classFileVersion);
                        }
                    }

                    @Override
                    public void assertDefaultValue(String name) {
                    }

                    @Override
                    public void assertDefaultMethodCall() {
                        if (this.classFileVersion.isLessThan(ClassFileVersion.JAVA_V8)) {
                            throw new IllegalStateException("Cannot invoke default method for class file version " + this.classFileVersion);
                        }
                    }

                    @Override
                    public void assertTypeInConstantPool() {
                        if (!this.classFileVersion.isAtLeast(ClassFileVersion.JAVA_V5)) {
                            throw new IllegalStateException("Cannot write type to constant pool for class file version " + this.classFileVersion);
                        }
                    }

                    @Override
                    public void assertMethodTypeInConstantPool() {
                        if (!this.classFileVersion.isAtLeast(ClassFileVersion.JAVA_V7)) {
                            throw new IllegalStateException("Cannot write method type to constant pool for class file version " + this.classFileVersion);
                        }
                    }

                    @Override
                    public void assertHandleInConstantPool() {
                        if (!this.classFileVersion.isAtLeast(ClassFileVersion.JAVA_V7)) {
                            throw new IllegalStateException("Cannot write method handle to constant pool for class file version " + this.classFileVersion);
                        }
                    }

                    @Override
                    public void assertInvokeDynamic() {
                        if (!this.classFileVersion.isAtLeast(ClassFileVersion.JAVA_V7)) {
                            throw new IllegalStateException("Cannot write invoke dynamic instruction for class file version " + this.classFileVersion);
                        }
                    }

                    @Override
                    public void assertSubRoutine() {
                        if (!this.classFileVersion.isLessThan(ClassFileVersion.JAVA_V6)) {
                            throw new IllegalStateException("Cannot write subroutine for class file version " + this.classFileVersion);
                        }
                    }

                    public boolean equals(Object other) {
                        return this == other || other != null && this.getClass() == other.getClass() && this.classFileVersion.equals(((ForClassFileVersion)other).classFileVersion);
                    }

                    public int hashCode() {
                        return this.classFileVersion.hashCode();
                    }

                    public String toString() {
                        return "TypeWriter.Default.ValidatingClassVisitor.Constraint.ForClassFileVersion{classFileVersion=" + this.classFileVersion + '}';
                    }
                }

                public static enum ForAnnotation implements Constraint
                {
                    CLASSIC(true),
                    JAVA_8(false);

                    private final boolean classic;

                    private ForAnnotation(boolean classic) {
                        this.classic = classic;
                    }

                    @Override
                    public void assertField(String name, boolean isPublic, boolean isStatic, boolean isGeneric) {
                        if (!isStatic || !isPublic) {
                            throw new IllegalStateException("Cannot define non-static or non-public field '" + name + "' for annotation type");
                        }
                    }

                    @Override
                    public void assertMethod(String name, boolean isAbstract, boolean isPublic, boolean isPrivate, boolean isStatic, boolean isVirtual, boolean isConstructor, boolean isDefaultValueIncompatible, boolean isGeneric) {
                        if (!name.equals("<clinit>")) {
                            if (isConstructor) {
                                throw new IllegalStateException("Cannot define constructor for interface type");
                            }
                            if (this.classic && !isVirtual) {
                                throw new IllegalStateException("Cannot define non-virtual method '" + name + "' for a pre-Java 8 annotation type");
                            }
                            if (!isStatic && isDefaultValueIncompatible) {
                                throw new IllegalStateException("Cannot define method '" + name + "' with the given signature as an annotation type method");
                            }
                        }
                    }

                    @Override
                    public void assertAnnotation() {
                    }

                    @Override
                    public void assertTypeAnnotation() {
                    }

                    @Override
                    public void assertDefaultValue(String name) {
                    }

                    @Override
                    public void assertDefaultMethodCall() {
                    }

                    @Override
                    public void assertType(int modifier, boolean definesInterfaces, boolean isGeneric) {
                        if ((modifier & 0x200) == 0) {
                            throw new IllegalStateException("Cannot define annotation type without interface modifier");
                        }
                    }

                    @Override
                    public void assertTypeInConstantPool() {
                    }

                    @Override
                    public void assertMethodTypeInConstantPool() {
                    }

                    @Override
                    public void assertHandleInConstantPool() {
                    }

                    @Override
                    public void assertInvokeDynamic() {
                    }

                    @Override
                    public void assertSubRoutine() {
                    }

                    public String toString() {
                        return "TypeWriter.Default.ValidatingClassVisitor.Constraint.ForAnnotation." + this.name();
                    }
                }

                public static enum ForInterface implements Constraint
                {
                    CLASSIC(true),
                    JAVA_8(false);

                    private final boolean classic;

                    private ForInterface(boolean classic) {
                        this.classic = classic;
                    }

                    @Override
                    public void assertField(String name, boolean isPublic, boolean isStatic, boolean isGeneric) {
                        if (!isStatic || !isPublic) {
                            throw new IllegalStateException("Cannot define non-static or non-public field '" + name + "' for interface type");
                        }
                    }

                    @Override
                    public void assertMethod(String name, boolean isAbstract, boolean isPublic, boolean isPrivate, boolean isStatic, boolean isVirtual, boolean isConstructor, boolean isDefaultValueIncompatible, boolean isGeneric) {
                        if (!name.equals("<clinit>")) {
                            if (isConstructor) {
                                throw new IllegalStateException("Cannot define constructor for interface type");
                            }
                            if (this.classic && !isPublic) {
                                throw new IllegalStateException("Cannot define non-public method '" + name + "' for interface type");
                            }
                            if (this.classic && !isVirtual) {
                                throw new IllegalStateException("Cannot define non-virtual method '" + name + "' for a pre-Java 8 interface type");
                            }
                            if (this.classic && !isAbstract) {
                                throw new IllegalStateException("Cannot define default method '" + name + "' for pre-Java 8 interface type");
                            }
                        }
                    }

                    @Override
                    public void assertAnnotation() {
                    }

                    @Override
                    public void assertTypeAnnotation() {
                    }

                    @Override
                    public void assertDefaultValue(String name) {
                        throw new IllegalStateException("Cannot define default value for '" + name + "' for non-annotation type");
                    }

                    @Override
                    public void assertDefaultMethodCall() {
                    }

                    @Override
                    public void assertType(int modifier, boolean definesInterfaces, boolean isGeneric) {
                    }

                    @Override
                    public void assertTypeInConstantPool() {
                    }

                    @Override
                    public void assertMethodTypeInConstantPool() {
                    }

                    @Override
                    public void assertHandleInConstantPool() {
                    }

                    @Override
                    public void assertInvokeDynamic() {
                    }

                    @Override
                    public void assertSubRoutine() {
                    }

                    public String toString() {
                        return "TypeWriter.Default.ValidatingClassVisitor.Constraint.ForInterface." + this.name();
                    }
                }

                public static enum ForPackageType implements Constraint
                {
                    INSTANCE;


                    @Override
                    public void assertField(String name, boolean isPublic, boolean isStatic, boolean isGeneric) {
                        throw new IllegalStateException("Cannot define a field for a package description type");
                    }

                    @Override
                    public void assertMethod(String name, boolean isAbstract, boolean isPublic, boolean isPrivate, boolean isStatic, boolean isVirtual, boolean isConstructor, boolean isNoDefaultValue, boolean isGeneric) {
                        throw new IllegalStateException("Cannot define a method for a package description type");
                    }

                    @Override
                    public void assertAnnotation() {
                    }

                    @Override
                    public void assertTypeAnnotation() {
                    }

                    @Override
                    public void assertDefaultValue(String name) {
                    }

                    @Override
                    public void assertDefaultMethodCall() {
                    }

                    @Override
                    public void assertTypeInConstantPool() {
                    }

                    @Override
                    public void assertMethodTypeInConstantPool() {
                    }

                    @Override
                    public void assertHandleInConstantPool() {
                    }

                    @Override
                    public void assertInvokeDynamic() {
                    }

                    @Override
                    public void assertSubRoutine() {
                    }

                    @Override
                    public void assertType(int modifier, boolean definesInterfaces, boolean isGeneric) {
                        if (modifier != 5632) {
                            throw new IllegalStateException("A package description type must define 5632 as modifier");
                        }
                        if (definesInterfaces) {
                            throw new IllegalStateException("Cannot implement interface for package type");
                        }
                    }

                    public String toString() {
                        return "TypeWriter.Default.ValidatingClassVisitor.Constraint.ForPackageType." + this.name();
                    }
                }

                public static enum ForClass implements Constraint
                {
                    MANIFEST(true),
                    ABSTRACT(false);

                    private final boolean manifestType;

                    private ForClass(boolean manifestType) {
                        this.manifestType = manifestType;
                    }

                    @Override
                    public void assertType(int modifier, boolean definesInterfaces, boolean isGeneric) {
                    }

                    @Override
                    public void assertField(String name, boolean isPublic, boolean isStatic, boolean isGeneric) {
                    }

                    @Override
                    public void assertMethod(String name, boolean isAbstract, boolean isPublic, boolean isPrivate, boolean isStatic, boolean isVirtual, boolean isConstructor, boolean isDefaultValueIncompatible, boolean isGeneric) {
                        if (isAbstract && this.manifestType) {
                            throw new IllegalStateException("Cannot define abstract method '" + name + "' for non-abstract class");
                        }
                    }

                    @Override
                    public void assertAnnotation() {
                    }

                    @Override
                    public void assertTypeAnnotation() {
                    }

                    @Override
                    public void assertDefaultValue(String name) {
                        throw new IllegalStateException("Cannot define default value for '" + name + "' for non-annotation type");
                    }

                    @Override
                    public void assertDefaultMethodCall() {
                    }

                    @Override
                    public void assertTypeInConstantPool() {
                    }

                    @Override
                    public void assertMethodTypeInConstantPool() {
                    }

                    @Override
                    public void assertHandleInConstantPool() {
                    }

                    @Override
                    public void assertInvokeDynamic() {
                    }

                    @Override
                    public void assertSubRoutine() {
                    }

                    public String toString() {
                        return "TypeWriter.Default.ValidatingClassVisitor.Constraint.ForClass." + this.name();
                    }
                }
            }
        }

        protected class UnresolvedType {
            private final byte[] binaryRepresentation;
            private final List<? extends DynamicType> auxiliaryTypes;

            protected UnresolvedType(byte[] binaryRepresentation, List<? extends DynamicType> auxiliaryTypes) {
                this.binaryRepresentation = binaryRepresentation;
                this.auxiliaryTypes = auxiliaryTypes;
            }

            protected DynamicType.Unloaded<S> toDynamicType(TypeResolutionStrategy.Resolved typeResolutionStrategy) {
                return new DynamicType.Default.Unloaded(Default.this.instrumentedType, this.binaryRepresentation, Default.this.loadedTypeInitializer, CompoundList.of(Default.this.auxiliaryTypes, this.auxiliaryTypes), typeResolutionStrategy);
            }

            protected byte[] getBinaryRepresentation() {
                return this.binaryRepresentation;
            }

            private Default getOuter() {
                return Default.this;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                UnresolvedType that = (UnresolvedType)object;
                return Arrays.equals(this.binaryRepresentation, that.binaryRepresentation) && Default.this.equals(that.getOuter()) && this.auxiliaryTypes.equals(that.auxiliaryTypes);
            }

            public int hashCode() {
                int result = Arrays.hashCode(this.binaryRepresentation);
                result = 31 * result + this.auxiliaryTypes.hashCode();
                result = 31 * result + Default.this.hashCode();
                return result;
            }

            public String toString() {
                return "TypeWriter.Default.UnresolvedType{outer=" + Default.this + ", binaryRepresentation=<" + this.binaryRepresentation.length + " bytes>, auxiliaryTypes=" + this.auxiliaryTypes + '}';
            }
        }
    }

    public static interface MethodPool {
        public Record target(MethodDescription var1);

        public static interface Record {
            public Sort getSort();

            public MethodDescription getMethod();

            public Record prepend(ByteCodeAppender var1);

            public void apply(ClassVisitor var1, Implementation.Context var2, AnnotationValueFilter.Factory var3);

            public void applyHead(MethodVisitor var1);

            public void applyBody(MethodVisitor var1, Implementation.Context var2, AnnotationValueFilter.Factory var3);

            public static class AccessBridgeWrapper
            implements Record {
                private final Record delegate;
                private final TypeDescription instrumentedType;
                private final MethodDescription bridgeTarget;
                private final Set<MethodDescription.TypeToken> bridgeTypes;
                private final MethodAttributeAppender attributeAppender;

                protected AccessBridgeWrapper(Record delegate, TypeDescription instrumentedType, MethodDescription bridgeTarget, Set<MethodDescription.TypeToken> bridgeTypes, MethodAttributeAppender attributeAppender) {
                    this.delegate = delegate;
                    this.instrumentedType = instrumentedType;
                    this.bridgeTarget = bridgeTarget;
                    this.bridgeTypes = bridgeTypes;
                    this.attributeAppender = attributeAppender;
                }

                public static Record of(Record delegate, TypeDescription instrumentedType, MethodDescription bridgeTarget, Set<MethodDescription.TypeToken> bridgeTypes, MethodAttributeAppender attributeAppender) {
                    return bridgeTypes.isEmpty() || instrumentedType.isInterface() && !delegate.getSort().isImplemented() ? delegate : new AccessBridgeWrapper(delegate, instrumentedType, bridgeTarget, bridgeTypes, attributeAppender);
                }

                @Override
                public Sort getSort() {
                    return this.delegate.getSort();
                }

                @Override
                public MethodDescription getMethod() {
                    return this.bridgeTarget;
                }

                @Override
                public Record prepend(ByteCodeAppender byteCodeAppender) {
                    return new AccessBridgeWrapper(this.delegate.prepend(byteCodeAppender), this.instrumentedType, this.bridgeTarget, this.bridgeTypes, this.attributeAppender);
                }

                @Override
                public void apply(ClassVisitor classVisitor, Implementation.Context implementationContext, AnnotationValueFilter.Factory annotationValueFilterFactory) {
                    this.delegate.apply(classVisitor, implementationContext, annotationValueFilterFactory);
                    for (MethodDescription.TypeToken bridgeType : this.bridgeTypes) {
                        AccessorBridge bridgeMethod = new AccessorBridge(this.bridgeTarget, bridgeType, this.instrumentedType);
                        BridgeTarget bridgeTarget = new BridgeTarget(this.bridgeTarget, this.instrumentedType);
                        MethodVisitor methodVisitor = classVisitor.visitMethod(bridgeMethod.getActualModifiers(true), bridgeMethod.getInternalName(), bridgeMethod.getDescriptor(), MethodDescription.NON_GENERIC_SIGNATURE, bridgeMethod.getExceptionTypes().asErasures().toInternalNames());
                        this.attributeAppender.apply(methodVisitor, bridgeMethod, annotationValueFilterFactory.on(this.instrumentedType));
                        methodVisitor.visitCode();
                        ByteCodeAppender.Size size = new ByteCodeAppender.Simple(MethodVariableAccess.allArgumentsOf(bridgeMethod).asBridgeOf(bridgeTarget).prependThisReference(), MethodInvocation.invoke(bridgeTarget).virtual(this.instrumentedType), bridgeTarget.getReturnType().asErasure().isAssignableTo(bridgeMethod.getReturnType().asErasure()) ? StackManipulation.Trivial.INSTANCE : TypeCasting.to(bridgeMethod.getReturnType().asErasure()), MethodReturn.returning(bridgeMethod.getReturnType().asErasure())).apply(methodVisitor, implementationContext, bridgeMethod);
                        methodVisitor.visitMaxs(size.getOperandStackSize(), size.getLocalVariableSize());
                        methodVisitor.visitEnd();
                    }
                }

                @Override
                public void applyHead(MethodVisitor methodVisitor) {
                    this.delegate.applyHead(methodVisitor);
                }

                @Override
                public void applyBody(MethodVisitor methodVisitor, Implementation.Context implementationContext, AnnotationValueFilter.Factory annotationValueFilterFactory) {
                    this.delegate.applyBody(methodVisitor, implementationContext, annotationValueFilterFactory);
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    AccessBridgeWrapper that = (AccessBridgeWrapper)other;
                    return this.delegate.equals(that.delegate) && this.instrumentedType.equals(that.instrumentedType) && this.bridgeTarget.equals(that.bridgeTarget) && this.bridgeTypes.equals(that.bridgeTypes) && this.attributeAppender.equals(that.attributeAppender);
                }

                public int hashCode() {
                    int result = this.delegate.hashCode();
                    result = 31 * result + this.instrumentedType.hashCode();
                    result = 31 * result + this.bridgeTarget.hashCode();
                    result = 31 * result + this.bridgeTypes.hashCode();
                    result = 31 * result + this.attributeAppender.hashCode();
                    return result;
                }

                public String toString() {
                    return "TypeWriter.MethodPool.Record.AccessBridgeWrapper{delegate=" + this.delegate + ", instrumentedType=" + this.instrumentedType + ", bridgeTarget=" + this.bridgeTarget + ", bridgeTypes=" + this.bridgeTypes + ", attributeAppender=" + this.attributeAppender + '}';
                }

                protected static class BridgeTarget
                extends MethodDescription.InDefinedShape.AbstractBase {
                    private final MethodDescription bridgeTarget;
                    private final TypeDescription instrumentedType;

                    protected BridgeTarget(MethodDescription bridgeTarget, TypeDescription instrumentedType) {
                        this.bridgeTarget = bridgeTarget;
                        this.instrumentedType = instrumentedType;
                    }

                    @Override
                    public TypeDescription getDeclaringType() {
                        return this.instrumentedType;
                    }

                    @Override
                    public ParameterList<ParameterDescription.InDefinedShape> getParameters() {
                        return new ParameterList.ForTokens(this, this.bridgeTarget.getParameters().asTokenList(ElementMatchers.is(this.instrumentedType)));
                    }

                    @Override
                    public TypeDescription.Generic getReturnType() {
                        return this.bridgeTarget.getReturnType();
                    }

                    @Override
                    public TypeList.Generic getExceptionTypes() {
                        return this.bridgeTarget.getExceptionTypes();
                    }

                    @Override
                    public AnnotationValue<?, ?> getDefaultValue() {
                        return this.bridgeTarget.getDefaultValue();
                    }

                    @Override
                    public TypeList.Generic getTypeVariables() {
                        return this.bridgeTarget.getTypeVariables();
                    }

                    @Override
                    public AnnotationList getDeclaredAnnotations() {
                        return this.bridgeTarget.getDeclaredAnnotations();
                    }

                    @Override
                    public int getModifiers() {
                        return this.bridgeTarget.getModifiers();
                    }

                    @Override
                    public String getInternalName() {
                        return this.bridgeTarget.getInternalName();
                    }
                }

                protected static class AccessorBridge
                extends MethodDescription.InDefinedShape.AbstractBase {
                    private final MethodDescription bridgeTarget;
                    private final MethodDescription.TypeToken bridgeType;
                    private final TypeDescription instrumentedType;

                    protected AccessorBridge(MethodDescription bridgeTarget, MethodDescription.TypeToken bridgeType, TypeDescription instrumentedType) {
                        this.bridgeTarget = bridgeTarget;
                        this.bridgeType = bridgeType;
                        this.instrumentedType = instrumentedType;
                    }

                    @Override
                    public TypeDescription getDeclaringType() {
                        return this.instrumentedType;
                    }

                    @Override
                    public ParameterList<ParameterDescription.InDefinedShape> getParameters() {
                        return new ParameterList.Explicit.ForTypes((MethodDescription.InDefinedShape)this, this.bridgeType.getParameterTypes());
                    }

                    @Override
                    public TypeDescription.Generic getReturnType() {
                        return this.bridgeType.getReturnType().asGenericType();
                    }

                    @Override
                    public TypeList.Generic getExceptionTypes() {
                        return this.bridgeTarget.getExceptionTypes().accept(TypeDescription.Generic.Visitor.TypeErasing.INSTANCE);
                    }

                    @Override
                    public AnnotationValue<?, ?> getDefaultValue() {
                        return AnnotationValue.UNDEFINED;
                    }

                    @Override
                    public TypeList.Generic getTypeVariables() {
                        return new TypeList.Generic.Empty();
                    }

                    @Override
                    public AnnotationList getDeclaredAnnotations() {
                        return new AnnotationList.Empty();
                    }

                    @Override
                    public int getModifiers() {
                        return (this.bridgeTarget.getModifiers() | 0x40 | 0x1000) & 0xFFFFFAFF;
                    }

                    @Override
                    public String getInternalName() {
                        return this.bridgeTarget.getInternalName();
                    }
                }
            }

            public static abstract class ForDefinedMethod
            implements Record {
                @Override
                public void apply(ClassVisitor classVisitor, Implementation.Context implementationContext, AnnotationValueFilter.Factory annotationValueFilterFactory) {
                    MethodVisitor methodVisitor = classVisitor.visitMethod(this.getMethod().getActualModifiers(this.getSort().isImplemented()), this.getMethod().getInternalName(), this.getMethod().getDescriptor(), this.getMethod().getGenericSignature(), this.getMethod().getExceptionTypes().asErasures().toInternalNames());
                    ParameterList<?> parameterList = this.getMethod().getParameters();
                    if (parameterList.hasExplicitMetaData()) {
                        for (ParameterDescription parameterDescription : parameterList) {
                            methodVisitor.visitParameter(parameterDescription.getName(), parameterDescription.getModifiers());
                        }
                    }
                    this.applyHead(methodVisitor);
                    this.applyBody(methodVisitor, implementationContext, annotationValueFilterFactory);
                    methodVisitor.visitEnd();
                }

                public static class OfVisibilityBridge
                extends ForDefinedMethod
                implements ByteCodeAppender {
                    private final MethodDescription visibilityBridge;
                    private final MethodDescription bridgeTarget;
                    private final TypeDescription superClass;
                    private final MethodAttributeAppender attributeAppender;

                    protected OfVisibilityBridge(MethodDescription visibilityBridge, MethodDescription bridgeTarget, TypeDescription superClass, MethodAttributeAppender attributeAppender) {
                        this.visibilityBridge = visibilityBridge;
                        this.bridgeTarget = bridgeTarget;
                        this.superClass = superClass;
                        this.attributeAppender = attributeAppender;
                    }

                    public static Record of(TypeDescription instrumentedType, MethodDescription bridgeTarget, MethodAttributeAppender attributeAppender) {
                        return new OfVisibilityBridge(new VisibilityBridge(instrumentedType, bridgeTarget), bridgeTarget, instrumentedType.getSuperClass().asErasure(), attributeAppender);
                    }

                    @Override
                    public MethodDescription getMethod() {
                        return this.visibilityBridge;
                    }

                    @Override
                    public Sort getSort() {
                        return Sort.IMPLEMENTED;
                    }

                    @Override
                    public Record prepend(ByteCodeAppender byteCodeAppender) {
                        return new WithBody(this.visibilityBridge, new ByteCodeAppender.Compound(this, byteCodeAppender), this.attributeAppender);
                    }

                    @Override
                    public void applyHead(MethodVisitor methodVisitor) {
                    }

                    @Override
                    public void applyBody(MethodVisitor methodVisitor, Implementation.Context implementationContext, AnnotationValueFilter.Factory annotationValueFilterFactory) {
                        this.attributeAppender.apply(methodVisitor, this.visibilityBridge, annotationValueFilterFactory.on(this.visibilityBridge));
                        methodVisitor.visitCode();
                        ByteCodeAppender.Size size = this.apply(methodVisitor, implementationContext, this.visibilityBridge);
                        methodVisitor.visitMaxs(size.getOperandStackSize(), size.getLocalVariableSize());
                    }

                    @Override
                    public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                        return new ByteCodeAppender.Simple(MethodVariableAccess.allArgumentsOf(instrumentedMethod).prependThisReference(), MethodInvocation.invoke(this.bridgeTarget).special(this.superClass), MethodReturn.returning(instrumentedMethod.getReturnType().asErasure())).apply(methodVisitor, implementationContext, instrumentedMethod);
                    }

                    public boolean equals(Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (other == null || this.getClass() != other.getClass()) {
                            return false;
                        }
                        OfVisibilityBridge that = (OfVisibilityBridge)other;
                        return this.visibilityBridge.equals(that.visibilityBridge) && this.bridgeTarget.equals(that.bridgeTarget) && this.superClass.equals(that.superClass) && this.attributeAppender.equals(that.attributeAppender);
                    }

                    public int hashCode() {
                        int result = this.visibilityBridge.hashCode();
                        result = 31 * result + this.bridgeTarget.hashCode();
                        result = 31 * result + this.superClass.hashCode();
                        result = 31 * result + this.attributeAppender.hashCode();
                        return result;
                    }

                    public String toString() {
                        return "TypeWriter.MethodPool.Record.ForDefinedMethod.OfVisibilityBridge{visibilityBridge=" + this.visibilityBridge + ", bridgeTarget=" + this.bridgeTarget + ", superClass=" + this.superClass + ", attributeAppender=" + this.attributeAppender + '}';
                    }

                    protected static class VisibilityBridge
                    extends MethodDescription.InDefinedShape.AbstractBase {
                        private final TypeDescription instrumentedType;
                        private final MethodDescription bridgeTarget;

                        protected VisibilityBridge(TypeDescription instrumentedType, MethodDescription bridgeTarget) {
                            this.instrumentedType = instrumentedType;
                            this.bridgeTarget = bridgeTarget;
                        }

                        @Override
                        public TypeDescription getDeclaringType() {
                            return this.instrumentedType;
                        }

                        @Override
                        public ParameterList<ParameterDescription.InDefinedShape> getParameters() {
                            return new ParameterList.Explicit.ForTypes((MethodDescription.InDefinedShape)this, this.bridgeTarget.getParameters().asTypeList().asRawTypes());
                        }

                        @Override
                        public TypeDescription.Generic getReturnType() {
                            return this.bridgeTarget.getReturnType().asRawType();
                        }

                        @Override
                        public TypeList.Generic getExceptionTypes() {
                            return this.bridgeTarget.getExceptionTypes().asRawTypes();
                        }

                        @Override
                        public AnnotationValue<?, ?> getDefaultValue() {
                            return AnnotationValue.UNDEFINED;
                        }

                        @Override
                        public TypeList.Generic getTypeVariables() {
                            return new TypeList.Generic.Empty();
                        }

                        @Override
                        public AnnotationList getDeclaredAnnotations() {
                            return this.bridgeTarget.getDeclaredAnnotations();
                        }

                        @Override
                        public int getModifiers() {
                            return (this.bridgeTarget.getModifiers() | 0x1000 | 0x40) & 0xFFFFFEFF;
                        }

                        @Override
                        public String getInternalName() {
                            return this.bridgeTarget.getName();
                        }
                    }
                }

                public static class WithAnnotationDefaultValue
                extends ForDefinedMethod {
                    private final MethodDescription methodDescription;
                    private final AnnotationValue<?, ?> annotationValue;
                    private final MethodAttributeAppender methodAttributeAppender;

                    public WithAnnotationDefaultValue(MethodDescription methodDescription, AnnotationValue<?, ?> annotationValue, MethodAttributeAppender methodAttributeAppender) {
                        this.methodDescription = methodDescription;
                        this.annotationValue = annotationValue;
                        this.methodAttributeAppender = methodAttributeAppender;
                    }

                    @Override
                    public MethodDescription getMethod() {
                        return this.methodDescription;
                    }

                    @Override
                    public Sort getSort() {
                        return Sort.DEFINED;
                    }

                    @Override
                    public void applyHead(MethodVisitor methodVisitor) {
                        if (!this.methodDescription.isDefaultValue(this.annotationValue)) {
                            throw new IllegalStateException("Cannot set " + this.annotationValue + " as default for " + this.methodDescription);
                        }
                        AnnotationVisitor annotationVisitor = methodVisitor.visitAnnotationDefault();
                        AnnotationAppender.Default.apply(annotationVisitor, this.methodDescription.getReturnType().asErasure(), AnnotationAppender.NO_NAME, this.annotationValue.resolve());
                        annotationVisitor.visitEnd();
                    }

                    @Override
                    public void applyBody(MethodVisitor methodVisitor, Implementation.Context implementationContext, AnnotationValueFilter.Factory annotationValueFilterFactory) {
                        this.methodAttributeAppender.apply(methodVisitor, this.methodDescription, annotationValueFilterFactory.on(this.methodDescription));
                    }

                    @Override
                    public Record prepend(ByteCodeAppender byteCodeAppender) {
                        throw new IllegalStateException("Cannot prepend code to method that defines a default annotation value");
                    }

                    public boolean equals(Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (other == null || this.getClass() != other.getClass()) {
                            return false;
                        }
                        WithAnnotationDefaultValue that = (WithAnnotationDefaultValue)other;
                        return this.methodDescription.equals(that.methodDescription) && this.annotationValue.equals(that.annotationValue) && this.methodAttributeAppender.equals(that.methodAttributeAppender);
                    }

                    public int hashCode() {
                        int result = this.methodDescription.hashCode();
                        result = 31 * result + this.annotationValue.hashCode();
                        result = 31 * result + this.methodAttributeAppender.hashCode();
                        return result;
                    }

                    public String toString() {
                        return "TypeWriter.MethodPool.Record.ForDefinedMethod.WithAnnotationDefaultValue{methodDescription=" + this.methodDescription + ", annotationValue=" + this.annotationValue + ", methodAttributeAppender=" + this.methodAttributeAppender + '}';
                    }
                }

                public static class WithoutBody
                extends ForDefinedMethod {
                    private final MethodDescription methodDescription;
                    private final MethodAttributeAppender methodAttributeAppender;

                    public WithoutBody(MethodDescription methodDescription, MethodAttributeAppender methodAttributeAppender) {
                        this.methodDescription = methodDescription;
                        this.methodAttributeAppender = methodAttributeAppender;
                    }

                    @Override
                    public MethodDescription getMethod() {
                        return this.methodDescription;
                    }

                    @Override
                    public Sort getSort() {
                        return Sort.DEFINED;
                    }

                    @Override
                    public void applyHead(MethodVisitor methodVisitor) {
                    }

                    @Override
                    public void applyBody(MethodVisitor methodVisitor, Implementation.Context implementationContext, AnnotationValueFilter.Factory annotationValueFilterFactory) {
                        this.methodAttributeAppender.apply(methodVisitor, this.methodDescription, annotationValueFilterFactory.on(this.methodDescription));
                    }

                    @Override
                    public Record prepend(ByteCodeAppender byteCodeAppender) {
                        throw new IllegalStateException("Cannot prepend code to abstract method");
                    }

                    public boolean equals(Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (other == null || this.getClass() != other.getClass()) {
                            return false;
                        }
                        WithoutBody that = (WithoutBody)other;
                        return this.methodDescription.equals(that.methodDescription) && this.methodAttributeAppender.equals(that.methodAttributeAppender);
                    }

                    public int hashCode() {
                        int result = this.methodDescription.hashCode();
                        result = 31 * result + this.methodAttributeAppender.hashCode();
                        return result;
                    }

                    public String toString() {
                        return "TypeWriter.MethodPool.Record.ForDefinedMethod.WithoutBody{methodDescription=" + this.methodDescription + ", methodAttributeAppender=" + this.methodAttributeAppender + '}';
                    }
                }

                public static class WithBody
                extends ForDefinedMethod {
                    private final MethodDescription methodDescription;
                    private final ByteCodeAppender byteCodeAppender;
                    private final MethodAttributeAppender methodAttributeAppender;

                    public WithBody(MethodDescription methodDescription, ByteCodeAppender byteCodeAppender) {
                        this(methodDescription, byteCodeAppender, MethodAttributeAppender.NoOp.INSTANCE);
                    }

                    public WithBody(MethodDescription methodDescription, ByteCodeAppender byteCodeAppender, MethodAttributeAppender methodAttributeAppender) {
                        this.methodDescription = methodDescription;
                        this.byteCodeAppender = byteCodeAppender;
                        this.methodAttributeAppender = methodAttributeAppender;
                    }

                    @Override
                    public MethodDescription getMethod() {
                        return this.methodDescription;
                    }

                    @Override
                    public Sort getSort() {
                        return Sort.IMPLEMENTED;
                    }

                    @Override
                    public void applyHead(MethodVisitor methodVisitor) {
                    }

                    @Override
                    public void applyBody(MethodVisitor methodVisitor, Implementation.Context implementationContext, AnnotationValueFilter.Factory annotationValueFilterFactory) {
                        this.methodAttributeAppender.apply(methodVisitor, this.methodDescription, annotationValueFilterFactory.on(this.methodDescription));
                        methodVisitor.visitCode();
                        ByteCodeAppender.Size size = this.byteCodeAppender.apply(methodVisitor, implementationContext, this.methodDescription);
                        methodVisitor.visitMaxs(size.getOperandStackSize(), size.getLocalVariableSize());
                    }

                    @Override
                    public Record prepend(ByteCodeAppender byteCodeAppender) {
                        return new WithBody(this.methodDescription, new ByteCodeAppender.Compound(byteCodeAppender, this.byteCodeAppender), this.methodAttributeAppender);
                    }

                    public boolean equals(Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (other == null || this.getClass() != other.getClass()) {
                            return false;
                        }
                        WithBody withBody = (WithBody)other;
                        return this.methodDescription.equals(withBody.methodDescription) && this.byteCodeAppender.equals(withBody.byteCodeAppender) && this.methodAttributeAppender.equals(withBody.methodAttributeAppender);
                    }

                    public int hashCode() {
                        int result = this.methodDescription.hashCode();
                        result = 31 * result + this.byteCodeAppender.hashCode();
                        result = 31 * result + this.methodAttributeAppender.hashCode();
                        return result;
                    }

                    public String toString() {
                        return "TypeWriter.MethodPool.Record.ForDefinedMethod.WithBody{methodDescription=" + this.methodDescription + ", byteCodeAppender=" + this.byteCodeAppender + ", methodAttributeAppender=" + this.methodAttributeAppender + '}';
                    }
                }
            }

            public static enum ForNonDefinedMethod implements Record
            {
                INSTANCE;


                @Override
                public void apply(ClassVisitor classVisitor, Implementation.Context implementationContext, AnnotationValueFilter.Factory annotationValueFilterFactory) {
                }

                @Override
                public void applyBody(MethodVisitor methodVisitor, Implementation.Context implementationContext, AnnotationValueFilter.Factory annotationValueFilterFactory) {
                    throw new IllegalStateException("Cannot apply headless implementation for method that should be skipped");
                }

                @Override
                public void applyHead(MethodVisitor methodVisitor) {
                    throw new IllegalStateException("Cannot apply headless implementation for method that should be skipped");
                }

                @Override
                public MethodDescription getMethod() {
                    throw new IllegalStateException("A method that is not defined cannot be extracted");
                }

                @Override
                public Sort getSort() {
                    return Sort.SKIPPED;
                }

                @Override
                public Record prepend(ByteCodeAppender byteCodeAppender) {
                    throw new IllegalStateException("Cannot prepend code to non-implemented method");
                }

                public String toString() {
                    return "TypeWriter.MethodPool.Record.ForNonDefinedMethod." + this.name();
                }
            }

            public static enum Sort {
                SKIPPED(false, false),
                DEFINED(true, false),
                IMPLEMENTED(true, true);

                private final boolean define;
                private final boolean implement;

                private Sort(boolean define, boolean implement) {
                    this.define = define;
                    this.implement = implement;
                }

                public boolean isDefined() {
                    return this.define;
                }

                public boolean isImplemented() {
                    return this.implement;
                }

                public String toString() {
                    return "TypeWriter.MethodPool.Entry.Sort." + this.name();
                }
            }
        }
    }

    public static interface FieldPool {
        public Record target(FieldDescription var1);

        public static interface Record {
            public boolean isImplicit();

            public FieldDescription getField();

            public FieldAttributeAppender getFieldAppender();

            public Object resolveDefault(Object var1);

            public void apply(ClassVisitor var1, AnnotationValueFilter.Factory var2);

            public void apply(FieldVisitor var1, AnnotationValueFilter.Factory var2);

            public static class ForExplicitField
            implements Record {
                private final FieldAttributeAppender attributeAppender;
                private final Object defaultValue;
                private final FieldDescription fieldDescription;

                public ForExplicitField(FieldAttributeAppender attributeAppender, Object defaultValue, FieldDescription fieldDescription) {
                    this.attributeAppender = attributeAppender;
                    this.defaultValue = defaultValue;
                    this.fieldDescription = fieldDescription;
                }

                @Override
                public boolean isImplicit() {
                    return false;
                }

                @Override
                public FieldDescription getField() {
                    return this.fieldDescription;
                }

                @Override
                public FieldAttributeAppender getFieldAppender() {
                    return this.attributeAppender;
                }

                @Override
                public Object resolveDefault(Object defaultValue) {
                    return this.defaultValue == null ? defaultValue : this.defaultValue;
                }

                @Override
                public void apply(ClassVisitor classVisitor, AnnotationValueFilter.Factory annotationValueFilterFactory) {
                    FieldVisitor fieldVisitor = classVisitor.visitField(this.fieldDescription.getActualModifiers(), this.fieldDescription.getInternalName(), this.fieldDescription.getDescriptor(), this.fieldDescription.getGenericSignature(), this.resolveDefault(FieldDescription.NO_DEFAULT_VALUE));
                    this.attributeAppender.apply(fieldVisitor, this.fieldDescription, annotationValueFilterFactory.on(this.fieldDescription));
                    fieldVisitor.visitEnd();
                }

                @Override
                public void apply(FieldVisitor fieldVisitor, AnnotationValueFilter.Factory annotationValueFilterFactory) {
                    this.attributeAppender.apply(fieldVisitor, this.fieldDescription, annotationValueFilterFactory.on(this.fieldDescription));
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    ForExplicitField that = (ForExplicitField)other;
                    return this.attributeAppender.equals(that.attributeAppender) && !(this.defaultValue == null ? that.defaultValue != null : !this.defaultValue.equals(that.defaultValue)) && this.fieldDescription.equals(that.fieldDescription);
                }

                public int hashCode() {
                    int result = this.attributeAppender.hashCode();
                    result = 31 * result + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
                    result = 31 * result + this.fieldDescription.hashCode();
                    return result;
                }

                public String toString() {
                    return "TypeWriter.FieldPool.Record.ForExplicitField{attributeAppender=" + this.attributeAppender + ", defaultValue=" + this.defaultValue + ", fieldDescription=" + this.fieldDescription + '}';
                }
            }

            public static class ForImplicitField
            implements Record {
                private final FieldDescription fieldDescription;

                public ForImplicitField(FieldDescription fieldDescription) {
                    this.fieldDescription = fieldDescription;
                }

                @Override
                public boolean isImplicit() {
                    return true;
                }

                @Override
                public FieldDescription getField() {
                    return this.fieldDescription;
                }

                @Override
                public FieldAttributeAppender getFieldAppender() {
                    throw new IllegalStateException("An implicit field record does not expose a field appender: " + this);
                }

                @Override
                public Object resolveDefault(Object defaultValue) {
                    throw new IllegalStateException("An implicit field record does not expose a default value: " + this);
                }

                @Override
                public void apply(ClassVisitor classVisitor, AnnotationValueFilter.Factory annotationValueFilterFactory) {
                    FieldVisitor fieldVisitor = classVisitor.visitField(this.fieldDescription.getActualModifiers(), this.fieldDescription.getInternalName(), this.fieldDescription.getDescriptor(), this.fieldDescription.getGenericSignature(), FieldDescription.NO_DEFAULT_VALUE);
                    FieldAttributeAppender.ForInstrumentedField.INSTANCE.apply(fieldVisitor, this.fieldDescription, annotationValueFilterFactory.on(this.fieldDescription));
                    fieldVisitor.visitEnd();
                }

                @Override
                public void apply(FieldVisitor fieldVisitor, AnnotationValueFilter.Factory annotationValueFilterFactory) {
                    throw new IllegalStateException("An implicit field record is not intended for partial application: " + this);
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.fieldDescription.equals(((ForImplicitField)other).fieldDescription);
                }

                public int hashCode() {
                    return this.fieldDescription.hashCode();
                }

                public String toString() {
                    return "TypeWriter.FieldPool.Record.ForImplicitField{fieldDescription=" + this.fieldDescription + '}';
                }
            }
        }
    }
}

