/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.type.TypeDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.DynamicType;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.NexusAccessor;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.scaffold.TypeInitializer;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.LoadedTypeInitializer;

public interface TypeResolutionStrategy {
    public Resolved resolve();

    public static enum Disabled implements TypeResolutionStrategy,
    Resolved
    {
        INSTANCE;


        @Override
        public Resolved resolve() {
            return this;
        }

        @Override
        public TypeInitializer injectedInto(TypeInitializer typeInitializer) {
            return typeInitializer;
        }

        @Override
        public Map<TypeDescription, Class<?>> initialize(DynamicType dynamicType, ClassLoader classLoader, ClassLoadingStrategy classLoadingStrategy) {
            throw new IllegalStateException("Cannot initialize a dynamic type for a disabled type resolution strategy");
        }

        public String toString() {
            return "TypeResolutionStrategy.Disabled." + this.name();
        }
    }

    public static enum Lazy implements TypeResolutionStrategy,
    Resolved
    {
        INSTANCE;


        @Override
        public Resolved resolve() {
            return this;
        }

        @Override
        public TypeInitializer injectedInto(TypeInitializer typeInitializer) {
            return typeInitializer;
        }

        @Override
        public Map<TypeDescription, Class<?>> initialize(DynamicType dynamicType, ClassLoader classLoader, ClassLoadingStrategy classLoadingStrategy) {
            return classLoadingStrategy.load(classLoader, dynamicType.getAllTypes());
        }

        public String toString() {
            return "TypeResolutionStrategy.Lazy." + this.name();
        }
    }

    public static enum Active implements TypeResolutionStrategy
    {
        INSTANCE;


        @Override
        @SuppressFBWarnings(value={"DMI_RANDOM_USED_ONLY_ONCE"}, justification="Avoid thread-contention")
        public nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.TypeResolutionStrategy$Resolved resolve() {
            return new Resolved(new Random().nextInt());
        }

        public String toString() {
            return "TypeResolutionStrategy.Active." + this.name();
        }

        protected static class Resolved
        implements nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.TypeResolutionStrategy$Resolved {
            private final int identification;

            protected Resolved(int identification) {
                this.identification = identification;
            }

            @Override
            public TypeInitializer injectedInto(TypeInitializer typeInitializer) {
                return typeInitializer.expandWith(new NexusAccessor.InitializationAppender(this.identification));
            }

            @Override
            public Map<TypeDescription, Class<?>> initialize(DynamicType dynamicType, ClassLoader classLoader, ClassLoadingStrategy classLoadingStrategy) {
                HashMap<TypeDescription, LoadedTypeInitializer> loadedTypeInitializers = new HashMap<TypeDescription, LoadedTypeInitializer>(dynamicType.getLoadedTypeInitializers());
                TypeDescription instrumentedType = dynamicType.getTypeDescription();
                Map<TypeDescription, Class<?>> types = classLoadingStrategy.load(classLoader, dynamicType.getAllTypes());
                NexusAccessor.INSTANCE.register(instrumentedType.getName(), types.get(instrumentedType).getClassLoader(), this.identification, (LoadedTypeInitializer)loadedTypeInitializers.remove(instrumentedType));
                for (Map.Entry entry : loadedTypeInitializers.entrySet()) {
                    ((LoadedTypeInitializer)entry.getValue()).onLoad(types.get(entry.getKey()));
                }
                return types;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                Resolved resolved = (Resolved)object;
                return this.identification == resolved.identification;
            }

            public int hashCode() {
                return this.identification;
            }

            public String toString() {
                return "TypeResolutionStrategy.Active.Resolved{identification=" + this.identification + '}';
            }
        }
    }

    public static enum Passive implements TypeResolutionStrategy,
    Resolved
    {
        INSTANCE;


        @Override
        public Resolved resolve() {
            return this;
        }

        @Override
        public TypeInitializer injectedInto(TypeInitializer typeInitializer) {
            return typeInitializer;
        }

        @Override
        public Map<TypeDescription, Class<?>> initialize(DynamicType dynamicType, ClassLoader classLoader, ClassLoadingStrategy classLoadingStrategy) {
            Map<TypeDescription, Class<?>> types = classLoadingStrategy.load(classLoader, dynamicType.getAllTypes());
            for (Map.Entry<TypeDescription, LoadedTypeInitializer> entry : dynamicType.getLoadedTypeInitializers().entrySet()) {
                entry.getValue().onLoad(types.get(entry.getKey()));
            }
            return new HashMap(types);
        }

        public String toString() {
            return "TypeResolutionStrategy.Passive." + this.name();
        }
    }

    public static interface Resolved {
        public TypeInitializer injectedInto(TypeInitializer var1);

        public Map<TypeDescription, Class<?>> initialize(DynamicType var1, ClassLoader var2, ClassLoadingStrategy var3);
    }
}

