/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.MethodDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.MethodList;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.type.TypeDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.ClassFileLocator;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.Nexus;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.loading.ClassInjector;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.Implementation;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.LoadedTypeInitializer;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.ByteCodeAppender;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.Removal;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.StackManipulation;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.collection.ArrayFactory;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.constant.ClassConstant;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.constant.NullConstant;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.constant.TextConstant;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.member.MethodInvocation;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.MethodVisitor;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.matcher.ElementMatchers;

public enum NexusAccessor implements PrivilegedAction<Dispatcher>
{
    INSTANCE;

    private final Dispatcher dispatcher = AccessController.doPrivileged(this);
    private final MethodDescription.InDefinedShape getSystemClassLoader = (MethodDescription.InDefinedShape)((MethodList)new TypeDescription.ForLoadedType(ClassLoader.class).getDeclaredMethods().filter(ElementMatchers.named("getSystemClassLoader").and(ElementMatchers.takesArguments(0)))).getOnly();
    private final MethodDescription.InDefinedShape loadClass = (MethodDescription.InDefinedShape)((MethodList)new TypeDescription.ForLoadedType(ClassLoader.class).getDeclaredMethods().filter(ElementMatchers.named("loadClass").and(ElementMatchers.takesArguments(String.class)))).getOnly();
    private final MethodDescription.InDefinedShape valueOf;
    private final MethodDescription getDeclaredMethod = (MethodDescription)((MethodList)new TypeDescription.ForLoadedType(Class.class).getDeclaredMethods().filter(ElementMatchers.named("getDeclaredMethod").and(ElementMatchers.takesArguments(String.class, Class[].class)))).getOnly();
    private final MethodDescription invokeMethod = (MethodDescription)((MethodList)new TypeDescription.ForLoadedType(Method.class).getDeclaredMethods().filter(ElementMatchers.named("invoke").and(ElementMatchers.takesArguments(Object.class, Object[].class)))).getOnly();

    private NexusAccessor() {
        this.valueOf = (MethodDescription.InDefinedShape)((MethodList)new TypeDescription.ForLoadedType(Integer.class).getDeclaredMethods().filter(ElementMatchers.named("valueOf").and(ElementMatchers.takesArguments(Integer.TYPE)))).getOnly();
    }

    @Override
    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should not be rethrown but trigger a fallback")
    public Dispatcher run() {
        try {
            TypeDescription.ForLoadedType nexusType = new TypeDescription.ForLoadedType(Nexus.class);
            return new Dispatcher.Available(new ClassInjector.UsingReflection(ClassLoader.getSystemClassLoader(), Nexus.class.getProtectionDomain()).inject(Collections.singletonMap(nexusType, ClassFileLocator.ForClassLoader.read(Nexus.class).resolve())).get(nexusType).getDeclaredMethod("register", String.class, ClassLoader.class, Integer.TYPE, Object.class));
        }
        catch (Exception exception) {
            try {
                return new Dispatcher.Available(ClassLoader.getSystemClassLoader().loadClass(Nexus.class.getName()).getDeclaredMethod("register", String.class, ClassLoader.class, Integer.TYPE, Object.class));
            }
            catch (Exception ignored) {
                return new Dispatcher.Unavailable(exception);
            }
        }
    }

    public void register(String name, ClassLoader classLoader, int identification, LoadedTypeInitializer loadedTypeInitializer) {
        if (loadedTypeInitializer.isAlive()) {
            this.dispatcher.register(name, classLoader, identification, loadedTypeInitializer);
        }
    }

    public String toString() {
        return "NexusAccessor." + this.name();
    }

    protected static interface Dispatcher {
        public void register(String var1, ClassLoader var2, int var3, LoadedTypeInitializer var4);

        public static class Unavailable
        implements Dispatcher {
            private final Exception exception;

            protected Unavailable(Exception exception) {
                this.exception = exception;
            }

            @Override
            public void register(String name, ClassLoader classLoader, int identification, LoadedTypeInitializer loadedTypeInitializer) {
                throw new IllegalStateException("Could not locate registration method", this.exception);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.exception.equals(((Unavailable)other).exception);
            }

            public int hashCode() {
                return this.exception.hashCode();
            }

            public String toString() {
                return "NexusAccessor.Dispatcher.Unavailable{exception=" + this.exception + '}';
            }
        }

        public static class Available
        implements Dispatcher {
            private static final Object STATIC_METHOD = null;
            private final Method registration;

            protected Available(Method registration) {
                this.registration = registration;
            }

            @Override
            public void register(String name, ClassLoader classLoader, int identification, LoadedTypeInitializer loadedTypeInitializer) {
                try {
                    this.registration.invoke(STATIC_METHOD, name, classLoader, identification, loadedTypeInitializer);
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalStateException("Cannot register type initializer for " + name, exception);
                }
                catch (InvocationTargetException exception) {
                    throw new IllegalStateException("Cannot register type initializer for " + name, exception.getCause());
                }
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.registration.equals(((Available)other).registration);
            }

            public int hashCode() {
                return this.registration.hashCode();
            }

            public String toString() {
                return "NexusAccessor.Dispatcher.Available{registration=" + this.registration + '}';
            }
        }
    }

    public static class InitializationAppender
    implements ByteCodeAppender {
        private final int identification;

        public InitializationAppender(int identification) {
            this.identification = identification;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            return new ByteCodeAppender.Simple(new StackManipulation.Compound(MethodInvocation.invoke(INSTANCE.getSystemClassLoader), new TextConstant(Nexus.class.getName()), MethodInvocation.invoke(INSTANCE.loadClass), new TextConstant("initialize"), ArrayFactory.forType(new TypeDescription.Generic.OfNonGenericType.ForLoadedType(Class.class)).withValues(Arrays.asList(ClassConstant.of(TypeDescription.CLASS), ClassConstant.of(new TypeDescription.ForLoadedType(Integer.TYPE)))), MethodInvocation.invoke(INSTANCE.getDeclaredMethod), NullConstant.INSTANCE, ArrayFactory.forType(TypeDescription.Generic.OBJECT).withValues(Arrays.asList(ClassConstant.of(instrumentedMethod.getDeclaringType().asErasure()), new StackManipulation.Compound(IntegerConstant.forValue(this.identification), MethodInvocation.invoke(INSTANCE.valueOf)))), MethodInvocation.invoke(INSTANCE.invokeMethod), Removal.SINGLE)).apply(methodVisitor, implementationContext, instrumentedMethod);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            InitializationAppender that = (InitializationAppender)object;
            return this.identification == that.identification;
        }

        public int hashCode() {
            return this.identification;
        }

        public String toString() {
            return "NexusAccessor.InitializationAppender{identification=" + this.identification + '}';
        }
    }
}

