/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osb.i18n;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class Messages {
    private ResourceBundle bundle;
    private static Messages instance;

    private Messages() {
        try {
            this.loadBundle(Locale.getDefault());
        }
        catch (IOException e) {
            e.printStackTrace();
            try {
                this.loadBundle(Locale.ENGLISH);
            }
            catch (IOException e1) {
                System.err.println("Couldn't load default resource bundle");
                e.printStackTrace();
            }
        }
    }

    public static ResourceBundle getBundle() {
        if (instance == null) {
            instance = new Messages();
        }
        return instance.getResourceBundle();
    }

    public static String translate(Class clazz, String key) {
        key = clazz.getName() + "." + key;
        return Messages.getBundle().getString(key);
    }

    private void loadBundle(Locale locale) throws IOException {
        InputStream in = Messages.class.getResourceAsStream("language_" + locale.toString() + ".properties");
        this.bundle = new PropertyResourceBundle(in);
    }

    private ResourceBundle getResourceBundle() {
        return this.bundle;
    }

    public static String translate(Class clazz, String key, Object[] params) {
        String mesg = Messages.translate(clazz, key);
        MessageFormat format = new MessageFormat("");
        format.applyPattern(mesg);
        return format.format(params);
    }
}

