/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osb.gui.action;

import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.plugins.osb.OsbPlugin;
import org.openstreetmap.josm.plugins.osb.gui.action.AddCommentAction;
import org.openstreetmap.josm.plugins.osb.gui.action.CloseIssueAction;

public class PopupFactory {
    private static JPopupMenu issuePopup;
    private static JPopupMenu fixedPopup;

    public static synchronized JPopupMenu createPopup(Node node) {
        if ("0".equals(node.get("state"))) {
            return PopupFactory.getIssuePopup();
        }
        if ("1".equals(node.get("state"))) {
            return PopupFactory.getFixedPopup();
        }
        throw new RuntimeException("Unknown issue state");
    }

    private static JPopupMenu getIssuePopup() {
        if (issuePopup == null) {
            issuePopup = new JPopupMenu();
            JMenuItem add = new JMenuItem();
            add.setAction(new AddCommentAction());
            add.setIcon(OsbPlugin.loadIcon("add_comment16.png"));
            issuePopup.add(add);
            JMenuItem close = new JMenuItem();
            close.setAction(new CloseIssueAction());
            close.setIcon(OsbPlugin.loadIcon("icon_valid16.png"));
            issuePopup.add(close);
        }
        return issuePopup;
    }

    private static JPopupMenu getFixedPopup() {
        if (fixedPopup == null) {
            fixedPopup = new JPopupMenu();
            JMenuItem add = new JMenuItem();
            AddCommentAction aca = new AddCommentAction();
            aca.setEnabled(false);
            add.setAction(aca);
            add.setIcon(OsbPlugin.loadIcon("add_comment16.png"));
            JMenuItem close = new JMenuItem();
            CloseIssueAction cia = new CloseIssueAction();
            cia.setEnabled(false);
            close.setAction(cia);
            close.setIcon(OsbPlugin.loadIcon("icon_valid16.png"));
            fixedPopup.add(add);
            fixedPopup.add(close);
        }
        return fixedPopup;
    }
}

