/*
 * Decompiled with CFR 0.152.
 */
package org.junit.contrib.java.lang.system;

import java.util.ArrayList;
import java.util.Collection;
import org.junit.Assert;
import org.junit.contrib.java.lang.system.Assertion;
import org.junit.contrib.java.lang.system.ProvideSecurityManager;
import org.junit.contrib.java.lang.system.internal.CheckExitCalled;
import org.junit.contrib.java.lang.system.internal.NoExitSecurityManager;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class ExpectedSystemExit
implements TestRule {
    private final Collection<Assertion> assertions = new ArrayList<Assertion>();
    private boolean expectExit = false;
    private Integer expectedStatus = null;

    public static ExpectedSystemExit none() {
        return new ExpectedSystemExit();
    }

    private ExpectedSystemExit() {
    }

    public void expectSystemExitWithStatus(int status) {
        this.expectSystemExit();
        this.expectedStatus = status;
    }

    public void expectSystemExit() {
        this.expectExit = true;
    }

    public void checkAssertionAfterwards(Assertion assertion) {
        this.assertions.add(assertion);
    }

    public Statement apply(Statement base, Description description) {
        ProvideSecurityManager noExitSecurityManagerRule = this.createNoExitSecurityManagerRule();
        Statement statement = this.createStatement(base);
        return noExitSecurityManagerRule.apply(statement, description);
    }

    private ProvideSecurityManager createNoExitSecurityManagerRule() {
        NoExitSecurityManager noExitSecurityManager = new NoExitSecurityManager(System.getSecurityManager());
        return new ProvideSecurityManager(noExitSecurityManager);
    }

    private Statement createStatement(final Statement base) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    base.evaluate();
                }
                catch (CheckExitCalled checkExitCalled) {
                    // empty catch block
                }
                ExpectedSystemExit.this.checkSystemExit();
                ExpectedSystemExit.this.checkAssertions();
            }
        };
    }

    private void checkSystemExit() {
        NoExitSecurityManager securityManager = (NoExitSecurityManager)System.getSecurityManager();
        if (securityManager.isCheckExitCalled()) {
            this.handleSystemExitWithStatus(securityManager.getStatusOfFirstCheckExitCall());
        } else {
            this.handleMissingSystemExit();
        }
    }

    private void handleMissingSystemExit() {
        if (this.expectExit) {
            Assert.fail((String)"System.exit has not been called.");
        }
    }

    private void handleSystemExitWithStatus(int status) {
        if (!this.expectExit) {
            Assert.fail((String)("Unexpected call of System.exit(" + status + ")."));
        } else if (this.expectedStatus != null) {
            Assert.assertEquals((String)"Wrong exit status", (Object)this.expectedStatus, (Object)status);
        }
    }

    private void checkAssertions() throws Exception {
        for (Assertion assertion : this.assertions) {
            assertion.checkAssertion();
        }
    }
}

