/*
 * Decompiled with CFR 0.152.
 */
package wmsplugin;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.MapView;
import wmsplugin.GeorefImage;
import wmsplugin.WMSLayer;

public abstract class Grabber
implements Runnable {
    protected Bounds b;
    protected Projection proj;
    protected double pixelPerDegree;
    protected MapView mv;
    protected WMSLayer layer;
    protected GeorefImage image;

    Grabber(Bounds b, Projection proj, double pixelPerDegree, GeorefImage image, MapView mv, WMSLayer layer) {
        this.b = b;
        this.proj = proj;
        this.pixelPerDegree = pixelPerDegree;
        this.image = image;
        this.mv = mv;
        this.layer = layer;
    }

    abstract void fetch() throws Exception;

    int width() {
        return (int)((this.b.max.lon() - this.b.min.lon()) * this.pixelPerDegree);
    }

    int height() {
        return (int)((this.b.max.lat() - this.b.min.lat()) * this.pixelPerDegree);
    }

    protected void grabError(Exception e) {
        e.printStackTrace();
        BufferedImage img = new BufferedImage(this.width(), this.height(), 2);
        Graphics g = img.getGraphics();
        g.setColor(Color.RED);
        g.fillRect(0, 0, this.width(), this.height());
        Font font = g.getFont();
        Font tempFont = font.deriveFont(0).deriveFont(36.0f);
        g.setFont(tempFont);
        g.setColor(Color.BLACK);
        g.drawString(e.getClass().getSimpleName() + " occured", 10, this.height() / 2);
        this.image.image = img;
        g.setFont(font);
    }

    protected void attempt() {
        int maxTries = 5;
        for (int i = 1; i <= maxTries; ++i) {
            try {
                this.fetch();
                break;
            }
            catch (Exception e) {
                try {
                    Thread.sleep(Grabber.random(1000, 2000));
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
                if (i != maxTries) continue;
                this.grabError(e);
                continue;
            }
        }
    }

    public static int random(int min, int max) {
        return (int)(Math.random() * (double)(max + 1 - min)) + min;
    }
}

