/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.lakewalker;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.plugins.lakewalker.Lakewalker;
import org.openstreetmap.josm.plugins.lakewalker.LakewalkerException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.xml.sax.SAXException;

class LakewalkerAction
extends JosmAction
implements MouseListener {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected Cursor oldCursor;
    protected List<Node> selectedNodes;
    protected Thread executeThread;
    protected boolean cancel;
    protected Collection<Command> commands = new LinkedList<Command>();
    protected Collection<Way> ways = new ArrayList<Way>();

    public LakewalkerAction(String name) {
        super(name, "lakewalker-sml", I18n.tr((String)"Lake Walker."), 76, 3, true);
        this.name = name;
        this.setEnabled(true);
    }

    public void actionPerformed(ActionEvent e) {
        Main.map.mapView.setCursor(this.oldCursor);
        if (Main.map == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"No data loaded."));
            return;
        }
        this.selectedNodes = new ArrayList<Node>();
        for (OsmPrimitive osm : Main.ds.getSelected()) {
            if (!(osm instanceof Node)) continue;
            Node node = (Node)osm;
            this.selectedNodes.add(node);
        }
        if (this.selectedNodes.isEmpty()) {
            this.oldCursor = Main.map.mapView.getCursor();
            Main.map.mapView.setCursor(ImageProvider.getCursor((String)"crosshair", (String)"lakewalker-sml"));
            Main.map.mapView.addMouseListener((MouseListener)this);
        } else {
            this.lakewalk(this.selectedNodes);
        }
    }

    protected void lakewalk(Point clickPoint) {
        final LatLon pos = Main.map.mapView.getLatLon(clickPoint.x, clickPoint.y);
        final LatLon topLeft = Main.map.mapView.getLatLon(0, 0);
        final LatLon botRight = Main.map.mapView.getLatLon(Main.map.mapView.getWidth(), Main.map.mapView.getHeight());
        final File working_dir = new File(Main.pref.getPreferencesDir(), "plugins/Lakewalker");
        final int waylen = Main.pref.getInteger("lakewalker.max_segs_in_way", 500);
        final int maxnode = Main.pref.getInteger("lakewalker.max_nodes", 50000);
        final int threshold = Main.pref.getInteger("lakewalker.thresholdvalue", 90);
        final double epsilon = Main.pref.getDouble("lakewalker.epsilon", 3.0E-4);
        final int resolution = Main.pref.getInteger("lakewalker.landsat_res", 4000);
        final int tilesize = Main.pref.getInteger("lakewalker.landsat_size", 2000);
        final String startdir = Main.pref.get("lakewalker.startdir", "east");
        final String wmslayer = Main.pref.get("lakewalker.wms", "IR1");
        try {
            PleaseWaitRunnable lakewalkerTask = new PleaseWaitRunnable(I18n.tr((String)"Tracing")){

                protected void realRun() throws SAXException {
                    LakewalkerAction.this.processnodelist(pos, topLeft, botRight, waylen, maxnode, threshold, epsilon, resolution, tilesize, startdir, wmslayer, working_dir);
                }

                protected void finish() {
                }

                protected void cancel() {
                    this.cancel();
                }
            };
            Thread executeThread = new Thread((Runnable)lakewalkerTask);
            executeThread.start();
        }
        catch (Exception ex) {
            System.out.println("Exception caught: " + ex.getMessage());
        }
    }

    private void processnodelist(LatLon pos, LatLon topLeft, LatLon botRight, int waylen, int maxnode, int threshold, double epsilon, int resolution, int tilesize, String startdir, String wmslayer, File workingdir) {
        ArrayList<double[]> nodelist = new ArrayList();
        Lakewalker lw = new Lakewalker(waylen, maxnode, threshold, epsilon, resolution, tilesize, startdir, wmslayer, workingdir);
        try {
            nodelist = lw.trace(pos.lat(), pos.lon(), topLeft.lon(), botRight.lon(), topLeft.lat(), botRight.lat());
        }
        catch (LakewalkerException e) {
            System.out.println(e.getError());
        }
        System.out.println(nodelist.size() + " nodes generated");
        this.setStatus("Running vertex reduction...");
        nodelist = lw.vertexReduce(nodelist, epsilon);
        System.out.println("After vertex reduction " + nodelist.size() + " nodes remain.");
        this.setStatus("Running Douglas-Peucker approximation...");
        nodelist = lw.douglasPeucker(nodelist, epsilon);
        System.out.println("After Douglas-Peucker approximation " + nodelist.size() + " nodes remain.");
        this.setStatus("Removing duplicate nodes...");
        nodelist = lw.duplicateNodeRemove(nodelist);
        System.out.println("After removing duplicate nodes, " + nodelist.size() + " nodes remain.");
        Way way = new Way();
        Node n = null;
        Object tn = null;
        Node fn = null;
        double eastOffset = Main.pref.getDouble("lakewalker.east_offset", 0.0);
        double northOffset = Main.pref.getDouble("lakewalker.north_offset", 0.0);
        int option = 32;
        int nodesinway = 0;
        for (int i = 0; i < nodelist.size(); ++i) {
            if (this.cancel) {
                return;
            }
            try {
                LatLon ll = new LatLon(nodelist.get(i)[0] + northOffset, nodelist.get(i)[1] + eastOffset);
                n = new Node(ll);
                if (fn == null) {
                    fn = n;
                }
                this.commands.add((Command)new AddCommand((OsmPrimitive)n));
            }
            catch (Exception ex) {
                // empty catch block
            }
            way.nodes.add(n);
            if (nodesinway > Main.pref.getInteger("lakewalker.max_segs_in_way", 500)) {
                String waytype = Main.pref.get("lakewalker.waytype", "water");
                if (!waytype.equals("none")) {
                    way.put("natural", waytype);
                }
                way.put("created_by", "Dshpak_landsat_lakes");
                this.commands.add((Command)new AddCommand((OsmPrimitive)way));
                way = new Way();
                way.nodes.add(n);
                nodesinway = 0;
            }
            ++nodesinway;
        }
        String waytype = Main.pref.get("lakewalker.waytype", "water");
        if (!waytype.equals("none")) {
            way.put("natural", waytype);
        }
        way.put("created_by", "Dshpak_landsat_lakes");
        way.nodes.add(fn);
        this.commands.add((Command)new AddCommand((OsmPrimitive)way));
        if (!this.commands.isEmpty()) {
            Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Lakewalker trace"), this.commands));
            Main.ds.setSelected(this.ways);
        } else {
            System.out.println("Failed");
        }
        this.commands = new LinkedList<Command>();
        this.ways = new ArrayList<Way>();
    }

    public void cancel() {
        this.cancel = true;
    }

    protected void lakewalk(List nodes) {
    }

    public void mouseClicked(MouseEvent e) {
        Main.map.mapView.removeMouseListener((MouseListener)this);
        Main.map.mapView.setCursor(this.oldCursor);
        this.lakewalk(e.getPoint());
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    protected void setStatus(String s) {
        Main.pleaseWaitDlg.currentAction.setText(s);
        Main.pleaseWaitDlg.repaint();
    }
}

