/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.lakewalker;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.openstreetmap.josm.plugins.lakewalker.Configurer;

public class StringEnumConfigurer
extends Configurer {
    protected String[] validValues;
    protected JComboBox box;
    protected Box panel;
    protected String tooltipText = "";

    public StringEnumConfigurer(String key, String name, String[] validValues) {
        super(key, name);
        this.validValues = validValues;
    }

    public StringEnumConfigurer(String[] validValues) {
        this((String)null, "", validValues);
    }

    public void setToolTipText(String s) {
        this.tooltipText = s;
    }

    public Component getControls() {
        if (this.panel == null) {
            this.panel = Box.createHorizontalBox();
            this.panel.add(new JLabel(this.name));
            this.box = new JComboBox<String>(this.validValues);
            this.box.setToolTipText(this.tooltipText);
            this.box.setMaximumSize(new Dimension(this.box.getMaximumSize().width, this.box.getPreferredSize().height));
            if (this.isValidValue(this.getValue())) {
                this.box.setSelectedItem(this.getValue());
            } else if (this.validValues.length > 0) {
                this.box.setSelectedIndex(0);
            }
            this.box.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    StringEnumConfigurer.this.noUpdate = true;
                    StringEnumConfigurer.this.setValue(StringEnumConfigurer.this.box.getSelectedItem());
                    StringEnumConfigurer.this.noUpdate = false;
                }
            });
            this.panel.add(this.box);
        }
        return this.panel;
    }

    public boolean isValidValue(Object o) {
        for (int i = 0; i < this.validValues.length; ++i) {
            if (!this.validValues[i].equals(o)) continue;
            return true;
        }
        return false;
    }

    public String[] getValidValues() {
        return this.validValues;
    }

    public void setValidValues(String[] s) {
        this.validValues = s;
        if (this.box == null) {
            this.getControls();
        }
        this.box.setModel(new DefaultComboBoxModel<String>(this.validValues));
    }

    public void setValue(Object o) {
        if (this.validValues == null || this.isValidValue(o)) {
            super.setValue(o);
            if (!this.noUpdate && this.box != null) {
                this.box.setSelectedItem(o);
            }
        }
    }

    public String getValueString() {
        return this.box != null ? (String)this.box.getSelectedItem() : this.validValues[0];
    }

    public void setValue(String s) {
        this.setValue((Object)s);
    }
}

