/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import antlr.collections.AST;
import com.google.common.collect.Maps;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Map;

public class EqualsHashCodeCheck
extends AbstractCheck {
    public static final String MSG_KEY_HASHCODE = "equals.noHashCode";
    public static final String MSG_KEY_EQUALS = "equals.noEquals";
    private final Map<DetailAST, DetailAST> objBlockWithEquals = Maps.newHashMap();
    private final Map<DetailAST, DetailAST> objBlockWithHashCode = Maps.newHashMap();

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{9};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.objBlockWithEquals.clear();
        this.objBlockWithHashCode.clear();
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST modifiers = ast.getFirstChild();
        DetailAST type = ast.findFirstToken(13);
        DetailAST methodName = ast.findFirstToken(58);
        DetailAST parameters = ast.findFirstToken(20);
        if (type.getFirstChild().getType() == 50 && "equals".equals(methodName.getText()) && modifiers.branchContains(62) && parameters.getChildCount() == 1 && EqualsHashCodeCheck.isObjectParam(parameters.getFirstChild())) {
            this.objBlockWithEquals.put(ast.getParent(), ast);
        } else if (type.getFirstChild().getType() == 54 && "hashCode".equals(methodName.getText()) && modifiers.branchContains(62) && parameters.getFirstChild() == null) {
            this.objBlockWithHashCode.put(ast.getParent(), ast);
        }
    }

    private static boolean isObjectParam(AST firstChild) {
        AST modifiers = firstChild.getFirstChild();
        AST type = modifiers.getNextSibling();
        switch (type.getFirstChild().getType()) {
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return false;
            }
        }
        return true;
    }

    @Override
    public void finishTree(DetailAST rootAST) {
        DetailAST equalsAST;
        for (Map.Entry<DetailAST, DetailAST> detailASTDetailASTEntry : this.objBlockWithEquals.entrySet()) {
            if (this.objBlockWithHashCode.remove(detailASTDetailASTEntry.getKey()) != null) continue;
            equalsAST = detailASTDetailASTEntry.getValue();
            this.log(equalsAST.getLineNo(), equalsAST.getColumnNo(), MSG_KEY_HASHCODE, new Object[0]);
        }
        for (Map.Entry<DetailAST, DetailAST> detailASTDetailASTEntry : this.objBlockWithHashCode.entrySet()) {
            equalsAST = detailASTDetailASTEntry.getValue();
            this.log(equalsAST.getLineNo(), equalsAST.getColumnNo(), MSG_KEY_EQUALS, new Object[0]);
        }
        this.objBlockWithEquals.clear();
        this.objBlockWithHashCode.clear();
    }
}

