/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.core.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.unitils.core.UnitilsException;
import org.unitils.util.AnnotationUtils;
import org.unitils.util.ReflectionUtils;

public abstract class AnnotatedInstanceManager<T, A extends Annotation> {
    protected Map<Class<?>, T> instances = new HashMap();
    protected Class<T> instanceClass;
    protected Class<A> annotationClass;

    protected AnnotatedInstanceManager(Class<T> instanceClass, Class<A> annotationClass) {
        this.instanceClass = instanceClass;
        this.annotationClass = annotationClass;
    }

    protected T getInstance(Object testObject) {
        return this.getInstanceImpl(testObject, testObject.getClass());
    }

    protected void registerInstance(Class<?> testClass, T instance) {
        this.instances.put(testClass, instance);
    }

    protected boolean hasInstance(Object testObject) {
        return this.hasInstanceImpl(testObject, testObject.getClass());
    }

    protected void invalidateInstance(Class<?> ... classes) {
        if (classes == null || classes.length == 0) {
            this.instances.clear();
            return;
        }
        for (Class<?> clazz : classes) {
            this.instances.remove(clazz);
        }
    }

    protected boolean hasInstanceImpl(Object testObject, Class<?> testClass) {
        if (testClass == null || testClass == Object.class) {
            return false;
        }
        if (this.instances.containsKey(testClass)) {
            return true;
        }
        if (!this.getAnnotationValues((A)testClass).isEmpty()) {
            return true;
        }
        if (this.getCustomCreateMethod(testClass, false) != null) {
            return true;
        }
        return this.hasInstanceImpl(testObject, testClass.getSuperclass());
    }

    protected T getInstanceImpl(Object testObject, Class<?> testClass) {
        if (testClass == null || testClass == Object.class) {
            return null;
        }
        T instance = this.instances.get(testClass);
        if (instance != null) {
            return instance;
        }
        List<String> annotationValues = this.getAnnotationValues((A)testClass);
        Method customCreateMethod = this.getCustomCreateMethod(testClass, false);
        if (customCreateMethod != null) {
            instance = this.createCustomCreatedInstance(customCreateMethod, testObject, testClass, annotationValues);
        } else if (!annotationValues.isEmpty()) {
            customCreateMethod = this.getCustomCreateMethod(testClass, true);
            instance = customCreateMethod != null ? this.createCustomCreatedInstance(customCreateMethod, testObject, testClass, annotationValues) : this.createInstanceForValues(testObject, testClass, annotationValues);
        }
        if (instance == null) {
            return this.getInstanceImpl(testObject, testClass.getSuperclass());
        }
        this.afterInstanceCreate(instance, testObject, testClass);
        this.registerInstance(testClass, instance);
        return instance;
    }

    protected void afterInstanceCreate(T instance, Object testObject, Class<?> testClass) {
    }

    protected List<String> getAnnotationValues(Class<?> testClass) {
        ArrayList<A> annotations = new ArrayList<A>();
        Object annotation = testClass.getAnnotation(this.annotationClass);
        if (annotation != null && !this.getAnnotationValues(annotation).isEmpty()) {
            annotations.add(annotation);
        }
        Set<Field> fields = AnnotationUtils.getFieldsAnnotatedWith(testClass, this.annotationClass);
        for (Field field : fields) {
            annotation = field.getAnnotation(this.annotationClass);
            if (annotation == null || this.getAnnotationValues(annotation).isEmpty()) continue;
            annotations.add(annotation);
        }
        Set<Method> methods = AnnotationUtils.getMethodsAnnotatedWith(testClass, this.annotationClass, false);
        for (Method method : methods) {
            annotation = method.getAnnotation(this.annotationClass);
            if (annotation == null || this.getAnnotationValues(annotation).isEmpty()) continue;
            annotations.add(annotation);
        }
        if (annotations.size() > 1) {
            throw new UnitilsException("There can only be 1 @" + this.annotationClass.getSimpleName() + " annotation with values per class.");
        }
        if (annotations.isEmpty()) {
            return new ArrayList<String>();
        }
        annotation = (Annotation)annotations.get(0);
        return this.getAnnotationValues(annotation);
    }

    protected Method getCustomCreateMethod(Class<?> testClass, boolean searchSuperClasses) {
        if (testClass == null || testClass == Object.class) {
            return null;
        }
        Set<Method> methods = AnnotationUtils.getMethodsAnnotatedWith(testClass, this.annotationClass, false);
        ArrayList<Method> customCreateMethods = new ArrayList<Method>();
        for (Method method : methods) {
            if (method.getReturnType() == Void.TYPE) continue;
            customCreateMethods.add(method);
        }
        if (customCreateMethods.size() > 1) {
            throw new UnitilsException("There can only be 1 method per class annotated with @" + this.annotationClass.getSimpleName() + " for creating a session factory.");
        }
        if (customCreateMethods.isEmpty()) {
            if (searchSuperClasses) {
                return this.getCustomCreateMethod(testClass.getSuperclass(), searchSuperClasses);
            }
            return null;
        }
        Method customCreateMethod = (Method)customCreateMethods.get(0);
        if (!this.isCustomCreateMethod(customCreateMethod)) {
            throw new UnitilsException("Custom create method annotated with @" + this.annotationClass.getSimpleName() + " should have following signature: " + this.getCustomCreateMethodReturnType().getName() + " myMethod( List<String> locations ) or " + this.getCustomCreateMethodReturnType().getName() + " myMethod()");
        }
        return customCreateMethod;
    }

    protected boolean isCustomCreateMethod(Method method) {
        Class<?>[] argumentTypes = method.getParameterTypes();
        if (argumentTypes.length > 1) {
            return false;
        }
        if (argumentTypes.length == 1 && argumentTypes[0] != List.class) {
            return false;
        }
        return this.getCustomCreateMethodReturnType().isAssignableFrom(method.getReturnType());
    }

    protected T createCustomCreatedInstance(Method customCreateMethod, Object testObject, Class<?> testClass, List<String> annotationValues) {
        Object customCreateMethodResult = this.invokeCustomCreateMethod(customCreateMethod, testObject, annotationValues);
        return this.createCustomCreatedInstanceFromCustomCreateMethodResult(testObject, testClass, customCreateMethodResult);
    }

    protected Object invokeCustomCreateMethod(Method customCreateMethod, Object testObject, List<String> annotationValues) {
        Object result;
        try {
            result = customCreateMethod.getParameterTypes().length == 0 ? ReflectionUtils.invokeMethod(testObject, customCreateMethod, new Object[0]) : ReflectionUtils.invokeMethod(testObject, customCreateMethod, annotationValues);
        }
        catch (InvocationTargetException e) {
            throw new UnitilsException("Method " + testObject.getClass().getSimpleName() + "." + customCreateMethod + " (annotated with " + this.annotationClass.getSimpleName() + ") has thrown an exception", e.getCause());
        }
        if (result == null) {
            throw new UnitilsException("Method " + testObject.getClass().getSimpleName() + "." + customCreateMethod + " (annotated with " + this.annotationClass.getSimpleName() + ") has returned null.");
        }
        return result;
    }

    protected T createCustomCreatedInstanceFromCustomCreateMethodResult(Object testObject, Class<?> testClass, Object customCreateMethodResult) {
        return (T)customCreateMethodResult;
    }

    protected Class<?> getCustomCreateMethodReturnType() {
        return this.instanceClass;
    }

    protected abstract List<String> getAnnotationValues(A var1);

    protected abstract T createInstanceForValues(Object var1, Class<?> var2, List<String> var3);
}

