/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DiskAccessAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.io.TcxReader;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.tools.I18n;

public class TcxPlugin
extends Plugin {
    public TcxPlugin() {
        JMenu menu = Main.main.menu.getMenu(0);
        OpenAction openAction = new OpenAction();
        JMenuItem actionItem = new JMenuItem((Action)((Object)openAction));
        menu.insert(actionItem, 2);
        actionItem.setAccelerator(((JosmAction)openAction).shortCut);
    }

    public class OpenAction
    extends DiskAccessAction {
        public OpenAction() {
            super("Import TCX File...", "tcxicon", "", 84, 2);
        }

        private void addTcxFileFilter() {
        }

        public void actionPerformed(ActionEvent e) {
            this.addTcxFileFilter();
            JFileChooser fc = OpenAction.createAndOpenFileChooser((boolean)true, (boolean)true, null);
            if (fc == null) {
                return;
            }
            File[] files = fc.getSelectedFiles();
            try {
                for (int i = files.length; i > 0; --i) {
                    this.openFileAsTcx(files[i - 1]);
                }
            }
            catch (IOException e1) {
                throw new RuntimeException(e1);
            }
        }

        private void openFileAsTcx(File file) throws IOException {
            String fn = file.getName();
            if (fn.toLowerCase().endsWith(".tcx")) {
                TcxReader tcxReader = new TcxReader(file);
                GpxData gpxData = tcxReader.getGpxData();
                gpxData.storageFile = file;
                GpxLayer gpxLayer = new GpxLayer(gpxData, fn);
                Main.main.addLayer((Layer)gpxLayer);
                if (Main.pref.getBoolean("marker.makeautomarkers", true)) {
                    MarkerLayer ml = new MarkerLayer(gpxData, I18n.tr((String)"Markers from {0}", (Object[])new Object[]{fn}), file, gpxLayer);
                    if (ml.data.size() > 0) {
                        Main.main.addLayer((Layer)ml);
                    }
                }
            } else {
                throw new IllegalStateException();
            }
        }
    }
}

