/*
 * Decompiled with CFR 0.152.
 */
package UtilsPlugin;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.CollectBackReferencesVisitor;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplifyWayAction
extends JosmAction {
    public static double EARTH_RAD = 6378137.0;

    public SimplifyWayAction() {
        super(I18n.tr((String)"Simplify Way"), "simplify", I18n.tr((String)"Delete unnecessary nodes from a way."), 89, 3, true);
    }

    public void actionPerformed(ActionEvent e) {
        int option;
        Collection selection = Main.ds.getSelected();
        int ways = 0;
        LinkedList<Bounds> bounds = new LinkedList<Bounds>();
        OsmDataLayer dataLayer = Main.main.editLayer();
        for (DataSource ds : dataLayer.data.dataSources) {
            bounds.add(ds.bounds);
        }
        for (OsmPrimitive prim : selection) {
            if (!(prim instanceof Way)) continue;
            Way way = (Way)prim;
            for (Node node : way.nodes) {
                boolean isInsideOneBoundingBox = false;
                for (Bounds b : bounds) {
                    if (!b.contains(node.coor)) continue;
                    isInsideOneBoundingBox = true;
                    break;
                }
                if (isInsideOneBoundingBox) continue;
                int option2 = JOptionPane.showConfirmDialog(Main.parent, I18n.tr((String)"The selected way(s) have nodes outside of the downloaded data region.This can lead to nodes beeing deleted accidentially.\nAre you really sure to continue?"), I18n.tr((String)"Plase abort if you are not sure"), 1, 2);
                if (option2 == 0) break;
                return;
            }
            ++ways;
        }
        if (ways == 0) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please select at least one way to simplify."));
            return;
        }
        if (ways > 10 && (option = JOptionPane.showConfirmDialog(Main.parent, I18n.tr((String)"The selection contains {0} ways. Are you sure you want to simplify them all?", (Object[])new Object[]{ways}), I18n.tr((String)"Are you sure?"), 0)) != 0) {
            return;
        }
        for (OsmPrimitive prim : selection) {
            if (!(prim instanceof Way)) continue;
            this.simplifyWay((Way)prim);
        }
    }

    public void simplifyWay(Way w) {
        double threshold = Double.parseDouble(Main.pref.get("simplify-way.max-error", "3"));
        Way wnew = new Way(w);
        int toI = wnew.nodes.size() - 1;
        for (int i = wnew.nodes.size() - 1; i >= 0; --i) {
            CollectBackReferencesVisitor backRefsV = new CollectBackReferencesVisitor(Main.ds, false);
            backRefsV.visit((Node)wnew.nodes.get(i));
            boolean used = false;
            if (backRefsV.data.size() == 1) {
                used = Collections.frequency(w.nodes, wnew.nodes.get(i)) > 1;
            } else {
                backRefsV.data.remove(w);
                boolean bl = used = !backRefsV.data.isEmpty();
            }
            if (!used) {
                used = ((Node)wnew.nodes.get((int)i)).tagged;
            }
            if (!used) continue;
            this.simplifyWayRange(wnew, i, toI, threshold);
            toI = i;
        }
        this.simplifyWayRange(wnew, 0, toI, threshold);
        HashSet delNodes = new HashSet();
        delNodes.addAll(w.nodes);
        delNodes.removeAll(wnew.nodes);
        if (wnew.nodes.size() != w.nodes.size()) {
            LinkedList<Object> cmds = new LinkedList<Object>();
            cmds.add(new ChangeCommand((OsmPrimitive)w, (OsmPrimitive)wnew));
            cmds.add(new DeleteCommand(delNodes));
            Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Simplify Way (remove {0} nodes)", (Object[])new Object[]{delNodes.size()}), cmds));
            Main.map.repaint();
        }
    }

    public void simplifyWayRange(Way wnew, int from, int to, double thr) {
        if (to - from >= 2) {
            ArrayList<Node> ns = new ArrayList<Node>();
            this.simplifyWayRange(wnew, from, to, ns, thr);
            for (int j = to - 1; j > from; --j) {
                wnew.nodes.remove(j);
            }
            wnew.nodes.addAll(from + 1, ns);
        }
    }

    public void simplifyWayRange(Way wnew, int from, int to, ArrayList<Node> ns, double thr) {
        Node fromN = (Node)wnew.nodes.get(from);
        Node toN = (Node)wnew.nodes.get(to);
        int imax = -1;
        double xtemax = 0.0;
        for (int i = from + 1; i < to; ++i) {
            Node n = (Node)wnew.nodes.get(i);
            double xte = Math.abs(EARTH_RAD * SimplifyWayAction.xtd(fromN.coor.lat() * Math.PI / 180.0, fromN.coor.lon() * Math.PI / 180.0, toN.coor.lat() * Math.PI / 180.0, toN.coor.lon() * Math.PI / 180.0, n.coor.lat() * Math.PI / 180.0, n.coor.lon() * Math.PI / 180.0));
            if (!(xte > xtemax)) continue;
            xtemax = xte;
            imax = i;
        }
        if (imax != -1 && xtemax >= thr) {
            this.simplifyWayRange(wnew, from, imax, ns, thr);
            ns.add((Node)wnew.nodes.get(imax));
            this.simplifyWayRange(wnew, imax, to, ns, thr);
        }
    }

    public static double dist(double lat1, double lon1, double lat2, double lon2) {
        return 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin((lat1 - lat2) / 2.0), 2.0) + Math.cos(lat1) * Math.cos(lat2) * Math.pow(Math.sin((lon1 - lon2) / 2.0), 2.0)));
    }

    public static double course(double lat1, double lon1, double lat2, double lon2) {
        return Math.atan2(Math.sin(lon1 - lon2) * Math.cos(lat2), Math.cos(lat1) * Math.sin(lat2) - Math.sin(lat1) * Math.cos(lat2) * Math.cos(lon1 - lon2)) % (Math.PI * 2);
    }

    public static double xtd(double lat1, double lon1, double lat2, double lon2, double lat3, double lon3) {
        double dist_AD = SimplifyWayAction.dist(lat1, lon1, lat3, lon3);
        double crs_AD = SimplifyWayAction.course(lat1, lon1, lat3, lon3);
        double crs_AB = SimplifyWayAction.course(lat1, lon1, lat2, lon2);
        return Math.asin(Math.sin(dist_AD) * Math.sin(crs_AD - crs_AB));
    }
}

