/*
 * Decompiled with CFR 0.152.
 */
package wmsplugin;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.imageio.ImageIO;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.gui.NavigatableComponent;

public class GeorefImage
implements Serializable {
    public BufferedImage image = null;
    public EastNorth min;
    public EastNorth max;
    public boolean downloadingStarted;

    public GeorefImage(boolean downloadingStarted) {
        this.downloadingStarted = downloadingStarted;
    }

    public void displace(double dx, double dy) {
        this.min = new EastNorth(this.min.east() + dx, this.min.north() + dy);
        this.max = new EastNorth(this.max.east() + dx, this.max.north() + dy);
    }

    public boolean contains(EastNorth en) {
        return this.min.east() <= en.east() && en.east() <= this.max.east() && this.min.north() <= en.north() && en.north() <= this.max.north();
    }

    public boolean isVisible(NavigatableComponent nc) {
        Point minPt = nc.getPoint(this.min);
        Point maxPt = nc.getPoint(this.max);
        Graphics g = nc.getGraphics();
        return g.hitClip(minPt.x, maxPt.y, maxPt.x - minPt.x, minPt.y - maxPt.y);
    }

    public boolean paint(Graphics g, NavigatableComponent nc) {
        if (this.image == null || this.min == null || this.max == null) {
            return false;
        }
        Point minPt = nc.getPoint(this.min);
        Point maxPt = nc.getPoint(this.max);
        if (!this.isVisible(nc)) {
            return false;
        }
        g.drawImage(this.image, minPt.x, maxPt.y, maxPt.x, minPt.y, 0, 0, this.image.getWidth(), this.image.getHeight(), null);
        return true;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.max = (EastNorth)in.readObject();
        this.min = (EastNorth)in.readObject();
        this.image = ImageIO.read(ImageIO.createImageInputStream(in));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.max);
        out.writeObject(this.min);
        if (this.image == null) {
            out.writeObject(null);
        } else {
            ImageIO.write((RenderedImage)this.image, "png", ImageIO.createImageOutputStream(out));
        }
    }
}

