/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.util.Arrays;
import java.util.Collections;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.tools.I18n;

public class DuplicatedWayNodes
extends Test {
    protected static int DUPLICATE_WAY_NODE = 501;

    public DuplicatedWayNodes() {
        super(I18n.tr((String)"Duplicated way nodes."), I18n.tr((String)"Checks for ways with identical consecutive nodes."));
    }

    public void visit(Way w) {
        if (w.deleted || w.incomplete) {
            return;
        }
        Node lastN = null;
        for (Node n : w.nodes) {
            if (lastN == null) {
                lastN = n;
                continue;
            }
            if (lastN == n) {
                this.errors.add(new TestError(this, Severity.ERROR, I18n.tr((String)"Duplicated way nodes"), DUPLICATE_WAY_NODE, Arrays.asList(w), Arrays.asList(n)));
                break;
            }
            lastN = n;
        }
    }

    public Command fixError(TestError testError) {
        Way w = (Way)testError.getPrimitives().iterator().next();
        Way wnew = new Way(w);
        wnew.nodes.clear();
        Node lastN = null;
        for (Node n : w.nodes) {
            if (lastN == null) {
                wnew.nodes.add(n);
            } else if (n != lastN) {
                wnew.nodes.add(n);
            }
            lastN = n;
        }
        if (wnew.nodes.size() < 2) {
            return new DeleteCommand(Collections.singleton(w));
        }
        return new ChangeCommand((OsmPrimitive)w, (OsmPrimitive)wnew);
    }

    public boolean isFixable(TestError testError) {
        return testError.getTester() instanceof DuplicatedWayNodes;
    }
}

