/*
 * Decompiled with CFR 0.152.
 */
package wmsplugin;

import java.io.IOException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.tools.I18n;
import wmsplugin.WMSLayer;

public class DownloadWMSTask
extends PleaseWaitRunnable {
    private WMSLayer wmsLayer;
    private Bounds bounds;
    private double pixelPerDegree;

    public DownloadWMSTask(WMSLayer wmsLayer, Bounds bounds, double pixelPerDegree) {
        super(I18n.tr((String)"Downloading {0}", (Object[])new Object[]{wmsLayer.name}));
        this.wmsLayer = wmsLayer;
        this.bounds = bounds;
        this.pixelPerDegree = pixelPerDegree;
    }

    public void realRun() throws IOException {
        Main.pleaseWaitDlg.currentAction.setText(I18n.tr((String)"Contacting WMS Server..."));
        this.wmsLayer.grab(this.bounds, this.pixelPerDegree);
    }

    protected void cancel() {
    }

    protected void finish() {
    }

    public static void download(WMSLayer wmsLayer) {
        MapView mv = Main.map.mapView;
        Bounds b = new Bounds(mv.getLatLon(0, mv.getHeight()), mv.getLatLon(mv.getWidth(), 0));
        Main.worker.execute((Runnable)((Object)new DownloadWMSTask(wmsLayer, b, (double)mv.getWidth() / (b.max.lon() - b.min.lon()))));
    }
}

