/*
 * Decompiled with CFR 0.152.
 */
package uk.me.jstott.jcoord;

import uk.me.jstott.jcoord.LatLng;
import uk.me.jstott.jcoord.RefEll;
import uk.me.jstott.jcoord.Util;

public class OSRef {
    private double easting;
    private double northing;

    public OSRef(double easting, double northing) {
        this.easting = easting;
        this.northing = northing;
    }

    public OSRef(String ref) throws IllegalArgumentException {
        char char1 = ref.charAt(0);
        int char2 = ref.charAt(1);
        int east = Integer.parseInt(ref.substring(2, 5)) * 100;
        int north = Integer.parseInt(ref.substring(5, 8)) * 100;
        if (char1 == 'H') {
            north += 1000000;
        } else if (char1 == 'N') {
            north += 500000;
        } else if (char1 == 'O') {
            north += 500000;
            east += 500000;
        } else if (char1 == 'T') {
            east += 500000;
        }
        int char2ord = char2;
        if (char2ord > 73) {
            --char2ord;
        }
        double nx = (char2ord - 65) % 5 * 100000;
        double ny = (4.0 - Math.floor((char2ord - 65) / 5)) * 100000.0;
        this.easting = (double)east + nx;
        this.northing = (double)north + ny;
    }

    public String toString() {
        return "(" + this.easting + ", " + this.northing + ")";
    }

    public String toSixFigureString() {
        int hundredkmE = (int)Math.floor(this.easting / 100000.0);
        int hundredkmN = (int)Math.floor(this.northing / 100000.0);
        String firstLetter = hundredkmN < 5 ? (hundredkmE < 5 ? "S" : "T") : (hundredkmN < 10 ? (hundredkmE < 5 ? "N" : "O") : "H");
        int index = 65 + (4 - hundredkmN % 5) * 5 + hundredkmE % 5;
        if (index >= 73) {
            ++index;
        }
        String secondLetter = Character.toString((char)index);
        int e = (int)Math.floor((this.easting - (double)(100000 * hundredkmE)) / 100.0);
        int n = (int)Math.floor((this.northing - (double)(100000 * hundredkmN)) / 100.0);
        String es = "" + e;
        if (e < 100) {
            es = "0" + es;
        }
        if (e < 10) {
            es = "0" + es;
        }
        String ns = "" + n;
        if (n < 100) {
            ns = "0" + ns;
        }
        if (n < 10) {
            ns = "0" + ns;
        }
        return firstLetter + secondLetter + es + ns;
    }

    public LatLng toLatLng() {
        double OSGB_F0 = 0.9996012717;
        double N0 = -100000.0;
        double E0 = 400000.0;
        double phi0 = Math.toRadians(49.0);
        double lambda0 = Math.toRadians(-2.0);
        double a = RefEll.AIRY_1830.getMaj();
        double b = RefEll.AIRY_1830.getMin();
        double eSquared = RefEll.AIRY_1830.getEcc();
        double phi = 0.0;
        double lambda = 0.0;
        double E = this.easting;
        double N = this.northing;
        double n = (a - b) / (a + b);
        double M = 0.0;
        double phiPrime = (N - N0) / (a * OSGB_F0) + phi0;
        do {
            M = b * OSGB_F0 * ((1.0 + n + 1.25 * n * n + 1.25 * n * n * n) * (phiPrime - phi0) - (3.0 * n + 3.0 * n * n + 2.625 * n * n * n) * Math.sin(phiPrime - phi0) * Math.cos(phiPrime + phi0) + (1.875 * n * n + 1.875 * n * n * n) * Math.sin(2.0 * (phiPrime - phi0)) * Math.cos(2.0 * (phiPrime + phi0)) - 1.4583333333333333 * n * n * n * Math.sin(3.0 * (phiPrime - phi0)) * Math.cos(3.0 * (phiPrime + phi0)));
            phiPrime += (N - N0 - M) / (a * OSGB_F0);
        } while (N - N0 - M >= 0.001);
        double v = a * OSGB_F0 * Math.pow(1.0 - eSquared * Util.sinSquared(phiPrime), -0.5);
        double rho = a * OSGB_F0 * (1.0 - eSquared) * Math.pow(1.0 - eSquared * Util.sinSquared(phiPrime), -1.5);
        double etaSquared = v / rho - 1.0;
        double VII = Math.tan(phiPrime) / (2.0 * rho * v);
        double VIII = Math.tan(phiPrime) / (24.0 * rho * Math.pow(v, 3.0)) * (5.0 + 3.0 * Util.tanSquared(phiPrime) + etaSquared - 9.0 * Util.tanSquared(phiPrime) * etaSquared);
        double IX = Math.tan(phiPrime) / (720.0 * rho * Math.pow(v, 5.0)) * (61.0 + 90.0 * Util.tanSquared(phiPrime) + 45.0 * Util.tanSquared(phiPrime) * Util.tanSquared(phiPrime));
        double X = Util.sec(phiPrime) / v;
        double XI = Util.sec(phiPrime) / (6.0 * v * v * v) * (v / rho + 2.0 * Util.tanSquared(phiPrime));
        double XII = Util.sec(phiPrime) / (120.0 * Math.pow(v, 5.0)) * (5.0 + 28.0 * Util.tanSquared(phiPrime) + 24.0 * Util.tanSquared(phiPrime) * Util.tanSquared(phiPrime));
        double XIIA = Util.sec(phiPrime) / (5040.0 * Math.pow(v, 7.0)) * (61.0 + 662.0 * Util.tanSquared(phiPrime) + 1320.0 * Util.tanSquared(phiPrime) * Util.tanSquared(phiPrime) + 720.0 * Util.tanSquared(phiPrime) * Util.tanSquared(phiPrime) * Util.tanSquared(phiPrime));
        phi = phiPrime - VII * Math.pow(E - E0, 2.0) + VIII * Math.pow(E - E0, 4.0) - IX * Math.pow(E - E0, 6.0);
        lambda = lambda0 + X * (E - E0) - XI * Math.pow(E - E0, 3.0) + XII * Math.pow(E - E0, 5.0) - XIIA * Math.pow(E - E0, 7.0);
        return new LatLng(Math.toDegrees(phi), Math.toDegrees(lambda));
    }

    public double getEasting() {
        return this.easting;
    }

    public double getNorthing() {
        return this.northing;
    }
}

