/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.javacc.parser.CodeGenerator;
import org.javacc.parser.JavaCCErrors;
import org.javacc.parser.LexGen;
import org.javacc.parser.Options;

public class NfaState {
    public static boolean unicodeWarningGiven = false;
    public static int generatedStates = 0;
    private static int idCnt = 0;
    private static int lohiByteCnt;
    private static int dummyStateIndex;
    private static boolean done;
    private static boolean[] mark;
    private static boolean[] stateDone;
    private static List allStates;
    private static List indexedAllStates;
    private static List nonAsciiTableForMethod;
    private static Hashtable equivStatesTable;
    private static Hashtable allNextStates;
    private static Hashtable lohiByteTab;
    private static Hashtable stateNameForComposite;
    private static Hashtable compositeStateTable;
    private static Hashtable stateBlockTable;
    private static Hashtable stateSetsToFix;
    private static boolean jjCheckNAddStatesUnaryNeeded;
    private static boolean jjCheckNAddStatesDualNeeded;
    long[] asciiMoves = new long[2];
    char[] charMoves = null;
    private char[] rangeMoves = null;
    NfaState next = null;
    private NfaState stateForCase;
    Vector epsilonMoves = new Vector();
    private String epsilonMovesString;
    private NfaState[] epsilonMoveArray;
    private int id;
    int stateName = -1;
    int kind = Integer.MAX_VALUE;
    private int lookingFor;
    private int usefulEpsilonMoves = 0;
    int inNextOf;
    private int lexState;
    private int nonAsciiMethod = -1;
    private int kindToPrint = Integer.MAX_VALUE;
    boolean dummy = false;
    private boolean isComposite = false;
    private int[] compositeStates = null;
    boolean isFinal = false;
    private Vector loByteVec;
    private int[] nonAsciiMoveIndices;
    private int round = 0;
    private int onlyChar = 0;
    private char matchSingleChar;
    private boolean closureDone = false;
    static List allBitVectors;
    static int[] tmpIndices;
    static String allBits;
    static Hashtable tableToDump;
    static List orderedStateSet;
    static int lastIndex;
    static int[][] kinds;
    static int[][][] statesForState;

    public static void ReInit() {
        generatedStates = 0;
        idCnt = 0;
        dummyStateIndex = -1;
        done = false;
        mark = null;
        stateDone = null;
        allStates.clear();
        indexedAllStates.clear();
        equivStatesTable.clear();
        allNextStates.clear();
        compositeStateTable.clear();
        stateBlockTable.clear();
        stateNameForComposite.clear();
        stateSetsToFix.clear();
    }

    NfaState() {
        this.id = idCnt++;
        allStates.add(this);
        this.lexState = LexGen.lexStateIndex;
        this.lookingFor = LexGen.curKind;
    }

    NfaState CreateClone() {
        NfaState retVal = new NfaState();
        retVal.isFinal = this.isFinal;
        retVal.kind = this.kind;
        retVal.lookingFor = this.lookingFor;
        retVal.lexState = this.lexState;
        retVal.inNextOf = this.inNextOf;
        retVal.MergeMoves(this);
        return retVal;
    }

    static void InsertInOrder(List v, NfaState s) {
        int j;
        for (j = 0; j < v.size() && ((NfaState)v.get((int)j)).id <= s.id; ++j) {
            if (((NfaState)v.get((int)j)).id != s.id) continue;
            return;
        }
        v.add(j, s);
    }

    private static char[] ExpandCharArr(char[] oldArr, int incr) {
        char[] ret = new char[oldArr.length + incr];
        System.arraycopy(oldArr, 0, ret, 0, oldArr.length);
        return ret;
    }

    void AddMove(NfaState newState) {
        if (!this.epsilonMoves.contains(newState)) {
            NfaState.InsertInOrder(this.epsilonMoves, newState);
        }
    }

    private final void AddASCIIMove(char c) {
        int n = c / 64;
        this.asciiMoves[n] = this.asciiMoves[n] | 1L << c % 64;
    }

    void AddChar(char c) {
        int i;
        int len;
        ++this.onlyChar;
        this.matchSingleChar = c;
        if (c < '\u0080') {
            this.AddASCIIMove(c);
            return;
        }
        if (this.charMoves == null) {
            this.charMoves = new char[10];
        }
        if (this.charMoves[(len = this.charMoves.length) - 1] != '\u0000') {
            this.charMoves = NfaState.ExpandCharArr(this.charMoves, 10);
            len += 10;
        }
        for (i = 0; i < len && this.charMoves[i] != '\u0000' && this.charMoves[i] <= c; ++i) {
        }
        if (!(unicodeWarningGiven || c <= '\u00ff' || Options.isUnicodeEnabled() || Options.getUserCharStream())) {
            unicodeWarningGiven = true;
            JavaCCErrors.warning(LexGen.curRE, "Non-ASCII characters used in regular expression.\nPlease make sure you use the correct Reader when you create the parser, one that can handle your character set.");
        }
        char temp = this.charMoves[i];
        this.charMoves[i] = c;
        ++i;
        while (i < len && temp != '\u0000') {
            char temp1 = this.charMoves[i];
            this.charMoves[i] = temp;
            temp = temp1;
            ++i;
        }
    }

    void AddRange(char left, char right) {
        int i;
        int len;
        this.onlyChar = 2;
        if (left < '\u0080') {
            if (right < '\u0080') {
                while (left <= right) {
                    this.AddASCIIMove(left);
                    left = (char)(left + '\u0001');
                }
                return;
            }
            while (left < '\u0080') {
                this.AddASCIIMove(left);
                left = (char)(left + '\u0001');
            }
        }
        if (!(unicodeWarningGiven || left <= '\u00ff' && right <= '\u00ff' || Options.isUnicodeEnabled() || Options.getUserCharStream())) {
            unicodeWarningGiven = true;
            JavaCCErrors.warning(LexGen.curRE, "Non-ASCII characters used in regular expression.\nPlease make sure you use the correct Reader when you create the parser, one that can handle your character set.");
        }
        if (this.rangeMoves == null) {
            this.rangeMoves = new char[20];
        }
        if (this.rangeMoves[(len = this.rangeMoves.length) - 1] != '\u0000') {
            this.rangeMoves = NfaState.ExpandCharArr(this.rangeMoves, 20);
            len += 20;
        }
        for (i = 0; i < len && this.rangeMoves[i] != '\u0000' && this.rangeMoves[i] <= left && (this.rangeMoves[i] != left || this.rangeMoves[i + 1] <= right); i += 2) {
        }
        char tempLeft1 = this.rangeMoves[i];
        char tempRight1 = this.rangeMoves[i + 1];
        this.rangeMoves[i] = left;
        this.rangeMoves[i + 1] = right;
        i += 2;
        while (i < len && tempLeft1 != '\u0000') {
            char tempLeft2 = this.rangeMoves[i];
            char tempRight2 = this.rangeMoves[i + 1];
            this.rangeMoves[i] = tempLeft1;
            this.rangeMoves[i + 1] = tempRight1;
            tempLeft1 = tempLeft2;
            tempRight1 = tempRight2;
            i += 2;
        }
    }

    private static boolean EqualCharArr(char[] arr1, char[] arr2) {
        if (arr1 == arr2) {
            return true;
        }
        if (arr1 != null && arr2 != null && arr1.length == arr2.length) {
            int i = arr1.length;
            while (i-- > 0) {
                if (arr1[i] == arr2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void EpsilonClosure() {
        int i = 0;
        if (this.closureDone || mark[this.id]) {
            return;
        }
        NfaState.mark[this.id] = true;
        for (i = 0; i < this.epsilonMoves.size(); ++i) {
            ((NfaState)this.epsilonMoves.get(i)).EpsilonClosure();
        }
        Enumeration e = this.epsilonMoves.elements();
        while (e.hasMoreElements()) {
            NfaState tmp = (NfaState)e.nextElement();
            for (i = 0; i < tmp.epsilonMoves.size(); ++i) {
                NfaState tmp1 = (NfaState)tmp.epsilonMoves.get(i);
                if (!tmp1.UsefulState() || this.epsilonMoves.contains(tmp1)) continue;
                NfaState.InsertInOrder(this.epsilonMoves, tmp1);
                done = false;
            }
            if (this.kind <= tmp.kind) continue;
            this.kind = tmp.kind;
        }
        if (this.HasTransitions() && !this.epsilonMoves.contains(this)) {
            NfaState.InsertInOrder(this.epsilonMoves, this);
        }
    }

    private boolean UsefulState() {
        return this.isFinal || this.HasTransitions();
    }

    public boolean HasTransitions() {
        return this.asciiMoves[0] != 0L || this.asciiMoves[1] != 0L || this.charMoves != null && this.charMoves[0] != '\u0000' || this.rangeMoves != null && this.rangeMoves[0] != '\u0000';
    }

    void MergeMoves(NfaState other) {
        int i;
        if (this.asciiMoves == other.asciiMoves) {
            JavaCCErrors.semantic_error("Bug in JavaCC : Please send a report along with the input that caused this. Thank you.");
            throw new Error();
        }
        this.asciiMoves[0] = this.asciiMoves[0] | other.asciiMoves[0];
        this.asciiMoves[1] = this.asciiMoves[1] | other.asciiMoves[1];
        if (other.charMoves != null) {
            if (this.charMoves == null) {
                this.charMoves = other.charMoves;
            } else {
                char[] tmpCharMoves = new char[this.charMoves.length + other.charMoves.length];
                System.arraycopy(this.charMoves, 0, tmpCharMoves, 0, this.charMoves.length);
                this.charMoves = tmpCharMoves;
                for (i = 0; i < other.charMoves.length; ++i) {
                    this.AddChar(other.charMoves[i]);
                }
            }
        }
        if (other.rangeMoves != null) {
            if (this.rangeMoves == null) {
                this.rangeMoves = other.rangeMoves;
            } else {
                char[] tmpRangeMoves = new char[this.rangeMoves.length + other.rangeMoves.length];
                System.arraycopy(this.rangeMoves, 0, tmpRangeMoves, 0, this.rangeMoves.length);
                this.rangeMoves = tmpRangeMoves;
                for (i = 0; i < other.rangeMoves.length; i += 2) {
                    this.AddRange(other.rangeMoves[i], other.rangeMoves[i + 1]);
                }
            }
        }
        if (other.kind < this.kind) {
            this.kind = other.kind;
        }
        if (other.kindToPrint < this.kindToPrint) {
            this.kindToPrint = other.kindToPrint;
        }
        this.isFinal |= other.isFinal;
    }

    NfaState CreateEquivState(List states) {
        NfaState newState = ((NfaState)states.get(0)).CreateClone();
        newState.next = new NfaState();
        NfaState.InsertInOrder(newState.next.epsilonMoves, ((NfaState)states.get((int)0)).next);
        for (int i = 1; i < states.size(); ++i) {
            NfaState tmp2 = (NfaState)states.get(i);
            if (tmp2.kind < newState.kind) {
                newState.kind = tmp2.kind;
            }
            newState.isFinal |= tmp2.isFinal;
            NfaState.InsertInOrder(newState.next.epsilonMoves, tmp2.next);
        }
        return newState;
    }

    private NfaState GetEquivalentRunTimeState() {
        int i = allStates.size();
        block0: while (i-- > 0) {
            NfaState other = (NfaState)allStates.get(i);
            if (this == other || other.stateName == -1 || this.kindToPrint != other.kindToPrint || this.asciiMoves[0] != other.asciiMoves[0] || this.asciiMoves[1] != other.asciiMoves[1] || !NfaState.EqualCharArr(this.charMoves, other.charMoves) || !NfaState.EqualCharArr(this.rangeMoves, other.rangeMoves)) continue;
            if (this.next == other.next) {
                return other;
            }
            if (this.next == null || other.next == null || this.next.epsilonMoves.size() != other.next.epsilonMoves.size()) continue;
            for (int j = 0; j < this.next.epsilonMoves.size(); ++j) {
                if (this.next.epsilonMoves.get(j) != other.next.epsilonMoves.get(j)) continue block0;
            }
            return other;
        }
        return null;
    }

    void GenerateCode() {
        if (this.stateName != -1) {
            return;
        }
        if (this.next != null) {
            this.next.GenerateCode();
            if (this.next.kind != Integer.MAX_VALUE) {
                this.kindToPrint = this.next.kind;
            }
        }
        if (this.stateName == -1 && this.HasTransitions()) {
            NfaState tmp = this.GetEquivalentRunTimeState();
            if (tmp != null) {
                this.stateName = tmp.stateName;
                this.dummy = true;
                return;
            }
            this.stateName = generatedStates++;
            indexedAllStates.add(this);
            this.GenerateNextStatesCode();
        }
    }

    public static void ComputeClosures() {
        NfaState tmp;
        int i = allStates.size();
        while (i-- > 0) {
            tmp = (NfaState)allStates.get(i);
            if (tmp.closureDone) continue;
            tmp.OptimizeEpsilonMoves(true);
        }
        for (i = 0; i < allStates.size(); ++i) {
            tmp = (NfaState)allStates.get(i);
            if (tmp.closureDone) continue;
            tmp.OptimizeEpsilonMoves(false);
        }
        for (i = 0; i < allStates.size(); ++i) {
            tmp = (NfaState)allStates.get(i);
            tmp.epsilonMoveArray = new NfaState[tmp.epsilonMoves.size()];
            tmp.epsilonMoves.copyInto(tmp.epsilonMoveArray);
        }
    }

    void OptimizeEpsilonMoves(boolean optReqd) {
        int i;
        done = false;
        while (!done) {
            if (mark == null || mark.length < allStates.size()) {
                mark = new boolean[allStates.size()];
            }
            i = allStates.size();
            while (i-- > 0) {
                NfaState.mark[i] = false;
            }
            done = true;
            this.EpsilonClosure();
        }
        i = allStates.size();
        while (i-- > 0) {
            ((NfaState)NfaState.allStates.get((int)i)).closureDone = mark[((NfaState)NfaState.allStates.get((int)i)).id];
        }
        boolean sometingOptimized = true;
        NfaState newState = null;
        ArrayList<NfaState> equivStates = null;
        while (sometingOptimized) {
            NfaState tmp2;
            int j;
            NfaState tmp1;
            sometingOptimized = false;
            for (i = 0; optReqd && i < this.epsilonMoves.size(); ++i) {
                tmp1 = (NfaState)this.epsilonMoves.get(i);
                if (tmp1.HasTransitions()) {
                    for (j = i + 1; j < this.epsilonMoves.size(); ++j) {
                        tmp2 = (NfaState)this.epsilonMoves.get(j);
                        if (!tmp2.HasTransitions() || tmp1.asciiMoves[0] != tmp2.asciiMoves[0] || tmp1.asciiMoves[1] != tmp2.asciiMoves[1] || !NfaState.EqualCharArr(tmp1.charMoves, tmp2.charMoves) || !NfaState.EqualCharArr(tmp1.rangeMoves, tmp2.rangeMoves)) continue;
                        if (equivStates == null) {
                            equivStates = new ArrayList<NfaState>();
                            equivStates.add(tmp1);
                        }
                        NfaState.InsertInOrder(equivStates, tmp2);
                        this.epsilonMoves.removeElementAt(j--);
                    }
                }
                if (equivStates == null) continue;
                sometingOptimized = true;
                String tmp = "";
                for (int l = 0; l < equivStates.size(); ++l) {
                    tmp = tmp + String.valueOf(((NfaState)equivStates.get((int)l)).id) + ", ";
                }
                newState = (NfaState)equivStatesTable.get(tmp);
                if (newState == null) {
                    newState = this.CreateEquivState(equivStates);
                    equivStatesTable.put(tmp, newState);
                }
                this.epsilonMoves.removeElementAt(i--);
                this.epsilonMoves.add(newState);
                equivStates = null;
                newState = null;
            }
            for (i = 0; i < this.epsilonMoves.size(); ++i) {
                tmp1 = (NfaState)this.epsilonMoves.get(i);
                for (j = i + 1; j < this.epsilonMoves.size(); ++j) {
                    tmp2 = (NfaState)this.epsilonMoves.get(j);
                    if (tmp1.next != tmp2.next) continue;
                    if (newState == null) {
                        newState = tmp1.CreateClone();
                        newState.next = tmp1.next;
                        sometingOptimized = true;
                    }
                    newState.MergeMoves(tmp2);
                    this.epsilonMoves.removeElementAt(j--);
                }
                if (newState == null) continue;
                this.epsilonMoves.removeElementAt(i--);
                this.epsilonMoves.add(newState);
                newState = null;
            }
        }
        if (this.epsilonMoves.size() > 0) {
            for (i = 0; i < this.epsilonMoves.size(); ++i) {
                if (((NfaState)this.epsilonMoves.get(i)).HasTransitions()) {
                    ++this.usefulEpsilonMoves;
                    continue;
                }
                this.epsilonMoves.removeElementAt(i--);
            }
        }
    }

    void GenerateNextStatesCode() {
        if (this.next.usefulEpsilonMoves > 0) {
            this.next.GetEpsilonMovesString();
        }
    }

    String GetEpsilonMovesString() {
        int[] stateNames = new int[this.usefulEpsilonMoves];
        int cnt = 0;
        if (this.epsilonMovesString != null) {
            return this.epsilonMovesString;
        }
        if (this.usefulEpsilonMoves > 0) {
            this.epsilonMovesString = "{ ";
            for (int i = 0; i < this.epsilonMoves.size(); ++i) {
                NfaState tempState = (NfaState)this.epsilonMoves.get(i);
                if (!tempState.HasTransitions()) continue;
                if (tempState.stateName == -1) {
                    tempState.GenerateCode();
                }
                ++((NfaState)NfaState.indexedAllStates.get((int)tempState.stateName)).inNextOf;
                stateNames[cnt] = tempState.stateName;
                this.epsilonMovesString = this.epsilonMovesString + tempState.stateName + ", ";
                if (cnt++ <= 0 || cnt % 16 != 0) continue;
                this.epsilonMovesString = this.epsilonMovesString + "\n";
            }
            this.epsilonMovesString = this.epsilonMovesString + "};";
        }
        this.usefulEpsilonMoves = cnt;
        if (this.epsilonMovesString != null && allNextStates.get(this.epsilonMovesString) == null) {
            int[] statesToPut = new int[this.usefulEpsilonMoves];
            System.arraycopy(stateNames, 0, statesToPut, 0, cnt);
            allNextStates.put(this.epsilonMovesString, statesToPut);
        }
        return this.epsilonMovesString;
    }

    public static boolean CanStartNfaUsingAscii(char c) {
        if (c >= '\u0080') {
            throw new Error("JavaCC Bug: Please send mail to sankar@cs.stanford.edu");
        }
        String s = LexGen.initialState.GetEpsilonMovesString();
        if (s == null || s.equals("null;")) {
            return false;
        }
        int[] states = (int[])allNextStates.get(s);
        for (int i = 0; i < states.length; ++i) {
            NfaState tmp = (NfaState)indexedAllStates.get(states[i]);
            if ((tmp.asciiMoves[c / 64] & 1L << c % 64) == 0L) continue;
            return true;
        }
        return false;
    }

    final boolean CanMoveUsingChar(char c) {
        int i;
        if (this.onlyChar == 1) {
            return c == this.matchSingleChar;
        }
        if (c < '\u0080') {
            return (this.asciiMoves[c / 64] & 1L << c % 64) != 0L;
        }
        if (this.charMoves != null && this.charMoves[0] != '\u0000') {
            for (i = 0; i < this.charMoves.length; ++i) {
                if (c == this.charMoves[i]) {
                    return true;
                }
                if (c < this.charMoves[i] || this.charMoves[i] == '\u0000') break;
            }
        }
        if (this.rangeMoves != null && this.rangeMoves[0] != '\u0000') {
            for (i = 0; i < this.rangeMoves.length; i += 2) {
                if (c >= this.rangeMoves[i] && c <= this.rangeMoves[i + 1]) {
                    return true;
                }
                if (c < this.rangeMoves[i] || this.rangeMoves[i] == '\u0000') break;
            }
        }
        return false;
    }

    public int getFirstValidPos(String s, int i, int len) {
        if (this.onlyChar == 1) {
            char c = this.matchSingleChar;
            while (c != s.charAt(i) && ++i < len) {
            }
            return i;
        }
        do {
            if (!this.CanMoveUsingChar(s.charAt(i))) continue;
            return i;
        } while (++i < len);
        return i;
    }

    public int MoveFrom(char c, List newStates) {
        if (this.CanMoveUsingChar(c)) {
            int i = this.next.epsilonMoves.size();
            while (i-- > 0) {
                NfaState.InsertInOrder(newStates, (NfaState)this.next.epsilonMoves.get(i));
            }
            return this.kindToPrint;
        }
        return Integer.MAX_VALUE;
    }

    public static int MoveFromSet(char c, List states, List newStates) {
        int retVal = Integer.MAX_VALUE;
        int i = states.size();
        while (i-- > 0) {
            int tmp = ((NfaState)states.get(i)).MoveFrom(c, newStates);
            if (retVal <= tmp) continue;
            retVal = tmp;
        }
        return retVal;
    }

    public static int moveFromSetForRegEx(char c, NfaState[] states, NfaState[] newStates, int round) {
        int start = 0;
        for (NfaState tmp1 : states) {
            if (tmp1 == null) break;
            if (!tmp1.CanMoveUsingChar(c)) continue;
            if (tmp1.kindToPrint != Integer.MAX_VALUE) {
                newStates[start] = null;
                return 1;
            }
            NfaState[] v = tmp1.next.epsilonMoveArray;
            int j = v.length;
            while (j-- > 0) {
                NfaState tmp2 = v[j];
                if (tmp2.round == round) continue;
                tmp2.round = round;
                newStates[start++] = tmp2;
            }
        }
        newStates[start] = null;
        return Integer.MAX_VALUE;
    }

    void GenerateNonAsciiMoves(CodeGenerator codeGenerator) {
        char hiByte;
        int i = 0;
        int j = 0;
        int cnt = 0;
        long[][] loBytes = new long[256][4];
        if (!(this.charMoves != null && this.charMoves[0] != '\u0000' || this.rangeMoves != null && this.rangeMoves[0] != '\u0000')) {
            return;
        }
        if (this.charMoves != null) {
            for (i = 0; i < this.charMoves.length && this.charMoves[i] != '\u0000'; ++i) {
                hiByte = (char)(this.charMoves[i] >> 8);
                long[] lArray = loBytes[hiByte];
                int n = (this.charMoves[i] & 0xFF) / 64;
                lArray[n] = lArray[n] | 1L << (this.charMoves[i] & 0xFF) % 64;
            }
        }
        if (this.rangeMoves != null) {
            for (i = 0; i < this.rangeMoves.length && this.rangeMoves[i] != '\u0000'; i += 2) {
                char c;
                char r = (char)(this.rangeMoves[i + 1] & 0xFF);
                hiByte = (char)(this.rangeMoves[i] >> 8);
                if (hiByte == (char)(this.rangeMoves[i + 1] >> 8)) {
                    for (c = (char)(this.rangeMoves[i] & 0xFF); c <= r; c = (char)(c + '\u0001')) {
                        long[] lArray = loBytes[hiByte];
                        int n = c / 64;
                        lArray[n] = lArray[n] | 1L << c % 64;
                    }
                    continue;
                }
                for (c = (char)(this.rangeMoves[i] & 0xFF); c <= '\u00ff'; c = (char)(c + '\u0001')) {
                    long[] lArray = loBytes[hiByte];
                    int n = c / 64;
                    lArray[n] = lArray[n] | 1L << c % 64;
                }
                while ((hiByte = (char)(hiByte + '\u0001')) < (char)(this.rangeMoves[i + 1] >> 8)) {
                    long[] lArray = loBytes[hiByte];
                    lArray[0] = lArray[0] | 0xFFFFFFFFFFFFFFFFL;
                    long[] lArray2 = loBytes[hiByte];
                    lArray2[1] = lArray2[1] | 0xFFFFFFFFFFFFFFFFL;
                    long[] lArray3 = loBytes[hiByte];
                    lArray3[2] = lArray3[2] | 0xFFFFFFFFFFFFFFFFL;
                    long[] lArray4 = loBytes[hiByte];
                    lArray4[3] = lArray4[3] | 0xFFFFFFFFFFFFFFFFL;
                }
                for (c = '\u0000'; c <= r; c = (char)(c + '\u0001')) {
                    long[] lArray = loBytes[hiByte];
                    int n = c / 64;
                    lArray[n] = lArray[n] | 1L << c % 64;
                }
            }
        }
        long[] common = null;
        boolean[] done = new boolean[256];
        for (i = 0; i <= 255; ++i) {
            if (done[i] || (done[i] = loBytes[i][0] == 0L && loBytes[i][1] == 0L && loBytes[i][2] == 0L && loBytes[i][3] == 0L)) continue;
            for (j = i + 1; j < 256; ++j) {
                if (done[j] || loBytes[i][0] != loBytes[j][0] || loBytes[i][1] != loBytes[j][1] || loBytes[i][2] != loBytes[j][2] || loBytes[i][3] != loBytes[j][3]) continue;
                done[j] = true;
                if (common == null) {
                    done[i] = true;
                    common = new long[4];
                    int n = i / 64;
                    common[n] = common[n] | 1L << i % 64;
                }
                int n = j / 64;
                common[n] = common[n] | 1L << j % 64;
            }
            if (common == null) continue;
            String tmp = "{\n   0x" + Long.toHexString((long)common[0]) + "L, " + "0x" + Long.toHexString((long)common[1]) + "L, " + "0x" + Long.toHexString((long)common[2]) + "L, " + "0x" + Long.toHexString((long)common[3]) + "L\n};";
            Integer ind = (Integer)lohiByteTab.get(tmp);
            if (ind == null) {
                allBitVectors.add(tmp);
                if (!NfaState.AllBitsSet(tmp)) {
                    if (codeGenerator.isJavaLanguage()) {
                        codeGenerator.genCodeLine("static final " + Options.getLongType() + "[] jjbitVec" + lohiByteCnt + " = " + tmp);
                    } else {
                        codeGenerator.switchToStaticsFile();
                        codeGenerator.genCodeLine("static const " + Options.getLongType() + " jjbitVec" + lohiByteCnt + "[] = " + tmp);
                    }
                }
                ind = new Integer(lohiByteCnt++);
                lohiByteTab.put(tmp, ind);
            }
            NfaState.tmpIndices[cnt++] = ind;
            tmp = "{\n   0x" + Long.toHexString(loBytes[i][0]) + "L, " + "0x" + Long.toHexString(loBytes[i][1]) + "L, " + "0x" + Long.toHexString(loBytes[i][2]) + "L, " + "0x" + Long.toHexString(loBytes[i][3]) + "L\n};";
            ind = (Integer)lohiByteTab.get(tmp);
            if (ind == null) {
                allBitVectors.add(tmp);
                if (!NfaState.AllBitsSet(tmp)) {
                    if (codeGenerator.isJavaLanguage()) {
                        codeGenerator.genCodeLine("static final " + Options.getLongType() + "[] jjbitVec" + lohiByteCnt + " = " + tmp);
                    } else {
                        codeGenerator.switchToStaticsFile();
                        codeGenerator.genCodeLine("static const " + Options.getLongType() + " jjbitVec" + lohiByteCnt + "[] = " + tmp);
                        codeGenerator.switchToMainFile();
                    }
                }
                ind = new Integer(lohiByteCnt++);
                lohiByteTab.put(tmp, ind);
            }
            NfaState.tmpIndices[cnt++] = ind;
            common = null;
        }
        this.nonAsciiMoveIndices = new int[cnt];
        System.arraycopy(tmpIndices, 0, this.nonAsciiMoveIndices, 0, cnt);
        for (i = 0; i < 256; ++i) {
            if (done[i]) {
                loBytes[i] = null;
                continue;
            }
            String tmp = "{\n   0x" + Long.toHexString(loBytes[i][0]) + "L, " + "0x" + Long.toHexString(loBytes[i][1]) + "L, " + "0x" + Long.toHexString(loBytes[i][2]) + "L, " + "0x" + Long.toHexString(loBytes[i][3]) + "L\n};";
            Integer ind = (Integer)lohiByteTab.get(tmp);
            if (ind == null) {
                allBitVectors.add(tmp);
                if (!NfaState.AllBitsSet(tmp)) {
                    if (codeGenerator.isJavaLanguage()) {
                        codeGenerator.genCodeLine("static final " + Options.getLongType() + "[] jjbitVec" + lohiByteCnt + " = " + tmp);
                    } else {
                        codeGenerator.switchToStaticsFile();
                        codeGenerator.genCodeLine("static const " + Options.getLongType() + " jjbitVec" + lohiByteCnt + "[] = " + tmp);
                    }
                }
                ind = new Integer(lohiByteCnt++);
                lohiByteTab.put(tmp, ind);
            }
            if (this.loByteVec == null) {
                this.loByteVec = new Vector();
            }
            this.loByteVec.add(new Integer(i));
            this.loByteVec.add(ind);
        }
        this.UpdateDuplicateNonAsciiMoves();
    }

    private void UpdateDuplicateNonAsciiMoves() {
        for (int i = 0; i < nonAsciiTableForMethod.size(); ++i) {
            NfaState tmp = (NfaState)nonAsciiTableForMethod.get(i);
            if (!NfaState.EqualLoByteVectors(this.loByteVec, tmp.loByteVec) || !NfaState.EqualNonAsciiMoveIndices(this.nonAsciiMoveIndices, tmp.nonAsciiMoveIndices)) continue;
            this.nonAsciiMethod = i;
            return;
        }
        this.nonAsciiMethod = nonAsciiTableForMethod.size();
        nonAsciiTableForMethod.add(this);
    }

    private static boolean EqualLoByteVectors(List vec1, List vec2) {
        if (vec1 == null || vec2 == null) {
            return false;
        }
        if (vec1 == vec2) {
            return true;
        }
        if (vec1.size() != vec2.size()) {
            return false;
        }
        for (int i = 0; i < vec1.size(); ++i) {
            if (((Integer)vec1.get(i)).intValue() == ((Integer)vec2.get(i)).intValue()) continue;
            return false;
        }
        return true;
    }

    private static boolean EqualNonAsciiMoveIndices(int[] moves1, int[] moves2) {
        if (moves1 == moves2) {
            return true;
        }
        if (moves1 == null || moves2 == null) {
            return false;
        }
        if (moves1.length != moves2.length) {
            return false;
        }
        for (int i = 0; i < moves1.length; ++i) {
            if (moves1[i] == moves2[i]) continue;
            return false;
        }
        return true;
    }

    static boolean AllBitsSet(String bitVec) {
        return bitVec.equals(allBits);
    }

    static int AddStartStateSet(String stateSetString) {
        return NfaState.AddCompositeStateSet(stateSetString, true);
    }

    private static int AddCompositeStateSet(String stateSetString, boolean starts) {
        Integer stateNameToReturn = (Integer)stateNameForComposite.get(stateSetString);
        if (stateNameToReturn != null) {
            return stateNameToReturn;
        }
        int toRet = 0;
        int[] nameSet = (int[])allNextStates.get(stateSetString);
        if (!starts) {
            stateBlockTable.put(stateSetString, stateSetString);
        }
        if (nameSet == null) {
            throw new Error("JavaCC Bug: Please send mail to sankar@cs.stanford.edu; nameSet null for : " + stateSetString);
        }
        if (nameSet.length == 1) {
            stateNameToReturn = new Integer(nameSet[0]);
            stateNameForComposite.put(stateSetString, stateNameToReturn);
            return nameSet[0];
        }
        for (int i = 0; i < nameSet.length; ++i) {
            if (nameSet[i] == -1) continue;
            NfaState st = (NfaState)indexedAllStates.get(nameSet[i]);
            st.isComposite = true;
            st.compositeStates = nameSet;
        }
        while (toRet < nameSet.length && starts && ((NfaState)NfaState.indexedAllStates.get((int)nameSet[toRet])).inNextOf > 1) {
            ++toRet;
        }
        Enumeration e = compositeStateTable.keys();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            if (s.equals(stateSetString) || !NfaState.Intersect(stateSetString, s)) continue;
            int[] other = (int[])compositeStateTable.get(s);
            while (toRet < nameSet.length && (starts && ((NfaState)NfaState.indexedAllStates.get((int)nameSet[toRet])).inNextOf > 1 || NfaState.ElemOccurs(nameSet[toRet], other) >= 0)) {
                ++toRet;
            }
        }
        int tmp = toRet >= nameSet.length ? (dummyStateIndex == -1 ? (dummyStateIndex = generatedStates) : ++dummyStateIndex) : nameSet[toRet];
        stateNameToReturn = new Integer(tmp);
        stateNameForComposite.put(stateSetString, stateNameToReturn);
        compositeStateTable.put(stateSetString, nameSet);
        return tmp;
    }

    private static int StateNameForComposite(String stateSetString) {
        return (Integer)stateNameForComposite.get(stateSetString);
    }

    static int InitStateName() {
        String s = LexGen.initialState.GetEpsilonMovesString();
        if (LexGen.initialState.usefulEpsilonMoves != 0) {
            return NfaState.StateNameForComposite(s);
        }
        return -1;
    }

    public void GenerateInitMoves(CodeGenerator codeGenerator) {
        this.GetEpsilonMovesString();
        if (this.epsilonMovesString == null) {
            this.epsilonMovesString = "null;";
        }
        NfaState.AddStartStateSet(this.epsilonMovesString);
    }

    private static int[] GetStateSetIndicesForUse(String arrayString) {
        int[] set = (int[])allNextStates.get(arrayString);
        int[] ret = (int[])tableToDump.get(arrayString);
        if (ret == null) {
            ret = new int[]{lastIndex, lastIndex + set.length - 1};
            lastIndex += set.length;
            tableToDump.put(arrayString, ret);
            orderedStateSet.add(set);
        }
        return ret;
    }

    public static void DumpStateSets(CodeGenerator codeGenerator) {
        int cnt = 0;
        if (codeGenerator.isJavaLanguage()) {
            codeGenerator.genCode("static final int[] jjnextStates = {");
        } else {
            codeGenerator.switchToStaticsFile();
            codeGenerator.genCode("static const int jjnextStates[] = {");
        }
        for (int i = 0; i < orderedStateSet.size(); ++i) {
            int[] set = (int[])orderedStateSet.get(i);
            for (int j = 0; j < set.length; ++j) {
                if (cnt++ % 16 == 0) {
                    codeGenerator.genCode("\n   ");
                }
                codeGenerator.genCode(set[j] + ", ");
            }
        }
        codeGenerator.genCodeLine("\n};");
        if (!codeGenerator.isJavaLanguage()) {
            codeGenerator.switchToMainFile();
        }
    }

    static String GetStateSetString(int[] states) {
        String retVal = "{ ";
        int i = 0;
        while (i < states.length) {
            retVal = retVal + states[i] + ", ";
            if (i++ <= 0 || i % 16 != 0) continue;
            retVal = retVal + "\n";
        }
        retVal = retVal + "};";
        allNextStates.put(retVal, states);
        return retVal;
    }

    static String GetStateSetString(List states) {
        if (states == null || states.size() == 0) {
            return "null;";
        }
        int[] set = new int[states.size()];
        String retVal = "{ ";
        int i = 0;
        while (i < states.size()) {
            int k = ((NfaState)states.get((int)i)).stateName;
            retVal = retVal + k + ", ";
            set[i] = k;
            if (i++ <= 0 || i % 16 != 0) continue;
            retVal = retVal + "\n";
        }
        retVal = retVal + "};";
        allNextStates.put(retVal, set);
        return retVal;
    }

    static int NumberOfBitsSet(long l) {
        int ret = 0;
        for (int i = 0; i < 63; ++i) {
            if ((l >> i & 1L) == 0L) continue;
            ++ret;
        }
        return ret;
    }

    static int OnlyOneBitSet(long l) {
        int oneSeen = -1;
        for (int i = 0; i < 64; ++i) {
            if ((l >> i & 1L) == 0L) continue;
            if (oneSeen >= 0) {
                return -1;
            }
            oneSeen = i;
        }
        return oneSeen;
    }

    private static int ElemOccurs(int elem, int[] arr) {
        int i = arr.length;
        while (i-- > 0) {
            if (arr[i] != elem) continue;
            return i;
        }
        return -1;
    }

    private boolean FindCommonBlocks() {
        int i;
        String set;
        int[] nameSet;
        if (this.next == null || this.next.usefulEpsilonMoves <= 1) {
            return false;
        }
        if (stateDone == null) {
            stateDone = new boolean[generatedStates];
        }
        if ((nameSet = (int[])allNextStates.get(set = this.next.epsilonMovesString)).length <= 2 || compositeStateTable.get(set) != null) {
            return false;
        }
        int[] freq = new int[nameSet.length];
        boolean[] live = new boolean[nameSet.length];
        int[] count = new int[allNextStates.size()];
        for (i = 0; i < nameSet.length; ++i) {
            if (nameSet[i] == -1 || !(live[i] = !stateDone[nameSet[i]])) continue;
            count[0] = count[0] + 1;
        }
        int blockLen = 0;
        int commonFreq = 0;
        Enumeration e = allNextStates.keys();
        while (e.hasMoreElements()) {
            int j;
            int[] tmpSet = (int[])allNextStates.get(e.nextElement());
            if (tmpSet == nameSet) continue;
            boolean needUpdate = false;
            for (j = 0; j < nameSet.length; ++j) {
                if (nameSet[j] == -1 || !live[j] || NfaState.ElemOccurs(nameSet[j], tmpSet) < 0) continue;
                if (!needUpdate) {
                    needUpdate = true;
                }
                int n = freq[j];
                count[n] = count[n] - 1;
                int n2 = ++commonFreq;
                count[n2] = count[n2] + 1;
                freq[j] = commonFreq;
            }
            if (!needUpdate) continue;
            int foundFreq = -1;
            blockLen = 0;
            for (j = 0; j <= commonFreq; ++j) {
                if (count[j] <= blockLen) continue;
                foundFreq = j;
                blockLen = count[j];
            }
            if (blockLen <= 1) {
                return false;
            }
            for (j = 0; j < nameSet.length; ++j) {
                if (nameSet[j] == -1 || freq[j] == foundFreq) continue;
                live[j] = false;
                int n = freq[j];
                count[n] = count[n] - 1;
            }
        }
        if (blockLen <= 1) {
            return false;
        }
        int[] commonBlock = new int[blockLen];
        int cnt = 0;
        for (i = 0; i < nameSet.length; ++i) {
            if (!live[i]) continue;
            if (((NfaState)NfaState.indexedAllStates.get((int)nameSet[i])).isComposite) {
                return false;
            }
            NfaState.stateDone[nameSet[i]] = true;
            commonBlock[cnt++] = nameSet[i];
        }
        String s = NfaState.GetStateSetString(commonBlock);
        e = allNextStates.keys();
        block6: while (e.hasMoreElements()) {
            boolean firstOne = true;
            String stringToFix = (String)e.nextElement();
            int[] setToFix = (int[])allNextStates.get(stringToFix);
            if (setToFix == commonBlock) continue;
            for (int k = 0; k < cnt; ++k) {
                int at = NfaState.ElemOccurs(commonBlock[k], setToFix);
                if (at < 0) continue block6;
                if (!firstOne) {
                    setToFix[at] = -1;
                }
                firstOne = false;
            }
            if (stateSetsToFix.get(stringToFix) != null) continue;
            stateSetsToFix.put(stringToFix, setToFix);
        }
        this.next.usefulEpsilonMoves -= blockLen - 1;
        NfaState.AddCompositeStateSet(s, false);
        return true;
    }

    private boolean CheckNextOccursTogether() {
        String s;
        if (this.next == null || this.next.usefulEpsilonMoves <= 1) {
            return true;
        }
        String set = this.next.epsilonMovesString;
        int[] nameSet = (int[])allNextStates.get(set);
        if (nameSet.length == 1 || compositeStateTable.get(set) != null || stateSetsToFix.get(set) != null) {
            return false;
        }
        Hashtable<String, int[]> occursIn = new Hashtable<String, int[]>();
        NfaState tmp = (NfaState)allStates.get(nameSet[0]);
        for (int i = 1; i < nameSet.length; ++i) {
            NfaState tmp1 = (NfaState)allStates.get(nameSet[i]);
            if (tmp.inNextOf == tmp1.inNextOf) continue;
            return false;
        }
        Enumeration e = allNextStates.keys();
        while (e.hasMoreElements()) {
            int j;
            s = (String)e.nextElement();
            int[] tmpSet = (int[])allNextStates.get(s);
            if (tmpSet == nameSet) continue;
            int isPresent = 0;
            for (j = 0; j < nameSet.length; ++j) {
                if (NfaState.ElemOccurs(nameSet[j], tmpSet) >= 0) {
                    ++isPresent;
                    continue;
                }
                if (isPresent <= 0) continue;
                return false;
            }
            if (isPresent == j) {
                if (tmpSet.length > nameSet.length) {
                    occursIn.put(s, tmpSet);
                }
                if (compositeStateTable.get(s) == null && stateSetsToFix.get(s) == null) continue;
                return false;
            }
            if (isPresent == 0) continue;
            return false;
        }
        e = occursIn.keys();
        while (e.hasMoreElements()) {
            s = (String)e.nextElement();
            int[] setToFix = (int[])occursIn.get(s);
            if (stateSetsToFix.get(s) == null) {
                stateSetsToFix.put(s, setToFix);
            }
            for (int k = 0; k < setToFix.length; ++k) {
                if (NfaState.ElemOccurs(setToFix[k], nameSet) <= 0) continue;
                setToFix[k] = -1;
            }
        }
        this.next.usefulEpsilonMoves = 1;
        NfaState.AddCompositeStateSet(this.next.epsilonMovesString, false);
        return true;
    }

    private static void FixStateSets() {
        int i;
        Hashtable<String, int[]> fixedSets = new Hashtable<String, int[]>();
        Enumeration e = stateSetsToFix.keys();
        int[] tmp = new int[generatedStates];
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            int[] toFix = (int[])stateSetsToFix.get(s);
            int cnt = 0;
            for (i = 0; i < toFix.length; ++i) {
                if (toFix[i] == -1) continue;
                tmp[cnt++] = toFix[i];
            }
            int[] fixed = new int[cnt];
            System.arraycopy(tmp, 0, fixed, 0, cnt);
            fixedSets.put(s, fixed);
            allNextStates.put(s, fixed);
        }
        for (i = 0; i < allStates.size(); ++i) {
            int[] newSet;
            NfaState tmpState = (NfaState)allStates.get(i);
            if (tmpState.next == null || tmpState.next.usefulEpsilonMoves == 0 || (newSet = (int[])fixedSets.get(tmpState.next.epsilonMovesString)) == null) continue;
            tmpState.FixNextStates(newSet);
        }
    }

    private final void FixNextStates(int[] newSet) {
        this.next.usefulEpsilonMoves = newSet.length;
    }

    private static boolean Intersect(String set1, String set2) {
        if (set1 == null || set2 == null) {
            return false;
        }
        int[] nameSet1 = (int[])allNextStates.get(set1);
        int[] nameSet2 = (int[])allNextStates.get(set2);
        if (nameSet1 == null || nameSet2 == null) {
            return false;
        }
        if (nameSet1 == nameSet2) {
            return true;
        }
        int i = nameSet1.length;
        while (i-- > 0) {
            int j = nameSet2.length;
            while (j-- > 0) {
                if (nameSet1[i] != nameSet2[j]) continue;
                return true;
            }
        }
        return false;
    }

    private static void DumpHeadForCase(CodeGenerator codeGenerator, int byteNum) {
        if (byteNum == 0) {
            codeGenerator.genCodeLine("         " + Options.getLongType() + " l = 1L << curChar;");
            if (!codeGenerator.isJavaLanguage()) {
                codeGenerator.genCodeLine("         (void)l;");
            }
        } else if (byteNum == 1) {
            codeGenerator.genCodeLine("         " + Options.getLongType() + " l = 1L << (curChar & 077);");
            if (!codeGenerator.isJavaLanguage()) {
                codeGenerator.genCodeLine("         (void)l;");
            }
        } else {
            if (Options.isUnicodeEnabled() || unicodeWarningGiven) {
                codeGenerator.genCodeLine("         int hiByte = (curChar >> 8);");
                codeGenerator.genCodeLine("         int i1 = hiByte >> 6;");
                codeGenerator.genCodeLine("         " + Options.getLongType() + " l1 = 1L << (hiByte & 077);");
            }
            codeGenerator.genCodeLine("         int i2 = (curChar & 0xff) >> 6;");
            codeGenerator.genCodeLine("         " + Options.getLongType() + " l2 = 1L << (curChar & 077);");
        }
        codeGenerator.genCodeLine("         do");
        codeGenerator.genCodeLine("         {");
        codeGenerator.genCodeLine("            switch(jjstateSet[--i])");
        codeGenerator.genCodeLine("            {");
    }

    private static Vector PartitionStatesSetForAscii(int[] states, int byteNum) {
        NfaState tmp;
        int[] cardinalities = new int[states.length];
        Vector<NfaState> original = new Vector<NfaState>();
        Vector partition = new Vector();
        original.setSize(states.length);
        int cnt = 0;
        for (int i = 0; i < states.length; ++i) {
            int j;
            tmp = (NfaState)allStates.get(states[i]);
            if (tmp.asciiMoves[byteNum] == 0L) continue;
            int p = NfaState.NumberOfBitsSet(tmp.asciiMoves[byteNum]);
            for (j = 0; j < i && cardinalities[j] > p; ++j) {
            }
            for (int k = i; k > j; --k) {
                cardinalities[k] = cardinalities[k - 1];
            }
            cardinalities[j] = p;
            original.insertElementAt(tmp, j);
            ++cnt;
        }
        original.setSize(cnt);
        while (original.size() > 0) {
            tmp = (NfaState)original.get(0);
            original.removeElement(tmp);
            long bitVec = tmp.asciiMoves[byteNum];
            ArrayList<NfaState> subSet = new ArrayList<NfaState>();
            subSet.add(tmp);
            for (int j = 0; j < original.size(); ++j) {
                NfaState tmp1 = (NfaState)original.get(j);
                if ((tmp1.asciiMoves[byteNum] & bitVec) != 0L) continue;
                bitVec |= tmp1.asciiMoves[byteNum];
                subSet.add(tmp1);
                original.removeElementAt(j--);
            }
            partition.add(subSet);
        }
        return partition;
    }

    private String PrintNoBreak(CodeGenerator codeGenerator, int byteNum, boolean[] dumped) {
        if (this.inNextOf != 1) {
            throw new Error("JavaCC Bug: Please send mail to sankar@cs.stanford.edu");
        }
        dumped[this.stateName] = true;
        if (byteNum >= 0) {
            if (this.asciiMoves[byteNum] != 0L) {
                codeGenerator.genCodeLine("               case " + this.stateName + ":");
                this.DumpAsciiMoveForCompositeState(codeGenerator, byteNum, false);
                return "";
            }
        } else if (this.nonAsciiMethod != -1) {
            codeGenerator.genCodeLine("               case " + this.stateName + ":");
            this.DumpNonAsciiMoveForCompositeState(codeGenerator);
            return "";
        }
        return "               case " + this.stateName + ":\n";
    }

    private static void DumpCompositeStatesAsciiMoves(CodeGenerator codeGenerator, String key, int byteNum, boolean[] dumped) {
        NfaState tmp;
        int i;
        int[] nameSet = (int[])allNextStates.get(key);
        if (nameSet.length == 1 || dumped[NfaState.StateNameForComposite(key)]) {
            return;
        }
        NfaState toBePrinted = null;
        int neededStates = 0;
        NfaState stateForCase = null;
        String toPrint = "";
        boolean stateBlock = stateBlockTable.get(key) != null;
        for (i = 0; i < nameSet.length; ++i) {
            tmp = (NfaState)allStates.get(nameSet[i]);
            if (tmp.asciiMoves[byteNum] != 0L) {
                if (neededStates++ == 1) break;
                toBePrinted = tmp;
            } else {
                dumped[tmp.stateName] = true;
            }
            if (tmp.stateForCase == null) continue;
            if (stateForCase != null) {
                throw new Error("JavaCC Bug: Please send mail to sankar@cs.stanford.edu : ");
            }
            stateForCase = tmp.stateForCase;
        }
        if (stateForCase != null) {
            toPrint = super.PrintNoBreak(codeGenerator, byteNum, dumped);
        }
        if (neededStates == 0) {
            if (stateForCase != null && toPrint.equals("")) {
                codeGenerator.genCodeLine("                  break;");
            }
            return;
        }
        if (neededStates == 1) {
            if (!toPrint.equals("")) {
                codeGenerator.genCode(toPrint);
            }
            codeGenerator.genCodeLine("               case " + NfaState.StateNameForComposite(key) + ":");
            if (!dumped[toBePrinted.stateName] && !stateBlock && toBePrinted.inNextOf > 1) {
                codeGenerator.genCodeLine("               case " + toBePrinted.stateName + ":");
            }
            dumped[toBePrinted.stateName] = true;
            toBePrinted.DumpAsciiMove(codeGenerator, byteNum, dumped);
            return;
        }
        Vector partition = NfaState.PartitionStatesSetForAscii(nameSet, byteNum);
        if (!toPrint.equals("")) {
            codeGenerator.genCode(toPrint);
        }
        int keyState = NfaState.StateNameForComposite(key);
        codeGenerator.genCodeLine("               case " + keyState + ":");
        if (keyState < generatedStates) {
            dumped[keyState] = true;
        }
        for (i = 0; i < partition.size(); ++i) {
            List subSet = (List)partition.get(i);
            for (int j = 0; j < subSet.size(); ++j) {
                tmp = (NfaState)subSet.get(j);
                if (stateBlock) {
                    dumped[tmp.stateName] = true;
                }
                tmp.DumpAsciiMoveForCompositeState(codeGenerator, byteNum, j != 0);
            }
        }
        if (stateBlock) {
            codeGenerator.genCodeLine("                  break;");
        } else {
            codeGenerator.genCodeLine("                  break;");
        }
    }

    private boolean selfLoop() {
        if (this.next == null || this.next.epsilonMovesString == null) {
            return false;
        }
        int[] set = (int[])allNextStates.get(this.next.epsilonMovesString);
        return NfaState.ElemOccurs(this.stateName, set) >= 0;
    }

    private void DumpAsciiMoveForCompositeState(CodeGenerator codeGenerator, int byteNum, boolean elseNeeded) {
        boolean nextIntersects = this.selfLoop();
        for (int j = 0; j < allStates.size(); ++j) {
            NfaState temp1 = (NfaState)allStates.get(j);
            if (this == temp1 || temp1.stateName == -1 || temp1.dummy || this.stateName == temp1.stateName || temp1.asciiMoves[byteNum] == 0L || nextIntersects || !NfaState.Intersect(temp1.next.epsilonMovesString, this.next.epsilonMovesString)) continue;
            nextIntersects = true;
            break;
        }
        String prefix = "";
        if (this.asciiMoves[byteNum] != -1L) {
            int oneBit = NfaState.OnlyOneBitSet(this.asciiMoves[byteNum]);
            if (oneBit != -1) {
                codeGenerator.genCodeLine("                  " + (elseNeeded ? "else " : "") + "if (curChar == " + (64 * byteNum + oneBit) + ")");
            } else {
                codeGenerator.genCodeLine("                  " + (elseNeeded ? "else " : "") + "if ((0x" + Long.toHexString(this.asciiMoves[byteNum]) + "L & l) != 0L)");
            }
            prefix = "   ";
        }
        if (this.kindToPrint != Integer.MAX_VALUE) {
            if (this.asciiMoves[byteNum] != -1L) {
                codeGenerator.genCodeLine("                  {");
            }
            codeGenerator.genCodeLine(prefix + "                  if (kind > " + this.kindToPrint + ")");
            codeGenerator.genCodeLine(prefix + "                     kind = " + this.kindToPrint + ";");
        }
        if (this.next != null && this.next.usefulEpsilonMoves > 0) {
            int[] stateNames = (int[])allNextStates.get(this.next.epsilonMovesString);
            if (this.next.usefulEpsilonMoves == 1) {
                int name = stateNames[0];
                if (nextIntersects) {
                    codeGenerator.genCodeLine(prefix + "                  { jjCheckNAdd(" + name + "); }");
                } else {
                    codeGenerator.genCodeLine(prefix + "                  jjstateSet[jjnewStateCnt++] = " + name + ";");
                }
            } else if (this.next.usefulEpsilonMoves == 2 && nextIntersects) {
                codeGenerator.genCodeLine(prefix + "                  { jjCheckNAddTwoStates(" + stateNames[0] + ", " + stateNames[1] + "); }");
            } else {
                boolean notTwo;
                int[] indices = NfaState.GetStateSetIndicesForUse(this.next.epsilonMovesString);
                boolean bl = notTwo = indices[0] + 1 != indices[1];
                if (nextIntersects) {
                    codeGenerator.genCode(prefix + "                  { jjCheckNAddStates(" + indices[0]);
                    if (notTwo) {
                        jjCheckNAddStatesDualNeeded = true;
                        codeGenerator.genCode(", " + indices[1]);
                    } else {
                        jjCheckNAddStatesUnaryNeeded = true;
                    }
                    codeGenerator.genCodeLine("); }");
                } else {
                    codeGenerator.genCodeLine(prefix + "                  { jjAddStates(" + indices[0] + ", " + indices[1] + "); }");
                }
            }
        }
        if (this.asciiMoves[byteNum] != -1L && this.kindToPrint != Integer.MAX_VALUE) {
            codeGenerator.genCodeLine("                  }");
        }
    }

    private void DumpAsciiMove(CodeGenerator codeGenerator, int byteNum, boolean[] dumped) {
        boolean nextIntersects = this.selfLoop() && this.isComposite;
        boolean onlyState = true;
        for (int j = 0; j < allStates.size(); ++j) {
            NfaState temp1 = (NfaState)allStates.get(j);
            if (this == temp1 || temp1.stateName == -1 || temp1.dummy || this.stateName == temp1.stateName || temp1.asciiMoves[byteNum] == 0L) continue;
            if (onlyState && (this.asciiMoves[byteNum] & temp1.asciiMoves[byteNum]) != 0L) {
                onlyState = false;
            }
            if (!nextIntersects && NfaState.Intersect(temp1.next.epsilonMovesString, this.next.epsilonMovesString)) {
                nextIntersects = true;
            }
            if (dumped[temp1.stateName] || temp1.isComposite || this.asciiMoves[byteNum] != temp1.asciiMoves[byteNum] || this.kindToPrint != temp1.kindToPrint || this.next.epsilonMovesString != temp1.next.epsilonMovesString && (this.next.epsilonMovesString == null || temp1.next.epsilonMovesString == null || !this.next.epsilonMovesString.equals(temp1.next.epsilonMovesString))) continue;
            dumped[temp1.stateName] = true;
            codeGenerator.genCodeLine("               case " + temp1.stateName + ":");
        }
        int oneBit = NfaState.OnlyOneBitSet(this.asciiMoves[byteNum]);
        if (this.asciiMoves[byteNum] != -1L && (this.next == null || this.next.usefulEpsilonMoves == 0) && this.kindToPrint != Integer.MAX_VALUE) {
            String kindCheck = "";
            if (!onlyState) {
                kindCheck = " && kind > " + this.kindToPrint;
            }
            if (oneBit != -1) {
                codeGenerator.genCodeLine("                  if (curChar == " + (64 * byteNum + oneBit) + kindCheck + ")");
            } else {
                codeGenerator.genCodeLine("                  if ((0x" + Long.toHexString(this.asciiMoves[byteNum]) + "L & l) != 0L" + kindCheck + ")");
            }
            codeGenerator.genCodeLine("                     kind = " + this.kindToPrint + ";");
            if (onlyState) {
                codeGenerator.genCodeLine("                  break;");
            } else {
                codeGenerator.genCodeLine("                  break;");
            }
            return;
        }
        String prefix = "";
        if (this.kindToPrint != Integer.MAX_VALUE) {
            if (oneBit != -1) {
                codeGenerator.genCodeLine("                  if (curChar != " + (64 * byteNum + oneBit) + ")");
                codeGenerator.genCodeLine("                     break;");
            } else if (this.asciiMoves[byteNum] != -1L) {
                codeGenerator.genCodeLine("                  if ((0x" + Long.toHexString(this.asciiMoves[byteNum]) + "L & l) == 0L)");
                codeGenerator.genCodeLine("                     break;");
            }
            if (onlyState) {
                codeGenerator.genCodeLine("                  kind = " + this.kindToPrint + ";");
            } else {
                codeGenerator.genCodeLine("                  if (kind > " + this.kindToPrint + ")");
                codeGenerator.genCodeLine("                     kind = " + this.kindToPrint + ";");
            }
        } else if (oneBit != -1) {
            codeGenerator.genCodeLine("                  if (curChar == " + (64 * byteNum + oneBit) + ")");
            prefix = "   ";
        } else if (this.asciiMoves[byteNum] != -1L) {
            codeGenerator.genCodeLine("                  if ((0x" + Long.toHexString(this.asciiMoves[byteNum]) + "L & l) != 0L)");
            prefix = "   ";
        }
        if (this.next != null && this.next.usefulEpsilonMoves > 0) {
            int[] stateNames = (int[])allNextStates.get(this.next.epsilonMovesString);
            if (this.next.usefulEpsilonMoves == 1) {
                int name = stateNames[0];
                if (nextIntersects) {
                    codeGenerator.genCodeLine(prefix + "                  { jjCheckNAdd(" + name + "); }");
                } else {
                    codeGenerator.genCodeLine(prefix + "                  jjstateSet[jjnewStateCnt++] = " + name + ";");
                }
            } else if (this.next.usefulEpsilonMoves == 2 && nextIntersects) {
                codeGenerator.genCodeLine(prefix + "                  { jjCheckNAddTwoStates(" + stateNames[0] + ", " + stateNames[1] + "); }");
            } else {
                boolean notTwo;
                int[] indices = NfaState.GetStateSetIndicesForUse(this.next.epsilonMovesString);
                boolean bl = notTwo = indices[0] + 1 != indices[1];
                if (nextIntersects) {
                    codeGenerator.genCode(prefix + "                  { jjCheckNAddStates(" + indices[0]);
                    if (notTwo) {
                        jjCheckNAddStatesDualNeeded = true;
                        codeGenerator.genCode(", " + indices[1]);
                    } else {
                        jjCheckNAddStatesUnaryNeeded = true;
                    }
                    codeGenerator.genCodeLine("); }");
                } else {
                    codeGenerator.genCodeLine(prefix + "                  { jjAddStates(" + indices[0] + ", " + indices[1] + "); }");
                }
            }
        }
        if (onlyState) {
            codeGenerator.genCodeLine("                  break;");
        } else {
            codeGenerator.genCodeLine("                  break;");
        }
    }

    private static void DumpAsciiMoves(CodeGenerator codeGenerator, int byteNum) {
        boolean[] dumped = new boolean[Math.max(generatedStates, dummyStateIndex + 1)];
        Enumeration e = compositeStateTable.keys();
        NfaState.DumpHeadForCase(codeGenerator, byteNum);
        while (e.hasMoreElements()) {
            NfaState.DumpCompositeStatesAsciiMoves(codeGenerator, (String)e.nextElement(), byteNum, dumped);
        }
        for (int i = 0; i < allStates.size(); ++i) {
            NfaState temp = (NfaState)allStates.get(i);
            if (dumped[temp.stateName]) continue;
            if (temp.lexState != LexGen.lexStateIndex || !temp.HasTransitions() || temp.dummy || temp.stateName == -1) continue;
            String toPrint = "";
            if (temp.stateForCase != null) {
                if (temp.inNextOf == 1 || dumped[temp.stateForCase.stateName]) continue;
                toPrint = temp.stateForCase.PrintNoBreak(codeGenerator, byteNum, dumped);
                if (temp.asciiMoves[byteNum] == 0L) {
                    if (!toPrint.equals("")) continue;
                    codeGenerator.genCodeLine("                  break;");
                    continue;
                }
            }
            if (temp.asciiMoves[byteNum] == 0L) continue;
            if (!toPrint.equals("")) {
                codeGenerator.genCode(toPrint);
            }
            dumped[temp.stateName] = true;
            codeGenerator.genCodeLine("               case " + temp.stateName + ":");
            temp.DumpAsciiMove(codeGenerator, byteNum, dumped);
        }
        if (byteNum != 0 && byteNum != 1) {
            codeGenerator.genCodeLine("               default : if (i1 == 0 || l1 == 0 || i2 == 0 ||  l2 == 0) break; else break;");
        } else {
            codeGenerator.genCodeLine("               default : break;");
        }
        codeGenerator.genCodeLine("            }");
        codeGenerator.genCodeLine("         } while(i != startsAt);");
    }

    private static void DumpCompositeStatesNonAsciiMoves(CodeGenerator codeGenerator, String key, boolean[] dumped) {
        NfaState tmp;
        int i;
        int[] nameSet = (int[])allNextStates.get(key);
        if (nameSet.length == 1 || dumped[NfaState.StateNameForComposite(key)]) {
            return;
        }
        NfaState toBePrinted = null;
        int neededStates = 0;
        NfaState stateForCase = null;
        String toPrint = "";
        boolean stateBlock = stateBlockTable.get(key) != null;
        for (i = 0; i < nameSet.length; ++i) {
            tmp = (NfaState)allStates.get(nameSet[i]);
            if (tmp.nonAsciiMethod != -1) {
                if (neededStates++ == 1) break;
                toBePrinted = tmp;
            } else {
                dumped[tmp.stateName] = true;
            }
            if (tmp.stateForCase == null) continue;
            if (stateForCase != null) {
                throw new Error("JavaCC Bug: Please send mail to sankar@cs.stanford.edu : ");
            }
            stateForCase = tmp.stateForCase;
        }
        if (stateForCase != null) {
            toPrint = super.PrintNoBreak(codeGenerator, -1, dumped);
        }
        if (neededStates == 0) {
            if (stateForCase != null && toPrint.equals("")) {
                codeGenerator.genCodeLine("                  break;");
            }
            return;
        }
        if (neededStates == 1) {
            if (!toPrint.equals("")) {
                codeGenerator.genCode(toPrint);
            }
            codeGenerator.genCodeLine("               case " + NfaState.StateNameForComposite(key) + ":");
            if (!dumped[toBePrinted.stateName] && !stateBlock && toBePrinted.inNextOf > 1) {
                codeGenerator.genCodeLine("               case " + toBePrinted.stateName + ":");
            }
            dumped[toBePrinted.stateName] = true;
            toBePrinted.DumpNonAsciiMove(codeGenerator, dumped);
            return;
        }
        if (!toPrint.equals("")) {
            codeGenerator.genCode(toPrint);
        }
        int keyState = NfaState.StateNameForComposite(key);
        codeGenerator.genCodeLine("               case " + keyState + ":");
        if (keyState < generatedStates) {
            dumped[keyState] = true;
        }
        for (i = 0; i < nameSet.length; ++i) {
            tmp = (NfaState)allStates.get(nameSet[i]);
            if (tmp.nonAsciiMethod == -1) continue;
            if (stateBlock) {
                dumped[tmp.stateName] = true;
            }
            tmp.DumpNonAsciiMoveForCompositeState(codeGenerator);
        }
        if (stateBlock) {
            codeGenerator.genCodeLine("                  break;");
        } else {
            codeGenerator.genCodeLine("                  break;");
        }
    }

    private final void DumpNonAsciiMoveForCompositeState(CodeGenerator codeGenerator) {
        boolean nextIntersects = this.selfLoop();
        for (int j = 0; j < allStates.size(); ++j) {
            NfaState temp1 = (NfaState)allStates.get(j);
            if (this == temp1 || temp1.stateName == -1 || temp1.dummy || this.stateName == temp1.stateName || temp1.nonAsciiMethod == -1 || nextIntersects || !NfaState.Intersect(temp1.next.epsilonMovesString, this.next.epsilonMovesString)) continue;
            nextIntersects = true;
            break;
        }
        if (!Options.isUnicodeEnabled() && !unicodeWarningGiven) {
            if (this.loByteVec != null && this.loByteVec.size() > 1) {
                codeGenerator.genCodeLine("                  if ((jjbitVec" + (Integer)this.loByteVec.get(1) + "[i2" + "] & l2) != 0L)");
            }
        } else {
            codeGenerator.genCodeLine("                  if (jjCanMove_" + this.nonAsciiMethod + "(hiByte, i1, i2, l1, l2))");
        }
        if (this.kindToPrint != Integer.MAX_VALUE) {
            codeGenerator.genCodeLine("                  {");
            codeGenerator.genCodeLine("                     if (kind > " + this.kindToPrint + ")");
            codeGenerator.genCodeLine("                        kind = " + this.kindToPrint + ";");
        }
        if (this.next != null && this.next.usefulEpsilonMoves > 0) {
            int[] stateNames = (int[])allNextStates.get(this.next.epsilonMovesString);
            if (this.next.usefulEpsilonMoves == 1) {
                int name = stateNames[0];
                if (nextIntersects) {
                    codeGenerator.genCodeLine("                     { jjCheckNAdd(" + name + "); }");
                } else {
                    codeGenerator.genCodeLine("                     jjstateSet[jjnewStateCnt++] = " + name + ";");
                }
            } else if (this.next.usefulEpsilonMoves == 2 && nextIntersects) {
                codeGenerator.genCodeLine("                     { jjCheckNAddTwoStates(" + stateNames[0] + ", " + stateNames[1] + "); }");
            } else {
                boolean notTwo;
                int[] indices = NfaState.GetStateSetIndicesForUse(this.next.epsilonMovesString);
                boolean bl = notTwo = indices[0] + 1 != indices[1];
                if (nextIntersects) {
                    codeGenerator.genCode("                     { jjCheckNAddStates(" + indices[0]);
                    if (notTwo) {
                        jjCheckNAddStatesDualNeeded = true;
                        codeGenerator.genCode(", " + indices[1]);
                    } else {
                        jjCheckNAddStatesUnaryNeeded = true;
                    }
                    codeGenerator.genCodeLine("); }");
                } else {
                    codeGenerator.genCodeLine("                     { jjAddStates(" + indices[0] + ", " + indices[1] + "); }");
                }
            }
        }
        if (this.kindToPrint != Integer.MAX_VALUE) {
            codeGenerator.genCodeLine("                  }");
        }
    }

    private final void DumpNonAsciiMove(CodeGenerator codeGenerator, boolean[] dumped) {
        boolean nextIntersects = this.selfLoop() && this.isComposite;
        for (int j = 0; j < allStates.size(); ++j) {
            NfaState temp1 = (NfaState)allStates.get(j);
            if (this == temp1 || temp1.stateName == -1 || temp1.dummy || this.stateName == temp1.stateName || temp1.nonAsciiMethod == -1) continue;
            if (!nextIntersects && NfaState.Intersect(temp1.next.epsilonMovesString, this.next.epsilonMovesString)) {
                nextIntersects = true;
            }
            if (dumped[temp1.stateName] || temp1.isComposite || this.nonAsciiMethod != temp1.nonAsciiMethod || this.kindToPrint != temp1.kindToPrint || this.next.epsilonMovesString != temp1.next.epsilonMovesString && (this.next.epsilonMovesString == null || temp1.next.epsilonMovesString == null || !this.next.epsilonMovesString.equals(temp1.next.epsilonMovesString))) continue;
            dumped[temp1.stateName] = true;
            codeGenerator.genCodeLine("               case " + temp1.stateName + ":");
        }
        if (this.next == null || this.next.usefulEpsilonMoves <= 0) {
            String kindCheck = " && kind > " + this.kindToPrint;
            if (!Options.isUnicodeEnabled() && !unicodeWarningGiven) {
                if (this.loByteVec != null && this.loByteVec.size() > 1) {
                    codeGenerator.genCodeLine("                  if ((jjbitVec" + (Integer)this.loByteVec.get(1) + "[i2" + "] & l2) != 0L" + kindCheck + ")");
                }
            } else {
                codeGenerator.genCodeLine("                  if (jjCanMove_" + this.nonAsciiMethod + "(hiByte, i1, i2, l1, l2)" + kindCheck + ")");
            }
            codeGenerator.genCodeLine("                     kind = " + this.kindToPrint + ";");
            codeGenerator.genCodeLine("                  break;");
            return;
        }
        String prefix = "   ";
        if (this.kindToPrint != Integer.MAX_VALUE) {
            if (!Options.isUnicodeEnabled() && !unicodeWarningGiven) {
                if (this.loByteVec != null && this.loByteVec.size() > 1) {
                    codeGenerator.genCodeLine("                  if ((jjbitVec" + (Integer)this.loByteVec.get(1) + "[i2" + "] & l2) == 0L)");
                    codeGenerator.genCodeLine("                     break;");
                }
            } else {
                codeGenerator.genCodeLine("                  if (!jjCanMove_" + this.nonAsciiMethod + "(hiByte, i1, i2, l1, l2))");
                codeGenerator.genCodeLine("                     break;");
            }
            codeGenerator.genCodeLine("                  if (kind > " + this.kindToPrint + ")");
            codeGenerator.genCodeLine("                     kind = " + this.kindToPrint + ";");
            prefix = "";
        } else if (!Options.isUnicodeEnabled() && !unicodeWarningGiven) {
            if (this.loByteVec != null && this.loByteVec.size() > 1) {
                codeGenerator.genCodeLine("                  if ((jjbitVec" + (Integer)this.loByteVec.get(1) + "[i2" + "] & l2) != 0L)");
            }
        } else {
            codeGenerator.genCodeLine("                  if (jjCanMove_" + this.nonAsciiMethod + "(hiByte, i1, i2, l1, l2))");
        }
        if (this.next != null && this.next.usefulEpsilonMoves > 0) {
            int[] stateNames = (int[])allNextStates.get(this.next.epsilonMovesString);
            if (this.next.usefulEpsilonMoves == 1) {
                int name = stateNames[0];
                if (nextIntersects) {
                    codeGenerator.genCodeLine(prefix + "                  { jjCheckNAdd(" + name + "); }");
                } else {
                    codeGenerator.genCodeLine(prefix + "                  jjstateSet[jjnewStateCnt++] = " + name + ";");
                }
            } else if (this.next.usefulEpsilonMoves == 2 && nextIntersects) {
                codeGenerator.genCodeLine(prefix + "                  { jjCheckNAddTwoStates(" + stateNames[0] + ", " + stateNames[1] + "); }");
            } else {
                boolean notTwo;
                int[] indices = NfaState.GetStateSetIndicesForUse(this.next.epsilonMovesString);
                boolean bl = notTwo = indices[0] + 1 != indices[1];
                if (nextIntersects) {
                    codeGenerator.genCode(prefix + "                  { jjCheckNAddStates(" + indices[0]);
                    if (notTwo) {
                        jjCheckNAddStatesDualNeeded = true;
                        codeGenerator.genCode(", " + indices[1]);
                    } else {
                        jjCheckNAddStatesUnaryNeeded = true;
                    }
                    codeGenerator.genCodeLine("); }");
                } else {
                    codeGenerator.genCodeLine(prefix + "                  { jjAddStates(" + indices[0] + ", " + indices[1] + "); }");
                }
            }
        }
        codeGenerator.genCodeLine("                  break;");
    }

    public static void DumpCharAndRangeMoves(CodeGenerator codeGenerator) {
        boolean[] dumped = new boolean[Math.max(generatedStates, dummyStateIndex + 1)];
        Enumeration e = compositeStateTable.keys();
        NfaState.DumpHeadForCase(codeGenerator, -1);
        while (e.hasMoreElements()) {
            NfaState.DumpCompositeStatesNonAsciiMoves(codeGenerator, (String)e.nextElement(), dumped);
        }
        for (int i = 0; i < allStates.size(); ++i) {
            NfaState temp = (NfaState)allStates.get(i);
            if (temp.stateName == -1 || dumped[temp.stateName]) continue;
            if (temp.lexState != LexGen.lexStateIndex || !temp.HasTransitions() || temp.dummy) continue;
            String toPrint = "";
            if (temp.stateForCase != null) {
                if (temp.inNextOf == 1 || dumped[temp.stateForCase.stateName]) continue;
                toPrint = temp.stateForCase.PrintNoBreak(codeGenerator, -1, dumped);
                if (temp.nonAsciiMethod == -1) {
                    if (!toPrint.equals("")) continue;
                    codeGenerator.genCodeLine("                  break;");
                    continue;
                }
            }
            if (temp.nonAsciiMethod == -1) continue;
            if (!toPrint.equals("")) {
                codeGenerator.genCode(toPrint);
            }
            dumped[temp.stateName] = true;
            codeGenerator.genCodeLine("               case " + temp.stateName + ":");
            temp.DumpNonAsciiMove(codeGenerator, dumped);
        }
        if (Options.isUnicodeEnabled() || unicodeWarningGiven) {
            codeGenerator.genCodeLine("               default : if (i1 == 0 || l1 == 0 || i2 == 0 ||  l2 == 0) break; else break;");
        } else {
            codeGenerator.genCodeLine("               default : break;");
        }
        codeGenerator.genCodeLine("            }");
        codeGenerator.genCodeLine("         } while(i != startsAt);");
    }

    public static void DumpNonAsciiMoveMethods(CodeGenerator codeGenerator) {
        if (!Options.isUnicodeEnabled() && !unicodeWarningGiven) {
            return;
        }
        if (nonAsciiTableForMethod.size() <= 0) {
            return;
        }
        for (int i = 0; i < nonAsciiTableForMethod.size(); ++i) {
            NfaState tmp = (NfaState)nonAsciiTableForMethod.get(i);
            tmp.DumpNonAsciiMoveMethod(codeGenerator);
        }
    }

    void DumpNonAsciiMoveMethod(CodeGenerator codeGenerator) {
        int j;
        if (codeGenerator.isJavaLanguage()) {
            codeGenerator.genCodeLine("private static final " + Options.getBooleanType() + " jjCanMove_" + this.nonAsciiMethod + "(int hiByte, int i1, int i2, " + Options.getLongType() + " l1, " + Options.getLongType() + " l2)");
        } else {
            codeGenerator.generateMethodDefHeader("" + Options.getBooleanType() + "", LexGen.tokMgrClassName, "jjCanMove_" + this.nonAsciiMethod + "(int hiByte, int i1, int i2, " + Options.getLongType() + " l1, " + Options.getLongType() + " l2)");
        }
        codeGenerator.genCodeLine("{");
        codeGenerator.genCodeLine("   switch(hiByte)");
        codeGenerator.genCodeLine("   {");
        if (this.loByteVec != null && this.loByteVec.size() > 0) {
            for (j = 0; j < this.loByteVec.size(); j += 2) {
                codeGenerator.genCodeLine("      case " + (Integer)this.loByteVec.get(j) + ":");
                if (!NfaState.AllBitsSet((String)allBitVectors.get((Integer)this.loByteVec.get(j + 1)))) {
                    codeGenerator.genCodeLine("         return ((jjbitVec" + (Integer)this.loByteVec.get(j + 1) + "[i2" + "] & l2) != 0L);");
                    continue;
                }
                codeGenerator.genCodeLine("            return true;");
            }
        }
        codeGenerator.genCodeLine("      default :");
        if (this.nonAsciiMoveIndices != null && (j = this.nonAsciiMoveIndices.length) > 0) {
            do {
                if (!NfaState.AllBitsSet((String)allBitVectors.get(this.nonAsciiMoveIndices[j - 2]))) {
                    codeGenerator.genCodeLine("         if ((jjbitVec" + this.nonAsciiMoveIndices[j - 2] + "[i1] & l1) != 0L)");
                }
                if (!NfaState.AllBitsSet((String)allBitVectors.get(this.nonAsciiMoveIndices[j - 1]))) {
                    codeGenerator.genCodeLine("            if ((jjbitVec" + this.nonAsciiMoveIndices[j - 1] + "[i2] & l2) == 0L)");
                    codeGenerator.genCodeLine("               return false;");
                    codeGenerator.genCodeLine("            else");
                }
                codeGenerator.genCodeLine("            return true;");
            } while ((j -= 2) > 0);
        }
        codeGenerator.genCodeLine("         return false;");
        codeGenerator.genCodeLine("   }");
        codeGenerator.genCodeLine("}");
    }

    private static void ReArrange() {
        List v = allStates;
        allStates = new ArrayList<Object>(Collections.nCopies(generatedStates, null));
        if (allStates.size() != generatedStates) {
            throw new Error("What??");
        }
        for (int j = 0; j < v.size(); ++j) {
            NfaState tmp = (NfaState)v.get(j);
            if (tmp.stateName == -1 || tmp.dummy) continue;
            allStates.set(tmp.stateName, tmp);
        }
    }

    static void PrintBoilerPlate(CodeGenerator codeGenerator) {
        codeGenerator.genCodeLine((Options.getStatic() ? "static " : "") + "private void " + "jjCheckNAdd(int state)");
        codeGenerator.genCodeLine("{");
        codeGenerator.genCodeLine("   if (jjrounds[state] != jjround)");
        codeGenerator.genCodeLine("   {");
        codeGenerator.genCodeLine("      jjstateSet[jjnewStateCnt++] = state;");
        codeGenerator.genCodeLine("      jjrounds[state] = jjround;");
        codeGenerator.genCodeLine("   }");
        codeGenerator.genCodeLine("}");
        codeGenerator.genCodeLine((Options.getStatic() ? "static " : "") + "private void " + "jjAddStates(int start, int end)");
        codeGenerator.genCodeLine("{");
        codeGenerator.genCodeLine("   do {");
        codeGenerator.genCodeLine("      jjstateSet[jjnewStateCnt++] = jjnextStates[start];");
        codeGenerator.genCodeLine("   } while (start++ != end);");
        codeGenerator.genCodeLine("}");
        codeGenerator.genCodeLine((Options.getStatic() ? "static " : "") + "private void " + "jjCheckNAddTwoStates(int state1, int state2)");
        codeGenerator.genCodeLine("{");
        codeGenerator.genCodeLine("   jjCheckNAdd(state1);");
        codeGenerator.genCodeLine("   jjCheckNAdd(state2);");
        codeGenerator.genCodeLine("}");
        codeGenerator.genCodeLine("");
        if (jjCheckNAddStatesDualNeeded) {
            codeGenerator.genCodeLine((Options.getStatic() ? "static " : "") + "private void " + "jjCheckNAddStates(int start, int end)");
            codeGenerator.genCodeLine("{");
            codeGenerator.genCodeLine("   do {");
            codeGenerator.genCodeLine("      jjCheckNAdd(jjnextStates[start]);");
            codeGenerator.genCodeLine("   } while (start++ != end);");
            codeGenerator.genCodeLine("}");
            codeGenerator.genCodeLine("");
        }
        if (jjCheckNAddStatesUnaryNeeded) {
            codeGenerator.genCodeLine((Options.getStatic() ? "static " : "") + "private void " + "jjCheckNAddStates(int start)");
            codeGenerator.genCodeLine("{");
            codeGenerator.genCodeLine("   jjCheckNAdd(jjnextStates[start]);");
            codeGenerator.genCodeLine("   jjCheckNAdd(jjnextStates[start + 1]);");
            codeGenerator.genCodeLine("}");
            codeGenerator.genCodeLine("");
        }
    }

    static void PrintBoilerPlateCPP(CodeGenerator codeGenerator) {
        codeGenerator.switchToIncludeFile();
        codeGenerator.genCodeLine("#define jjCheckNAdd(state)\\");
        codeGenerator.genCodeLine("{\\");
        codeGenerator.genCodeLine("   if (jjrounds[state] != jjround)\\");
        codeGenerator.genCodeLine("   {\\");
        codeGenerator.genCodeLine("      jjstateSet[jjnewStateCnt++] = state;\\");
        codeGenerator.genCodeLine("      jjrounds[state] = jjround;\\");
        codeGenerator.genCodeLine("   }\\");
        codeGenerator.genCodeLine("}");
        codeGenerator.genCodeLine("#define jjAddStates(start, end)\\");
        codeGenerator.genCodeLine("{\\");
        codeGenerator.genCodeLine("   for (int x = start; x <= end; x++) {\\");
        codeGenerator.genCodeLine("      jjstateSet[jjnewStateCnt++] = jjnextStates[x];\\");
        codeGenerator.genCodeLine("   } /*while (start++ != end);*/\\");
        codeGenerator.genCodeLine("}");
        codeGenerator.genCodeLine("#define jjCheckNAddTwoStates(state1, state2)\\");
        codeGenerator.genCodeLine("{\\");
        codeGenerator.genCodeLine("   jjCheckNAdd(state1);\\");
        codeGenerator.genCodeLine("   jjCheckNAdd(state2);\\");
        codeGenerator.genCodeLine("}");
        codeGenerator.genCodeLine("");
        if (jjCheckNAddStatesDualNeeded) {
            codeGenerator.genCodeLine("#define jjCheckNAddStates(start, end)\\");
            codeGenerator.genCodeLine("{\\");
            codeGenerator.genCodeLine("   for (int x = start; x <= end; x++) {\\");
            codeGenerator.genCodeLine("      jjCheckNAdd(jjnextStates[x]);\\");
            codeGenerator.genCodeLine("   } /*while (start++ != end);*/\\");
            codeGenerator.genCodeLine("}");
            codeGenerator.genCodeLine("");
        }
        if (jjCheckNAddStatesUnaryNeeded) {
            codeGenerator.genCodeLine("#define jjCheckNAddStates(start)\\");
            codeGenerator.genCodeLine("{\\");
            codeGenerator.genCodeLine("   jjCheckNAdd(jjnextStates[start]);\\");
            codeGenerator.genCodeLine("   jjCheckNAdd(jjnextStates[start + 1]);\\");
            codeGenerator.genCodeLine("}");
            codeGenerator.genCodeLine("");
        }
        codeGenerator.switchToMainFile();
    }

    private static void FindStatesWithNoBreak() {
        Hashtable<String, String> printed = new Hashtable<String, String>();
        boolean[] put = new boolean[generatedStates];
        int cnt = 0;
        int foundAt = 0;
        block0: for (int j = 0; j < allStates.size(); ++j) {
            NfaState tmp;
            int i;
            String s;
            NfaState stateForCase = null;
            NfaState tmpState = (NfaState)allStates.get(j);
            if (tmpState.stateName == -1 || tmpState.dummy || !tmpState.UsefulState() || tmpState.next == null || tmpState.next.usefulEpsilonMoves < 1 || compositeStateTable.get(s = tmpState.next.epsilonMovesString) != null || printed.get(s) != null) continue;
            printed.put(s, s);
            int[] nexts = (int[])allNextStates.get(s);
            if (nexts.length == 1) continue;
            int state = cnt;
            for (i = 0; i < nexts.length; ++i) {
                state = nexts[i];
                if (state == -1) continue;
                tmp = (NfaState)allStates.get(state);
                if (tmp.isComposite || tmp.inNextOf != 1) continue;
                if (put[state]) {
                    throw new Error("JavaCC Bug: Please send mail to sankar@cs.stanford.edu");
                }
                foundAt = i;
                ++cnt;
                stateForCase = tmp;
                put[state] = true;
                break;
            }
            if (stateForCase == null) continue;
            for (i = 0; i < nexts.length; ++i) {
                state = nexts[i];
                if (state == -1) continue;
                tmp = (NfaState)allStates.get(state);
                if (put[state] || tmp.inNextOf <= 1 || tmp.isComposite || tmp.stateForCase != null) continue;
                ++cnt;
                nexts[i] = -1;
                put[state] = true;
                int toSwap = nexts[0];
                nexts[0] = nexts[foundAt];
                nexts[foundAt] = toSwap;
                tmp.stateForCase = stateForCase;
                stateForCase.stateForCase = tmp;
                stateSetsToFix.put(s, nexts);
                continue block0;
            }
            for (i = 0; i < nexts.length; ++i) {
                state = nexts[i];
                if (state == -1) continue;
                tmp = (NfaState)allStates.get(state);
                if (tmp.inNextOf > 1) continue;
                put[state] = false;
            }
        }
    }

    public static void DumpMoveNfa(CodeGenerator codeGenerator) {
        int[] kindsForStates = null;
        if (kinds == null) {
            kinds = new int[LexGen.maxLexStates][];
            statesForState = new int[LexGen.maxLexStates][][];
        }
        NfaState.ReArrange();
        for (int i = 0; i < allStates.size(); ++i) {
            NfaState temp = (NfaState)allStates.get(i);
            if (temp.lexState != LexGen.lexStateIndex || !temp.HasTransitions() || temp.dummy || temp.stateName == -1) continue;
            if (kindsForStates == null) {
                kindsForStates = new int[generatedStates];
                NfaState.statesForState[LexGen.lexStateIndex] = new int[Math.max(generatedStates, dummyStateIndex + 1)][];
            }
            kindsForStates[temp.stateName] = temp.lookingFor;
            NfaState.statesForState[LexGen.lexStateIndex][temp.stateName] = temp.compositeStates;
            temp.GenerateNonAsciiMoves(codeGenerator);
        }
        Enumeration e = stateNameForComposite.keys();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            int state = (Integer)stateNameForComposite.get(s);
            if (state < generatedStates) continue;
            NfaState.statesForState[LexGen.lexStateIndex][state] = (int[])allNextStates.get(s);
        }
        if (stateSetsToFix.size() != 0) {
            NfaState.FixStateSets();
        }
        NfaState.kinds[LexGen.lexStateIndex] = kindsForStates;
        if (codeGenerator.isJavaLanguage()) {
            Object[] objectArray = new Object[1];
            objectArray[0] = (Options.getStatic() ? "static " : "") + "private int " + "jjMoveNfa" + LexGen.lexStateSuffix + "(int startState, int curPos)";
            codeGenerator.genCodeLine(objectArray);
        } else {
            codeGenerator.generateMethodDefHeader("int", LexGen.tokMgrClassName, "jjMoveNfa" + LexGen.lexStateSuffix + "(int startState, int curPos)");
        }
        codeGenerator.genCodeLine("{");
        if (generatedStates == 0) {
            codeGenerator.genCodeLine("   return curPos;");
            codeGenerator.genCodeLine("}");
            return;
        }
        if (LexGen.mixed[LexGen.lexStateIndex]) {
            codeGenerator.genCodeLine("   int strKind = jjmatchedKind;");
            codeGenerator.genCodeLine("   int strPos = jjmatchedPos;");
            codeGenerator.genCodeLine("   int seenUpto;");
            if (codeGenerator.isJavaLanguage()) {
                codeGenerator.genCodeLine("   input_stream.backup(seenUpto = curPos + 1);");
                codeGenerator.genCodeLine("   try { curChar = input_stream.readChar(); }");
                codeGenerator.genCodeLine("   catch(java.io.IOException e) { throw new Error(\"Internal Error\"); }");
            } else {
                codeGenerator.genCodeLine("   input_stream->backup(seenUpto = curPos + 1);");
                codeGenerator.genCodeLine("   assert(!input_stream->endOfInput());");
                codeGenerator.genCodeLine("   curChar = input_stream->readChar();");
            }
            codeGenerator.genCodeLine("   curPos = 0;");
        }
        codeGenerator.genCodeLine("   int startsAt = 0;");
        codeGenerator.genCodeLine("   jjnewStateCnt = " + generatedStates + ";");
        codeGenerator.genCodeLine("   int i = 1;");
        codeGenerator.genCodeLine("   jjstateSet[0] = startState;");
        if (Options.getDebugTokenManager()) {
            if (codeGenerator.isJavaLanguage()) {
                codeGenerator.genCodeLine("      debugStream.println(\"   Starting NFA to match one of : \" + jjKindsForStateVector(curLexState, jjstateSet, 0, 1));");
            } else {
                codeGenerator.genCodeLine("      fprintf(debugStream, \"   Starting NFA to match one of : %s\\n\", jjKindsForStateVector(curLexState, jjstateSet, 0, 1).c_str());");
            }
        }
        if (Options.getDebugTokenManager()) {
            if (codeGenerator.isJavaLanguage()) {
                codeGenerator.genCodeLine("      debugStream.println(" + (LexGen.maxLexStates > 1 ? "\"<\" + lexStateNames[curLexState] + \">\" + " : "") + "\"Current character : \" + " + Options.getTokenMgrErrorClass() + ".addEscapes(String.valueOf(curChar)) + \" (\" + (int)curChar + \") " + "at line \" + input_stream.getEndLine() + \" column \" + input_stream.getEndColumn());");
            } else {
                codeGenerator.genCodeLine("   fprintf(debugStream, \"<%s>Current character : %c(%d) at line %d column %d\\n\",addUnicodeEscapes(lexStateNames[curLexState]).c_str(), curChar, (int)curChar, input_stream->getEndLine(), input_stream->getEndColumn());");
            }
        }
        codeGenerator.genCodeLine("   int kind = 0x" + Integer.toHexString(Integer.MAX_VALUE) + ";");
        codeGenerator.genCodeLine("   for (;;)");
        codeGenerator.genCodeLine("   {");
        codeGenerator.genCodeLine("      if (++jjround == 0x" + Integer.toHexString(Integer.MAX_VALUE) + ")");
        codeGenerator.genCodeLine("         ReInitRounds();");
        codeGenerator.genCodeLine("      if (curChar < 64)");
        codeGenerator.genCodeLine("      {");
        NfaState.DumpAsciiMoves(codeGenerator, 0);
        codeGenerator.genCodeLine("      }");
        codeGenerator.genCodeLine("      else if (curChar < 128)");
        codeGenerator.genCodeLine("      {");
        NfaState.DumpAsciiMoves(codeGenerator, 1);
        codeGenerator.genCodeLine("      }");
        codeGenerator.genCodeLine("      else");
        codeGenerator.genCodeLine("      {");
        NfaState.DumpCharAndRangeMoves(codeGenerator);
        codeGenerator.genCodeLine("      }");
        codeGenerator.genCodeLine("      if (kind != 0x" + Integer.toHexString(Integer.MAX_VALUE) + ")");
        codeGenerator.genCodeLine("      {");
        codeGenerator.genCodeLine("         jjmatchedKind = kind;");
        codeGenerator.genCodeLine("         jjmatchedPos = curPos;");
        codeGenerator.genCodeLine("         kind = 0x" + Integer.toHexString(Integer.MAX_VALUE) + ";");
        codeGenerator.genCodeLine("      }");
        codeGenerator.genCodeLine("      ++curPos;");
        if (Options.getDebugTokenManager()) {
            if (codeGenerator.isJavaLanguage()) {
                codeGenerator.genCodeLine("      if (jjmatchedKind != 0 && jjmatchedKind != 0x" + Integer.toHexString(Integer.MAX_VALUE) + ")");
                codeGenerator.genCodeLine("         debugStream.println(\"   Currently matched the first \" + (jjmatchedPos + 1) + \" characters as a \" + tokenImage[jjmatchedKind] + \" token.\");");
            } else {
                codeGenerator.genCodeLine("      if (jjmatchedKind != 0 && jjmatchedKind != 0x" + Integer.toHexString(Integer.MAX_VALUE) + ")");
                codeGenerator.genCodeLine("   fprintf(debugStream, \"   Currently matched the first %d characters as a \\\"%s\\\" token.\\n\",  (jjmatchedPos + 1),  addUnicodeEscapes(tokenImage[jjmatchedKind]).c_str());");
            }
        }
        if (codeGenerator.isJavaLanguage()) {
            codeGenerator.genCodeLine("      if ((i = jjnewStateCnt) == (startsAt = " + generatedStates + " - (jjnewStateCnt = startsAt)))");
        } else {
            codeGenerator.genCodeLine("      if ((i = jjnewStateCnt), (jjnewStateCnt = startsAt), (i == (startsAt = " + generatedStates + " - startsAt)))");
        }
        if (LexGen.mixed[LexGen.lexStateIndex]) {
            codeGenerator.genCodeLine("         break;");
        } else {
            codeGenerator.genCodeLine("         return curPos;");
        }
        if (Options.getDebugTokenManager()) {
            if (codeGenerator.isJavaLanguage()) {
                codeGenerator.genCodeLine("      debugStream.println(\"   Possible kinds of longer matches : \" + jjKindsForStateVector(curLexState, jjstateSet, startsAt, i));");
            } else {
                codeGenerator.genCodeLine("      fprintf(debugStream, \"   Possible kinds of longer matches : %s\\n\", jjKindsForStateVector(curLexState, jjstateSet, startsAt, i).c_str());");
            }
        }
        if (codeGenerator.isJavaLanguage()) {
            codeGenerator.genCodeLine("      try { curChar = input_stream.readChar(); }");
        } else {
            if (LexGen.mixed[LexGen.lexStateIndex]) {
                codeGenerator.genCodeLine("      if (input_stream->endOfInput()) { break; }");
            } else {
                codeGenerator.genCodeLine("      if (input_stream->endOfInput()) { return curPos; }");
            }
            codeGenerator.genCodeLine("      curChar = input_stream->readChar();");
        }
        if (LexGen.mixed[LexGen.lexStateIndex]) {
            if (codeGenerator.isJavaLanguage()) {
                codeGenerator.genCodeLine("      catch(java.io.IOException e) { break; }");
            }
        } else if (codeGenerator.isJavaLanguage()) {
            codeGenerator.genCodeLine("      catch(java.io.IOException e) { return curPos; }");
        }
        if (Options.getDebugTokenManager()) {
            if (codeGenerator.isJavaLanguage()) {
                codeGenerator.genCodeLine("      debugStream.println(" + (LexGen.maxLexStates > 1 ? "\"<\" + lexStateNames[curLexState] + \">\" + " : "") + "\"Current character : \" + " + Options.getTokenMgrErrorClass() + ".addEscapes(String.valueOf(curChar)) + \" (\" + (int)curChar + \") " + "at line \" + input_stream.getEndLine() + \" column \" + input_stream.getEndColumn());");
            } else {
                codeGenerator.genCodeLine("   fprintf(debugStream, \"<%s>Current character : %c(%d) at line %d column %d\\n\",addUnicodeEscapes(lexStateNames[curLexState]).c_str(), curChar, (int)curChar, input_stream->getEndLine(), input_stream->getEndColumn());");
            }
        }
        codeGenerator.genCodeLine("   }");
        if (LexGen.mixed[LexGen.lexStateIndex]) {
            codeGenerator.genCodeLine("   if (jjmatchedPos > strPos)");
            codeGenerator.genCodeLine("      return curPos;");
            codeGenerator.genCodeLine("");
            if (codeGenerator.isJavaLanguage()) {
                codeGenerator.genCodeLine("   int toRet = Math.max(curPos, seenUpto);");
            } else {
                codeGenerator.genCodeLine("   int toRet = MAX(curPos, seenUpto);");
            }
            codeGenerator.genCodeLine("");
            codeGenerator.genCodeLine("   if (curPos < toRet)");
            if (codeGenerator.isJavaLanguage()) {
                codeGenerator.genCodeLine("      for (i = toRet - Math.min(curPos, seenUpto); i-- > 0; )");
                codeGenerator.genCodeLine("         try { curChar = input_stream.readChar(); }");
                codeGenerator.genCodeLine("         catch(java.io.IOException e) { throw new Error(\"Internal Error : Please send a bug report.\"); }");
            } else {
                codeGenerator.genCodeLine("      for (i = toRet - MIN(curPos, seenUpto); i-- > 0; )");
                codeGenerator.genCodeLine("        {  assert(!input_stream->endOfInput());");
                codeGenerator.genCodeLine("           curChar = input_stream->readChar(); }");
            }
            codeGenerator.genCodeLine("");
            codeGenerator.genCodeLine("   if (jjmatchedPos < strPos)");
            codeGenerator.genCodeLine("   {");
            codeGenerator.genCodeLine("      jjmatchedKind = strKind;");
            codeGenerator.genCodeLine("      jjmatchedPos = strPos;");
            codeGenerator.genCodeLine("   }");
            codeGenerator.genCodeLine("   else if (jjmatchedPos == strPos && jjmatchedKind > strKind)");
            codeGenerator.genCodeLine("      jjmatchedKind = strKind;");
            codeGenerator.genCodeLine("");
            codeGenerator.genCodeLine("   return toRet;");
        }
        codeGenerator.genCodeLine("}");
        allStates.clear();
    }

    public static void DumpStatesForStateCPP(CodeGenerator codeGenerator) {
        int j;
        if (statesForState == null) {
            assert (false) : "This should never be null.";
            codeGenerator.genCodeLine("null;");
            return;
        }
        codeGenerator.switchToStaticsFile();
        int i = 0;
        while (true) {
            if (i >= LexGen.maxLexStates) break;
            if (statesForState[i] != null) {
                for (j = 0; j < statesForState[i].length; ++j) {
                    int[] stateSet = statesForState[i][j];
                    Object[] objectArray = new Object[1];
                    objectArray[0] = "const int stateSet_" + i + "_" + j + "[" + LexGen.stateSetSize + "] = ";
                    codeGenerator.genCode(objectArray);
                    if (stateSet == null) {
                        codeGenerator.genCodeLine("   { " + j + " };");
                        continue;
                    }
                    codeGenerator.genCode("   { ");
                    for (int k = 0; k < stateSet.length; ++k) {
                        codeGenerator.genCode(stateSet[k] + ", ");
                    }
                    codeGenerator.genCodeLine("};");
                }
            }
            ++i;
        }
        i = 0;
        while (true) {
            if (i >= LexGen.maxLexStates) break;
            codeGenerator.genCodeLine("const int *stateSet_" + i + "[] = {");
            if (statesForState[i] == null) {
                codeGenerator.genCodeLine(" NULL, ");
                codeGenerator.genCodeLine("};");
            } else {
                for (j = 0; j < statesForState[i].length; ++j) {
                    codeGenerator.genCode("stateSet_" + i + "_" + j + ",");
                }
                codeGenerator.genCodeLine("};");
            }
            ++i;
        }
        codeGenerator.genCode("const int** statesForState[] = { ");
        i = 0;
        while (true) {
            if (i >= LexGen.maxLexStates) break;
            codeGenerator.genCodeLine("stateSet_" + i + ", ");
            ++i;
        }
        codeGenerator.genCodeLine("\n};");
        codeGenerator.switchToMainFile();
    }

    public static void DumpStatesForState(CodeGenerator codeGenerator) {
        codeGenerator.genCode("protected static final int[][][] statesForState = ");
        if (statesForState == null) {
            assert (false) : "This should never be null.";
            codeGenerator.genCodeLine("null;");
            return;
        }
        codeGenerator.genCodeLine("{");
        int i = 0;
        while (true) {
            if (i >= LexGen.maxLexStates) break;
            if (statesForState[i] == null) {
                codeGenerator.genCodeLine(" {},");
            } else {
                codeGenerator.genCodeLine(" {");
                for (int j = 0; j < statesForState[i].length; ++j) {
                    int[] stateSet = statesForState[i][j];
                    if (stateSet == null) {
                        codeGenerator.genCodeLine("   { " + j + " },");
                        continue;
                    }
                    codeGenerator.genCode("   { ");
                    for (int k = 0; k < stateSet.length; ++k) {
                        codeGenerator.genCode(stateSet[k] + ", ");
                    }
                    codeGenerator.genCodeLine("},");
                }
                codeGenerator.genCodeLine("},");
            }
            ++i;
        }
        codeGenerator.genCodeLine("\n};");
    }

    public static void DumpStatesForKind(CodeGenerator codeGenerator) {
        if (codeGenerator.isJavaLanguage()) {
            NfaState.DumpStatesForState(codeGenerator);
        } else {
            NfaState.DumpStatesForStateCPP(codeGenerator);
        }
        boolean moreThanOne = false;
        int cnt = 0;
        if (codeGenerator.isJavaLanguage()) {
            codeGenerator.genCode("protected static final int[][] kindForState = ");
        } else {
            codeGenerator.switchToStaticsFile();
            Object[] objectArray = new Object[1];
            objectArray[0] = "static const int kindForState[" + LexGen.stateSetSize + "][" + LexGen.stateSetSize + "] = ";
            codeGenerator.genCode(objectArray);
        }
        if (kinds == null) {
            codeGenerator.genCodeLine("null;");
            return;
        }
        codeGenerator.genCodeLine("{");
        for (int i = 0; i < kinds.length; ++i) {
            if (moreThanOne) {
                codeGenerator.genCodeLine(",");
            }
            moreThanOne = true;
            if (kinds[i] == null) {
                codeGenerator.genCodeLine("{}");
                continue;
            }
            cnt = 0;
            codeGenerator.genCode("{ ");
            for (int j = 0; j < kinds[i].length; ++j) {
                if (cnt % 15 == 0) {
                    codeGenerator.genCode("\n  ");
                } else if (cnt > 1) {
                    codeGenerator.genCode(" ");
                }
                codeGenerator.genCode(kinds[i][j]);
                codeGenerator.genCode(", ");
            }
            codeGenerator.genCode("}");
        }
        codeGenerator.genCodeLine("\n};");
        codeGenerator.switchToMainFile();
    }

    public static void reInit() {
        unicodeWarningGiven = false;
        generatedStates = 0;
        idCnt = 0;
        lohiByteCnt = 0;
        dummyStateIndex = -1;
        done = false;
        mark = null;
        stateDone = null;
        allStates = new ArrayList();
        indexedAllStates = new ArrayList();
        nonAsciiTableForMethod = new ArrayList();
        equivStatesTable = new Hashtable();
        allNextStates = new Hashtable();
        lohiByteTab = new Hashtable();
        stateNameForComposite = new Hashtable();
        compositeStateTable = new Hashtable();
        stateBlockTable = new Hashtable();
        stateSetsToFix = new Hashtable();
        allBitVectors = new ArrayList();
        tmpIndices = new int[512];
        allBits = "{\n   0xffffffffffffffffL, 0xffffffffffffffffL, 0xffffffffffffffffL, 0xffffffffffffffffL\n};";
        tableToDump = new Hashtable();
        orderedStateSet = new ArrayList();
        lastIndex = 0;
        jjCheckNAddStatesUnaryNeeded = false;
        jjCheckNAddStatesDualNeeded = false;
        kinds = null;
        statesForState = null;
    }

    static {
        dummyStateIndex = -1;
        allStates = new ArrayList();
        indexedAllStates = new ArrayList();
        nonAsciiTableForMethod = new ArrayList();
        equivStatesTable = new Hashtable();
        allNextStates = new Hashtable();
        lohiByteTab = new Hashtable();
        stateNameForComposite = new Hashtable();
        compositeStateTable = new Hashtable();
        stateBlockTable = new Hashtable();
        stateSetsToFix = new Hashtable();
        jjCheckNAddStatesUnaryNeeded = false;
        jjCheckNAddStatesDualNeeded = false;
        allBitVectors = new ArrayList();
        tmpIndices = new int[512];
        allBits = "{\n   0xffffffffffffffffL, 0xffffffffffffffffL, 0xffffffffffffffffL, 0xffffffffffffffffL\n};";
        tableToDump = new Hashtable();
        orderedStateSet = new ArrayList();
        lastIndex = 0;
    }
}

