/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import org.javacc.Version;
import org.javacc.parser.JavaCCErrors;
import org.javacc.parser.JavaCCGlobals;
import org.javacc.parser.JavaCCParserConstants;
import org.javacc.parser.Options;
import org.javacc.parser.OutputFile;
import org.javacc.utils.JavaFileGenerator;

public class CPPFiles
extends JavaCCGlobals
implements JavaCCParserConstants {
    static final String charStreamVersion = Version.majorDotMinor;
    static final String tokenManagerVersion = Version.majorDotMinor;
    static final String tokenVersion = Version.majorDotMinor;
    static final String parseExceptionVersion = Version.majorDotMinor;
    static final String tokenMgrErrorVersion = Version.majorDotMinor;

    static String replaceBackslash(String str) {
        int i = 0;
        int len = str.length();
        while (i < len && str.charAt(i++) != '\\') {
        }
        if (i == len) {
            return str;
        }
        StringBuffer b = new StringBuffer();
        for (i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c == '\\') {
                b.append("\\\\");
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static double getVersion(String fileName) {
        String commentHeader = "/* " + CPPFiles.getIdString("JavaCC", fileName) + " Version ";
        File file = new File(Options.getOutputDirectory(), CPPFiles.replaceBackslash(fileName));
        if (!file.exists()) {
            try {
                String majorVersion = Version.versionNumber.replaceAll("[^0-9.]+.*", "");
                return Double.parseDouble(majorVersion);
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }
        BufferedReader reader = null;
        try {
            String str;
            reader = new BufferedReader(new FileReader(file));
            double version = 0.0;
            while ((str = reader.readLine()) != null) {
                if (!str.startsWith(commentHeader)) continue;
                int pos = (str = str.substring(commentHeader.length())).indexOf(32);
                if (pos >= 0) {
                    str = str.substring(0, pos);
                }
                if (str.length() <= 0) break;
                try {
                    version = Double.parseDouble(str);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                    break;
                }
            }
            double d = version;
            return d;
        }
        catch (IOException ioe) {
            double d = 0.0;
            return d;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void genFile(String name, String version, String[] parameters) {
        File file = new File(Options.getOutputDirectory(), name);
        try {
            OutputFile outputFile = new OutputFile(file, version, parameters);
            if (!outputFile.needToWrite) {
                return;
            }
            PrintWriter ostr = outputFile.getPrintWriter();
            JavaFileGenerator generator = new JavaFileGenerator("/templates/cpp/" + name + ".template", Options.getOptions());
            generator.generate(ostr);
            ostr.close();
        }
        catch (IOException e) {
            System.err.println("Failed to create file: " + file + e);
            JavaCCErrors.semantic_error("Could not open file: " + file + " for writing.");
            throw new Error();
        }
    }

    public static void gen_CharStream() {
        String[] parameters = new String[]{"STATIC", "SUPPORT_CLASS_VISIBILITY_PUBLIC"};
        CPPFiles.genFile("CharStream.h", charStreamVersion, parameters);
        CPPFiles.genFile("CharStream.cc", charStreamVersion, parameters);
    }

    public static void gen_ParseException() {
        String[] parameters = new String[]{"STATIC", "SUPPORT_CLASS_VISIBILITY_PUBLIC"};
        CPPFiles.genFile("ParseException.h", parseExceptionVersion, parameters);
        CPPFiles.genFile("ParseException.cc", parseExceptionVersion, parameters);
    }

    public static void gen_TokenMgrError() {
        String[] parameters = new String[]{"STATIC", "SUPPORT_CLASS_VISIBILITY_PUBLIC"};
        CPPFiles.genFile("TokenMgrError.h", tokenMgrErrorVersion, parameters);
        CPPFiles.genFile("TokenMgrError.cc", tokenMgrErrorVersion, parameters);
    }

    public static void gen_Token() {
        String[] parameters = new String[]{"STATIC", "SUPPORT_CLASS_VISIBILITY_PUBLIC", "TOKEN_INCLUDES", "TOKEN_EXTENDS"};
        CPPFiles.genFile("Token.h", tokenMgrErrorVersion, parameters);
        CPPFiles.genFile("Token.cc", tokenMgrErrorVersion, parameters);
    }

    public static void gen_TokenManager() {
        String[] parameters = new String[]{"STATIC", "SUPPORT_CLASS_VISIBILITY_PUBLIC"};
        CPPFiles.genFile("TokenManager.h", tokenManagerVersion, parameters);
    }

    public static void gen_JavaCCDefs() {
        String[] parameters = new String[]{"STATIC", "SUPPORT_CLASS_VISIBILITY_PUBLIC"};
        CPPFiles.genFile("JavaCC.h", tokenManagerVersion, parameters);
    }

    public static void gen_ErrorHandler() {
        String[] parameters = new String[]{"STATIC", "SUPPORT_CLASS_VISIBILITY_PUBLIC", "BUILD_PARSER", "BUILD_TOKEN_MANAGER"};
        CPPFiles.genFile("ErrorHandler.h", parseExceptionVersion, parameters);
    }

    public static void reInit() {
    }
}

