/*
 * Decompiled with CFR 0.152.
 */
package wmsplugin;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.tools.I18n;
import wmsplugin.GeorefImage;
import wmsplugin.Grabber;
import wmsplugin.WMSLayer;

public class YAHOOGrabber
extends Thread
implements Grabber {
    protected String baseURL = "file://" + Main.pref.getPreferencesDir() + "plugins/wmsplugin/ymap.html?request=getmap&format=image/jpeg";
    protected String browserCmd;
    protected Bounds b;
    protected Projection proj;
    protected double pixelPerDegree;
    protected GeorefImage image;
    protected MapView mv;
    protected WMSLayer layer;
    protected int width;
    protected int height;
    protected static final NumberFormat latLonFormat = new DecimalFormat("###0.0000000", new DecimalFormatSymbols(Locale.US));

    YAHOOGrabber(String _baseURL, Bounds _b, Projection _proj, double _pixelPerDegree, GeorefImage _image, MapView _mv, WMSLayer _layer) {
        this.browserCmd = _baseURL.replaceFirst("yahoo://", "");
        this.b = _b;
        this.proj = _proj;
        this.pixelPerDegree = _pixelPerDegree;
        this.image = _image;
        this.mv = _mv;
        this.layer = _layer;
        this.setDaemon(true);
        this.setPriority(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block10: {
            this.width = (int)((this.b.max.lon() - this.b.min.lon()) * this.pixelPerDegree);
            this.height = (int)((this.b.max.lat() - this.b.min.lat()) * this.pixelPerDegree);
            try {
                Image img;
                URL url = this.getURL(this.b.min.lon(), this.b.min.lat(), this.b.max.lon(), this.b.max.lat(), this.width, this.height);
                this.image.min = this.proj.latlon2eastNorth(this.b.min);
                this.image.max = this.proj.latlon2eastNorth(this.b.max);
                WMSLayer wMSLayer = this.layer;
                synchronized (wMSLayer) {
                    if (!this.image.isVisible((NavigatableComponent)this.mv)) {
                        this.image.downloadingStarted = false;
                        return;
                    }
                    Process browser = this.browse(url.toString());
                    this.image.image = new BufferedImage(this.width, this.height, 1);
                    img = ImageIO.read(browser.getInputStream()).getScaledInstance(this.width, this.height, 2);
                }
                this.image.image.getGraphics().drawImage(img, 0, 0, null);
                this.image.downloadingStarted = false;
                this.mv.repaint();
            }
            catch (MalformedURLException e) {
                if (this.layer.messageNum-- > 0) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"WMSPlugin (YAHOOGrabber): Illegal url.\n{0}", (Object[])new Object[]{e.getMessage()}));
                }
            }
            catch (IOException e) {
                if (this.layer.messageNum-- > 0) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"WMSPlugin (YAHOOGrabber): IO exception.\n{0}", (Object[])new Object[]{e.getMessage()}));
                }
            }
            catch (NullPointerException e) {
                if (this.layer.messageNum-- <= 0) break block10;
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"WMSPlugin (YAHOOGrabber): Null pointer exception.\n{0}", (Object[])new Object[]{e.getMessage()}));
            }
        }
    }

    protected Process browse(String url) throws IOException {
        ArrayList<String> cmdParams = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(I18n.tr((String)this.browserCmd, (Object[])new Object[]{url}));
        while (st.hasMoreTokens()) {
            cmdParams.add(st.nextToken());
        }
        System.out.println("WMS::Browsing YAHOO: " + cmdParams);
        ProcessBuilder builder = new ProcessBuilder(cmdParams);
        try {
            return builder.start();
        }
        catch (IOException ioe) {
            throw new IOException(I18n.tr((String)"Could not start browser. Please check that the executable path is correct."));
        }
    }

    protected URL getURL(double w, double s, double e, double n, int wi, int ht) throws MalformedURLException {
        String str = this.baseURL + "&bbox=" + latLonFormat.format(w) + "," + latLonFormat.format(s) + "," + latLonFormat.format(e) + "," + latLonFormat.format(n) + "&width=" + wi + "&height=" + ht;
        return new URL(str.replace(" ", "%20"));
    }
}

