/*
 * Decompiled with CFR 0.152.
 */
package wmsplugin;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.io.ProgressInputStream;
import org.openstreetmap.josm.tools.I18n;
import wmsplugin.GeorefImage;
import wmsplugin.Grabber;
import wmsplugin.WMSLayer;

public class WMSGrabber
extends Thread
implements Grabber {
    protected String baseURL;
    protected Bounds b;
    protected Projection proj;
    protected double pixelPerDegree;
    protected GeorefImage image;
    protected MapView mv;
    protected WMSLayer layer;
    public static final NumberFormat latLonFormat = new DecimalFormat("###0.0000000", new DecimalFormatSymbols(Locale.US));

    WMSGrabber(String _baseURL, Bounds _b, Projection _proj, double _pixelPerDegree, GeorefImage _image, MapView _mv, WMSLayer _layer) {
        this.baseURL = _baseURL;
        this.b = _b;
        this.proj = _proj;
        this.pixelPerDegree = _pixelPerDegree;
        this.image = _image;
        this.mv = _mv;
        this.layer = _layer;
        this.setDaemon(true);
        this.setPriority(1);
    }

    public void run() {
        block4: {
            int w = (int)((this.b.max.lon() - this.b.min.lon()) * this.pixelPerDegree);
            int h = (int)((this.b.max.lat() - this.b.min.lat()) * this.pixelPerDegree);
            try {
                URL url = this.getURL(this.b.min.lon(), this.b.min.lat(), this.b.max.lon(), this.b.max.lat(), w, h);
                this.image.min = this.proj.latlon2eastNorth(this.b.min);
                this.image.max = this.proj.latlon2eastNorth(this.b.max);
                this.image.image = this.grab(url);
                this.image.downloadingStarted = false;
                this.mv.repaint();
            }
            catch (MalformedURLException e) {
                if (this.layer.messageNum-- > 0) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"WMSPlugin: Illegal url.\n{0}", (Object[])new Object[]{e.getMessage()}));
                }
            }
            catch (IOException e) {
                if (this.layer.messageNum-- <= 0) break block4;
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"WMSPlugin: IO exception.\n{0}", (Object[])new Object[]{e.getMessage()}));
            }
        }
    }

    protected URL getURL(double w, double s, double e, double n, int wi, int ht) throws MalformedURLException {
        String str = this.baseURL + "&bbox=" + latLonFormat.format(w) + "," + latLonFormat.format(s) + "," + latLonFormat.format(e) + "," + latLonFormat.format(n) + "&width=" + wi + "&height=" + ht;
        return new URL(str.replace(" ", "%20"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferedImage grab(URL url) throws IOException {
        BufferedImage img;
        ProgressInputStream is = new ProgressInputStream(url.openConnection(), null);
        WMSLayer wMSLayer = this.layer;
        synchronized (wMSLayer) {
            if (!this.image.isVisible((NavigatableComponent)this.mv)) {
                return null;
            }
            img = ImageIO.read((InputStream)is);
        }
        is.close();
        return img;
    }
}

