/*
 * Decompiled with CFR 0.152.
 */
package wmsplugin;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import wmsplugin.GeorefImage;
import wmsplugin.Grabber;
import wmsplugin.WMSPlugin;

public class WMSLayer
extends Layer {
    protected static final Icon icon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(WMSPlugin.class.getResource("/images/wms_small.png")));
    public int messageNum = 5;
    protected boolean started = true;
    protected boolean stopAfterPaint = false;
    protected int ImageSize = 500;
    protected int dax = 10;
    protected int day = 10;
    protected int minZoom = 3;
    protected double pixelPerDegree;
    protected GeorefImage[][] images = new GeorefImage[this.dax][this.day];
    protected String baseURL;
    protected final int serializeFormatVersion = 3;

    public WMSLayer() {
        this(I18n.tr((String)"Blank Layer"), null);
        this.initializeImages();
    }

    public WMSLayer(String name, String baseURL) {
        super(name);
        this.initializeImages();
        this.baseURL = baseURL;
    }

    public void initializeImages() {
        this.images = new GeorefImage[this.dax][this.day];
        for (int x = 0; x < this.dax; ++x) {
            for (int y = 0; y < this.day; ++y) {
                this.images[x][y] = new GeorefImage(false);
            }
        }
    }

    public void grab(Bounds b, double _pixelPerDegree) {
        if (this.baseURL == null) {
            return;
        }
        if (this.started || Math.round(this.pixelPerDegree / 10000.0) != Math.round(_pixelPerDegree / 10000.0)) {
            this.initializeImages();
        }
        this.pixelPerDegree = _pixelPerDegree;
        if (!this.started) {
            this.stopAfterPaint = true;
        }
        this.started = true;
    }

    public Icon getIcon() {
        return icon;
    }

    public String getToolTipText() {
        if (this.started) {
            return I18n.tr((String)"WMS layer ({0}), automaticaly downloading in zoom {1}", (Object[])new Object[]{this.name, Math.round(this.pixelPerDegree / 10000.0)});
        }
        return I18n.tr((String)"WMS layer ({0}), downloading in zoom {1}", (Object[])new Object[]{this.name, Math.round(this.pixelPerDegree / 10000.0)});
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void mergeFrom(Layer from) {
    }

    private Bounds XYtoBounds(int x, int y) {
        return new Bounds(new LatLon((double)(x * this.ImageSize) / this.pixelPerDegree, (double)(y * this.ImageSize) / this.pixelPerDegree), new LatLon((double)((x + 1) * this.ImageSize) / this.pixelPerDegree, (double)((y + 1) * this.ImageSize) / this.pixelPerDegree));
    }

    private int modulo(int a, int b) {
        if (a % b >= 0) {
            return a % b;
        }
        return a % b + b;
    }

    public void paint(Graphics g, MapView mv) {
        Bounds b = new Bounds(mv.getLatLon(0, mv.getHeight()), mv.getLatLon(mv.getWidth(), 0));
        int bminx = (int)Math.floor(b.min.lat() * this.pixelPerDegree / (double)this.ImageSize);
        int bminy = (int)Math.floor(b.min.lon() * this.pixelPerDegree / (double)this.ImageSize);
        int bmaxx = (int)Math.ceil(b.max.lat() * this.pixelPerDegree / (double)this.ImageSize);
        int bmaxy = (int)Math.ceil(b.max.lon() * this.pixelPerDegree / (double)this.ImageSize);
        if (!this.started || this.pixelPerDegree / ((double)mv.getWidth() / (b.max.lon() - b.min.lon())) > (double)this.minZoom) {
            for (int x = 0; x < this.dax; ++x) {
                for (int y = 0; y < this.day; ++y) {
                    this.images[this.modulo(x, this.dax)][this.modulo(y, this.day)].paint(g, (NavigatableComponent)mv);
                }
            }
        } else {
            for (int x = bminx; x < bmaxx; ++x) {
                for (int y = bminy; y < bmaxy; ++y) {
                    GeorefImage img = this.images[this.modulo(x, this.dax)][this.modulo(y, this.day)];
                    if (img.paint(g, (NavigatableComponent)mv) || img.downloadingStarted) continue;
                    img.downloadingStarted = true;
                    img.image = null;
                    Grabber gr = WMSPlugin.getGrabber(this.baseURL, this.XYtoBounds(x, y), Main.proj, this.pixelPerDegree, img, mv, this);
                    gr.start();
                }
            }
        }
        if (this.stopAfterPaint) {
            this.started = false;
            this.stopAfterPaint = false;
        }
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
        for (int x = 0; x < this.dax; ++x) {
            for (int y = 0; y < this.day; ++y) {
                if (this.images[x][y] == null) continue;
                v.visit(this.images[x][y].min);
                v.visit(this.images[x][y].max);
            }
        }
    }

    public Object getInfoComponent() {
        return this.getToolTipText();
    }

    public Component[] getMenuEntries() {
        return new Component[]{new JMenuItem((Action)new LayerListDialog.ShowHideLayerAction((Layer)this)), new JMenuItem((Action)new LayerListDialog.DeleteLayerAction((Layer)this)), new JSeparator(), new JMenuItem(new LoadWmsAction()), new JMenuItem(new SaveWmsAction()), new JSeparator(), new JMenuItem(new StartWmsAction()), new JMenuItem(new StopWmsAction()), new JSeparator(), new JMenuItem((Action)new LayerListPopup.InfoAction((Layer)this))};
    }

    public GeorefImage findImage(EastNorth eastNorth) {
        for (int x = 0; x < this.dax; ++x) {
            for (int y = 0; y < this.day; ++y) {
                if (this.images[x][y] == null || this.images[x][y].image == null || this.images[x][y].min == null || this.images[x][y].max == null || !this.images[x][y].contains(eastNorth)) continue;
                return this.images[x][y];
            }
        }
        return null;
    }

    protected static JFileChooser createAndOpenFileChooser(boolean open, boolean multiple) {
        File file;
        int answer;
        String curDir = Main.pref.get("lastDirectory");
        if (curDir.equals("")) {
            curDir = ".";
        }
        JFileChooser fc = new JFileChooser(new File(curDir));
        fc.setMultiSelectionEnabled(multiple);
        for (int i = 0; i < ExtensionFileFilter.filters.length; ++i) {
            fc.addChoosableFileFilter((FileFilter)ExtensionFileFilter.filters[i]);
        }
        fc.setAcceptAllFileFilterUsed(true);
        int n = answer = open ? fc.showOpenDialog(Main.parent) : fc.showSaveDialog(Main.parent);
        if (answer != 0) {
            return null;
        }
        if (!fc.getCurrentDirectory().getAbsolutePath().equals(curDir)) {
            Main.pref.put("lastDirectory", fc.getCurrentDirectory().getAbsolutePath());
        }
        if (!open && ((file = fc.getSelectedFile()) == null || file.exists() && 0 != JOptionPane.showConfirmDialog(Main.parent, I18n.tr((String)"File exists. Overwrite?"), I18n.tr((String)"Overwrite"), 0))) {
            return null;
        }
        return fc;
    }

    public static File openFileDialog(boolean open) {
        JFileChooser fc = WMSLayer.createAndOpenFileChooser(open, false);
        if (fc == null) {
            return null;
        }
        File file = fc.getSelectedFile();
        String fn = file.getPath();
        if (fn.indexOf(46) == -1) {
            FileFilter ff = fc.getFileFilter();
            fn = ff instanceof ExtensionFileFilter ? "." + ((ExtensionFileFilter)ff).defaultExtension : fn + ".osm";
            file = new File(fn);
        }
        return file;
    }

    public class StopWmsAction
    extends AbstractAction {
        public StopWmsAction() {
            super(I18n.tr((String)"Stop automatic downloading"), null);
        }

        public void actionPerformed(ActionEvent ev) {
            WMSLayer.this.started = false;
        }
    }

    public class StartWmsAction
    extends AbstractAction {
        public StartWmsAction() {
            super(I18n.tr((String)"Start automatic downloading"), null);
        }

        public void actionPerformed(ActionEvent ev) {
            WMSLayer.this.started = true;
        }
    }

    public class LoadWmsAction
    extends AbstractAction {
        public LoadWmsAction() {
            super(I18n.tr((String)"Load WMS layer from file"), ImageProvider.get((String)"load"));
        }

        public void actionPerformed(ActionEvent ev) {
            File f = WMSLayer.openFileDialog(true);
            if (f == null) {
                return;
            }
            try {
                FileInputStream fis = new FileInputStream(f);
                ObjectInputStream ois = new ObjectInputStream(fis);
                int sfv = ois.readInt();
                if (sfv != 3) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Unsupported WMS file version; found {0}, expected {1}", (Object[])new Object[]{sfv, 3}), I18n.tr((String)"File Format Error"), 0);
                    return;
                }
                WMSLayer.this.dax = ois.readInt();
                WMSLayer.this.day = ois.readInt();
                WMSLayer.this.ImageSize = ois.readInt();
                WMSLayer.this.pixelPerDegree = ois.readDouble();
                WMSLayer.this.baseURL = (String)ois.readObject();
                WMSLayer.this.images = (GeorefImage[][])ois.readObject();
                ois.close();
                fis.close();
                WMSLayer.this.started = false;
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Error loading file"), I18n.tr((String)"Error"), 0);
                return;
            }
        }
    }

    public class SaveWmsAction
    extends AbstractAction {
        public SaveWmsAction() {
            super(I18n.tr((String)"Save WMS layer to file"), ImageProvider.get((String)"save"));
        }

        public void actionPerformed(ActionEvent ev) {
            File f = WMSLayer.openFileDialog(false);
            try {
                FileOutputStream fos = new FileOutputStream(f);
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                oos.writeInt(3);
                oos.writeInt(WMSLayer.this.dax);
                oos.writeInt(WMSLayer.this.day);
                oos.writeInt(WMSLayer.this.ImageSize);
                oos.writeDouble(WMSLayer.this.pixelPerDegree);
                oos.writeObject(WMSLayer.this.baseURL);
                oos.writeObject(WMSLayer.this.images);
                oos.close();
                fos.close();
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
            }
        }
    }
}

