/*
 * Decompiled with CFR 0.152.
 */
package org.kaintoch.gps.globalsat.dg100;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.kaintoch.gps.globalsat.dg100.Dg100Config;
import org.kaintoch.gps.globalsat.dg100.FileInfoRec;
import org.kaintoch.gps.globalsat.dg100.GpsRec;

public class Response {
    public static final byte typeFileInfo = -69;
    public static final byte typeId = -65;
    public static final byte typeGpsRec = -75;
    public static final byte typeConfig = -73;
    private int typeOfResponse = 0;
    private int cntDataCur = 0;
    private int nextIdx = 0;
    private Dg100Config config = null;
    private List data = new ArrayList(100);
    private long id = 0L;

    private Response(int n) {
        this.typeOfResponse = n;
    }

    public static Response parseResponse(byte[] byArray, int n) {
        Response response;
        block5: {
            byte by;
            ByteBuffer byteBuffer;
            block7: {
                Dg100Config dg100Config;
                block6: {
                    GpsRec gpsRec;
                    block4: {
                        byteBuffer = ByteBuffer.wrap(byArray);
                        by = byteBuffer.get(4);
                        response = new Response(by);
                        byteBuffer.position(5);
                        if (by != -69) break block4;
                        int n2 = byteBuffer.getShort();
                        short s = byteBuffer.getShort();
                        response.cntDataCur = n2;
                        response.nextIdx = s;
                        for (int i = 0; i < n2; ++i) {
                            FileInfoRec fileInfoRec = new FileInfoRec(byteBuffer);
                            response.addRec(fileInfoRec);
                        }
                        break block5;
                    }
                    if (by != -75) break block6;
                    int n3 = 2;
                    int n4 = 0;
                    while (byteBuffer.position() <= n && (gpsRec = new GpsRec(byteBuffer, n3)).isValid() && byteBuffer.position() <= n) {
                        response.addRec(gpsRec);
                        n3 = gpsRec.getDg100TypeOfNextRec();
                        ++n4;
                    }
                    byteBuffer.position(1042);
                    while (byteBuffer.position() <= n && (gpsRec = new GpsRec(byteBuffer, n3)).isValid() && byteBuffer.position() <= n) {
                        response.addRec(gpsRec);
                        n3 = gpsRec.getDg100TypeOfNextRec();
                        ++n4;
                    }
                    break block5;
                }
                if (by != -73) break block7;
                response.config = dg100Config = new Dg100Config(byteBuffer);
                break block5;
            }
            if (by != -65) break block5;
            response.id = 0L;
            for (int i = 0; i < 8; ++i) {
                byte by2 = byteBuffer.get();
                response.id = response.id * 10L + (long)by2;
            }
        }
        return response;
    }

    private void addRec(Object object) {
        this.data.add(object);
    }

    public List getRecs() {
        return this.data;
    }

    public int getCntDataCur() {
        return this.cntDataCur;
    }

    public int getNextIdx() {
        return this.nextIdx;
    }

    public int getTypeOfResponse() {
        return this.typeOfResponse;
    }

    public Dg100Config getConfig() {
        return this.config;
    }

    public long getId() {
        return this.id;
    }
}

