/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.globalsat;

import gnu.io.CommPortIdentifier;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.globalsat.GlobalsatDg100;
import org.openstreetmap.josm.plugins.globalsat.GlobalsatImportDialog;
import org.openstreetmap.josm.tools.I18n;

public class GlobalsatPlugin
extends Plugin {
    GlobalsatImportAction importAction;

    public GlobalsatPlugin() {
        boolean bl = false;
        try {
            Enumeration enumeration = CommPortIdentifier.getPortIdentifiers();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            bl = true;
            JOptionPane.showMessageDialog(Main.parent, "<html>" + I18n.tr((String)"Cannot load library rxtxSerial. If you need support to install it try Globalsat homepage at http://www.raphael-mack.de/josm-globalsat-gpx-import-plugin/") + "</html>");
        }
        if (!bl) {
            this.importAction = new GlobalsatImportAction();
            Main.main.menu.toolsMenu.add((Action)((Object)this.importAction));
        }
    }

    class GlobalsatImportAction
    extends JosmAction {
        public GlobalsatImportAction() {
            super(I18n.tr((String)"Globalsat Import"), "globalsatImport", I18n.tr((String)"Import Data from Globalsat Datalogger DG100 into GPXLayer."), 73, 2, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            GlobalsatImportDialog globalsatImportDialog = new GlobalsatImportDialog();
            JOptionPane jOptionPane = new JOptionPane(globalsatImportDialog, -1, 2);
            JDialog jDialog = jOptionPane.createDialog(Main.parent, I18n.tr((String)"Import"));
            globalsatImportDialog.setOptionPane(jOptionPane);
            jDialog.setVisible(true);
            if ((Integer)jOptionPane.getValue() == 0) {
                GlobalsatDg100 globalsatDg100 = new GlobalsatDg100(globalsatImportDialog.getPort());
                try {
                    GpxData gpxData = globalsatDg100.readData();
                    if (globalsatImportDialog.deleteFilesAfterDownload()) {
                        Main.pref.put("globalsat.deleteAfterDownload", true);
                        globalsatDg100.deleteData();
                    } else {
                        Main.pref.put("globalsat.deleteAfterDownload", false);
                    }
                    if (gpxData != null && gpxData.hasTrackPoints()) {
                        Main.main.addLayer((Layer)new GpxLayer(gpxData, I18n.tr((String)"imported data from {0}", (Object[])new Object[]{"DG 100"})));
                        Main.map.repaint();
                    } else {
                        JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"No data found on device."));
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.out.println(exception.getMessage());
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Connection failed.") + " (" + exception.toString() + ")");
                }
                finally {
                    globalsatDg100.disconnect();
                }
            }
            jDialog.dispose();
        }
    }
}

